/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.gpg.AbstractGpgMojo;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.apache.maven.plugins.gpg.FilesCollector;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="sign", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class GpgSignAttachedMojo
extends AbstractGpgMojo {
    @Parameter(property="gpg.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="${project.build.directory}/gpg", alias="outputDirectory")
    private File ascDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        FilesCollector collector = new FilesCollector(this.project, this.excludes, this.getLog());
        List<FilesCollector.Item> items = collector.collect();
        AbstractGpgSigner signer = this.newSigner(this.project);
        signer.setOutputDirectory(this.ascDirectory);
        signer.setBuildDirectory(new File(this.project.getBuild().getDirectory()));
        signer.setBaseDirectory(this.project.getBasedir());
        this.getLog().info((CharSequence)("Signing " + items.size() + " file" + (items.size() > 1 ? "s" : "") + " with " + (signer.keyname == null ? "default" : signer.keyname) + " secret key."));
        for (FilesCollector.Item item : items) {
            this.getLog().debug((CharSequence)("Generating signature for " + item.getFile()));
            File signature = signer.generateSignatureForArtifact(item.getFile());
            this.projectHelper.attachArtifact(this.project, item.getExtension() + ".asc", item.getClassifier(), signature);
        }
    }
}

