/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.component.repository.ComponentRequirement;

public class DescribeMojo
extends AbstractMojo {
    private String plugin;
    private String groupId;
    private String artifactId;
    private String version;
    private String mojo;
    private PluginManager pluginManager;
    private MavenProjectBuilder projectBuilder;
    private MavenProject project;
    private Settings settings;
    private MavenSession session;
    private ArtifactRepository localRepository;
    private File output;
    private boolean full;
    private boolean medium;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project == null) {
            try {
                this.project = this.projectBuilder.buildStandaloneSuperProject(this.localRepository);
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Error while retrieving the super-project.", (Exception)((Object)e));
            }
        }
        PluginInfo pi = new PluginInfo();
        this.parsePluginLookupInfo(pi);
        PluginDescriptor descriptor = this.lookupPluginDescriptor(pi);
        StringBuffer descriptionBuffer = new StringBuffer();
        if (this.mojo != null && this.mojo.length() > 0) {
            this.describeMojo(descriptor.getMojo(this.mojo), descriptionBuffer);
        } else {
            this.describePlugin(descriptor, descriptionBuffer);
        }
        this.writeDescription(descriptionBuffer);
    }

    /*
     * Unable to fully structure code
     */
    private void writeDescription(StringBuffer descriptionBuffer) throws MojoExecutionException {
        if (this.output != null) {
            block11: {
                out = null;
                try {
                    this.output.getParentFile().mkdirs();
                    out = new FileWriter(this.output);
                    out.write(descriptionBuffer.toString());
                    var5_3 = null;
                    ** if (out == null) goto lbl-1000
                }
                catch (Throwable var4_8) {
                    var5_4 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            this.getLog().debug((CharSequence)"Error closing file output.", (Throwable)e);
                        }
                    }
                    throw var4_8;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)"Error closing file output.", (Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block11;
                    catch (IOException e) {
                        throw new MojoExecutionException("Cannot write plugin/mojo description.", (Exception)e);
                    }
                }
            }
            this.getLog().info((CharSequence)("Wrote descriptions to: " + this.output));
        } else {
            this.getLog().info((CharSequence)descriptionBuffer.toString());
        }
    }

    private PluginDescriptor lookupPluginDescriptor(PluginInfo pi) throws MojoExecutionException, MojoFailureException {
        PluginDescriptor descriptor = null;
        Plugin forLookup = null;
        if (pi.prefix != null) {
            descriptor = this.pluginManager.getPluginDescriptorForPrefix(pi.prefix);
            if (descriptor == null) {
                forLookup = this.pluginManager.getPluginDefinitionForPrefix(pi.prefix, this.session, this.project);
            }
        } else if (pi.groupId != null && pi.artifactId != null) {
            forLookup = new Plugin();
            forLookup.setGroupId(pi.groupId);
            forLookup.setArtifactId(pi.artifactId);
            if (pi.version != null) {
                forLookup.setVersion(pi.version);
            }
        } else {
            throw new MojoFailureException("You must either specify 'groupId' and 'artifactId', or a valid 'plugin' parameter.");
        }
        if (descriptor == null && forLookup != null) {
            try {
                descriptor = this.pluginManager.verifyPlugin(forLookup, this.project, this.settings, this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (PluginManagerException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (PluginVersionResolutionException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("Plugin dependency does not exist: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (InvalidPluginException e) {
                throw new MojoExecutionException("Error retrieving plugin descriptor for:\n\ngroupId: '" + this.groupId + "'\nartifactId: '" + this.artifactId + "'\nversion: '" + this.version + "'\n\n", (Exception)((Object)e));
            }
            catch (PluginNotFoundException e) {
                this.getLog().debug((CharSequence)"Unable to find plugin", (Throwable)e);
                throw new MojoFailureException("Plugin does not exist: " + e.getMessage());
            }
            catch (PluginVersionNotFoundException e) {
                this.getLog().debug((CharSequence)"Unable to find plugin version", (Throwable)e);
                throw new MojoFailureException(e.getMessage());
            }
        }
        if (descriptor == null) {
            throw new MojoFailureException("Plugin could not be found. If you believe it is correct, check your pluginGroups setting, and run with -U to update the remote configuration");
        }
        return descriptor;
    }

    private void parsePluginLookupInfo(PluginInfo pi) throws MojoFailureException {
        if (this.plugin != null && this.plugin.length() > 0) {
            if (this.plugin.indexOf(":") > -1) {
                String[] pluginParts = this.plugin.split(":");
                switch (pluginParts.length) {
                    case 1: {
                        pi.prefix = pluginParts[0];
                        break;
                    }
                    case 2: {
                        pi.groupId = pluginParts[0];
                        pi.artifactId = pluginParts[1];
                        break;
                    }
                    case 3: {
                        pi.groupId = pluginParts[0];
                        pi.artifactId = pluginParts[1];
                        pi.version = pluginParts[2];
                        break;
                    }
                    default: {
                        throw new MojoFailureException("plugin parameter must be a plugin prefix, or conform to: 'groupId:artifactId[:version].");
                    }
                }
            } else {
                pi.prefix = this.plugin;
            }
        } else {
            pi.groupId = this.groupId;
            pi.artifactId = this.artifactId;
            pi.version = this.version;
        }
    }

    private void describePlugin(PluginDescriptor pd, StringBuffer buffer) {
        String name = pd.getName();
        if (name == null) {
            name = pd.getId();
        }
        buffer.append("Plugin: '").append(name).append('\'');
        buffer.append("\n-----------------------------------------------");
        buffer.append("\nGroup Id:  ").append(pd.getGroupId());
        buffer.append("\nArtifact Id: ").append(pd.getArtifactId());
        buffer.append("\nVersion:     ").append(pd.getVersion());
        buffer.append("\nGoal Prefix: ").append(pd.getGoalPrefix());
        buffer.append("\nDescription:\n\n");
        this.prettyAppend(this.formatDescription(pd.getDescription()), buffer);
        buffer.append("\n");
        if (this.full || this.medium) {
            buffer.append("\nMojos:\n");
            String line = "\n===============================================";
            Iterator it = pd.getMojos().iterator();
            while (it.hasNext()) {
                MojoDescriptor md = (MojoDescriptor)it.next();
                if (this.full) {
                    buffer.append(line);
                    buffer.append("\nGoal: '").append(md.getGoal()).append('\'');
                    buffer.append(line);
                    this.describeMojoGuts(md, buffer, true);
                    buffer.append(line);
                    buffer.append("\n\n");
                    continue;
                }
                buffer.append("\nGoal: '").append(md.getGoal()).append('\'');
                this.describeMojoGuts(md, buffer, false);
                buffer.append("\n");
            }
        }
    }

    private String formatDescription(String description) {
        if (description == null) {
            return null;
        }
        String result = description.replaceAll(" ?\\<br\\/?\\> ?", "\n");
        result = result.replaceAll(" ?\\<p\\> ?", "");
        result = result.replaceAll(" ?\\</p\\> ?", "\n\n");
        return result;
    }

    private void prettyAppend(String messagePart, StringBuffer buffer) {
        if (messagePart != null && messagePart.length() > 0) {
            buffer.append(messagePart);
        } else {
            buffer.append("Unknown");
        }
    }

    private void describeMojo(MojoDescriptor md, StringBuffer buffer) {
        String line = "\n===============================================";
        buffer.append("Mojo: '").append(md.getFullGoalName()).append('\'');
        buffer.append(line);
        buffer.append("\nGoal: '").append(md.getGoal()).append("'");
        this.describeMojoGuts(md, buffer, this.full);
        buffer.append(line);
        buffer.append("\n\n");
    }

    private void describeMojoGuts(MojoDescriptor md, StringBuffer buffer, boolean fullDescription) {
        String deprecation;
        buffer.append("\nDescription:\n");
        this.prettyAppend(this.formatDescription(md.getDescription()), buffer);
        if (fullDescription) {
            buffer.append("\n");
        }
        if ((deprecation = md.getDeprecated()) != null) {
            buffer.append("\n\nNOTE: This mojo is deprecated.\n").append(deprecation).append("\n");
        }
        if (fullDescription) {
            buffer.append("\nImplementation: ").append(md.getImplementation());
            buffer.append("\nLanguage: ").append(md.getLanguage());
            String phase = md.getPhase();
            if (phase != null) {
                buffer.append("\nBound to Phase: ").append(phase);
            }
            String eGoal = md.getExecuteGoal();
            String eLife = md.getExecuteLifecycle();
            String ePhase = md.getExecutePhase();
            if (eGoal != null || ePhase != null) {
                buffer.append("\n\nBefore this mojo executes, it will call:\n");
                if (eGoal != null) {
                    buffer.append("\nSingle mojo: '").append(eGoal).append("'");
                }
                if (ePhase != null) {
                    buffer.append("\nPhase: '").append(ePhase).append("'");
                    if (eLife != null) {
                        buffer.append(" in Lifecycle Overlay: '").append(eLife).append("'");
                    }
                }
            }
            this.describeMojoParameters(md, buffer);
            this.describeMojoRequirements(md, buffer);
        }
    }

    private void describeMojoRequirements(MojoDescriptor md, StringBuffer buffer) {
        buffer.append("\n");
        List reqs = md.getRequirements();
        if (reqs == null || reqs.isEmpty()) {
            buffer.append("\nThis mojo doesn't have any component requirements.");
        } else {
            buffer.append("\nComponent Requirements:\n");
            String line = "\n-----------------------------------------------";
            int idx = 0;
            Iterator it = reqs.iterator();
            while (it.hasNext()) {
                ComponentRequirement req = (ComponentRequirement)it.next();
                buffer.append(line);
                buffer.append("\n[").append(idx).append("] ");
                buffer.append("Role: ").append(req.getRole());
                String hint = req.getRoleHint();
                if (hint != null) {
                    buffer.append("\nRole-Hint: ").append(hint);
                }
                buffer.append("\n");
                ++idx;
            }
            buffer.append(line);
        }
    }

    private void describeMojoParameters(MojoDescriptor md, StringBuffer buffer) {
        buffer.append("\n");
        List params = md.getParameters();
        if (params == null || params.isEmpty()) {
            buffer.append("\nThis mojo doesn't use any parameters.");
        } else {
            buffer.append("\nParameters:");
            String line = "\n-----------------------------------------------";
            int idx = 0;
            Iterator it = params.iterator();
            while (it.hasNext()) {
                String defaultVal;
                Parameter parameter = (Parameter)it.next();
                buffer.append(line);
                buffer.append("\n\n[").append(idx++).append("] ");
                buffer.append("Name: ");
                this.prettyAppend(parameter.getName(), buffer);
                String alias = parameter.getAlias();
                if (alias != null) {
                    buffer.append(" (Alias: ").append(alias).append(")");
                }
                buffer.append("\nType: ");
                this.prettyAppend(parameter.getType(), buffer);
                String expression = parameter.getExpression();
                if (expression != null) {
                    buffer.append("\nExpression: ").append(expression);
                }
                if ((defaultVal = parameter.getDefaultValue()) != null) {
                    buffer.append("\nDefault value: '").append(defaultVal);
                }
                buffer.append("\nRequired: ").append(parameter.isRequired());
                buffer.append("\nDirectly editable: ").append(parameter.isEditable());
                buffer.append("\nDescription:\n");
                this.prettyAppend(this.formatDescription(parameter.getDescription()), buffer);
                String deprecation = parameter.getDeprecated();
                if (deprecation != null) {
                    buffer.append("\n\nNOTE: This parameter is deprecated.\n").append(deprecation).append("\n");
                }
                buffer.append("\n");
            }
            buffer.append(line);
        }
    }

    public final String getPlugin() {
        return this.plugin;
    }

    public final void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public final PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public final void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public final String getArtifactId() {
        return this.artifactId;
    }

    public final void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public final String getGroupId() {
        return this.groupId;
    }

    public final void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public final ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public final void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public final String getMojo() {
        return this.mojo;
    }

    public final void setMojo(String mojo) {
        this.mojo = mojo;
    }

    public final File getOutput() {
        return this.output;
    }

    public final void setOutput(File output) {
        this.output = output;
    }

    public final MavenProject getProject() {
        return this.project;
    }

    public final void setProject(MavenProject project) {
        this.project = project;
    }

    public final Settings getSettings() {
        return this.settings;
    }

    public final void setSettings(Settings settings) {
        this.settings = settings;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    private static class PluginInfo {
        String prefix;
        String groupId;
        String artifactId;
        String version;
        String mojo;
        Plugin plugin;
        PluginDescriptor pluginDescriptor;

        private PluginInfo() {
        }
    }
}

