/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class EffectivePomMojo
extends AbstractMojo {
    private MavenProject project;
    private List projects;
    private File output;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        StringBuffer message = new StringBuffer();
        if (this.projects.get(0).equals(this.project)) {
            Iterator it = this.projects.iterator();
            while (it.hasNext()) {
                MavenProject project = (MavenProject)it.next();
                this.getEffectivePom(project, message);
                message.append("\n\n");
            }
        } else {
            this.getEffectivePom(this.project, message);
            message.append("\n\n");
        }
        if (this.output != null) {
            OutputStreamWriter fWriter = null;
            File dir = this.output.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.getLog().info((CharSequence)("Writing effective-POM to: " + this.output));
            fWriter = new FileWriter(this.output);
            fWriter.write("Created by: " + ((Object)((Object)this)).getClass().getName() + "\n");
            fWriter.write("Created on: " + new Date() + "\n\n");
            fWriter.write(message.toString());
            Object var5_5 = null;
            if (fWriter == null) return;
            try {
                fWriter.close();
                return;
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Cannot close FileWriter to output location: " + this.output), (Throwable)e);
            }
            return;
            {
                catch (IOException e) {
                    throw new MojoExecutionException("Cannot write effective-POM to output: " + this.output, (Exception)e);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (fWriter == null) throw throwable;
                try {
                    fWriter.close();
                    throw throwable;
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)("Cannot close FileWriter to output location: " + this.output), (Throwable)e);
                }
                throw throwable;
            }
        }
        StringBuffer formatted = new StringBuffer();
        formatted.append("\nEffective POMs, after inheritance, interpolation, and profiles are applied:\n\n");
        formatted.append(message.toString());
        formatted.append("\n");
        this.getLog().info((CharSequence)message);
    }

    private void getEffectivePom(MavenProject project, StringBuffer message) throws MojoExecutionException {
        Model pom = project.getModel();
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try {
            pomWriter.write((Writer)sWriter, pom);
            message.append("\n************************************************************************************");
            message.append("\nEffective POM for project '" + project.getId() + "'");
            message.append("\n************************************************************************************");
            message.append("\n");
            message.append(sWriter.toString());
            message.append("\n************************************************************************************");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize POM to XML.", (Exception)e);
        }
    }

    protected final void setOutput(File output) {
        this.output = output;
    }

    protected final void setProjects(List projects) {
        this.projects = projects;
    }
}

