/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ActiveProfilesMojo
extends AbstractMojo {
    private List projects;
    private File output;

    public void execute() throws MojoExecutionException {
        StringBuffer message = new StringBuffer();
        Iterator it = this.projects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            this.getActiveProfileStatement(project, message);
            message.append("\n\n");
        }
        if (this.output != null) {
            this.writeFile(message);
        } else {
            Log log = this.getLog();
            log.info((CharSequence)message);
        }
    }

    private void writeFile(StringBuffer message) throws MojoExecutionException {
        Writer writer = null;
        try {
            File dir = this.output.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            writer = new FileWriter(this.output);
            writer.write("Created by: " + ((Object)((Object)this)).getClass().getName() + "\n");
            writer.write("Created on: " + new Date() + "\n\n");
            writer.write(message.toString());
            writer.flush();
            this.getLog().info((CharSequence)("Active profile report written to: " + this.output));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write output to file: " + this.output, (Exception)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)"Failed to close output file writer.", (Throwable)e);
                }
            }
        }
    }

    private void getActiveProfileStatement(MavenProject project, StringBuffer message) {
        List profiles = project.getActiveProfiles();
        message.append("\n");
        message.append("Active Profiles for Project '" + project.getId() + "': \n\n");
        if (profiles == null || profiles.isEmpty()) {
            message.append("There are no active profiles.");
        } else {
            message.append("The following profiles are active:\n");
            Iterator it = profiles.iterator();
            while (it.hasNext()) {
                Profile profile = (Profile)it.next();
                message.append("\n - ").append(profile.getId()).append(" (source: ").append(profile.getSource()).append(")");
            }
        }
        message.append("\n");
    }

    public final void setProjects(List projects) {
        this.projects = projects;
    }
}

