/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.idea;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.idea.AbstractIdeaMojo;
import org.apache.maven.plugin.idea.Library;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.util.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class IdeaModuleMojo
extends AbstractIdeaMojo {
    private List reactorProjects;
    private WagonManager wagonManager;
    private boolean linkModules;
    private String deploymentDescriptorFile;
    private boolean useFullNames;
    private boolean downloadSources;
    private boolean downloadJavadocs;
    private String sourceClassifier;
    private String javadocClassifier;
    private Library[] libraries;
    private String exclude;
    private boolean dependenciesAsLibraries;
    private static Map attemptedDownloads = new HashMap();
    private Set macros;

    public void initParam(MavenProject project, ArtifactFactory artifactFactory, ArtifactRepository localRepo, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, Log log, boolean overwrite, MavenProject executedProject, List reactorProjects, WagonManager wagonManager, boolean linkModules, boolean useFullNames, boolean downloadSources, String sourceClassifier, boolean downloadJavadocs, String javadocClassifier, Library[] libraries, Set macros, String exclude, boolean useShortDependencyNames) {
        super.initParam(project, artifactFactory, localRepo, artifactResolver, artifactMetadataSource, log, overwrite);
        this.reactorProjects = reactorProjects;
        this.wagonManager = wagonManager;
        this.linkModules = linkModules;
        this.useFullNames = useFullNames;
        this.downloadSources = downloadSources;
        this.sourceClassifier = sourceClassifier;
        this.downloadJavadocs = downloadJavadocs;
        this.javadocClassifier = javadocClassifier;
        this.libraries = libraries;
        this.macros = macros;
        this.exclude = exclude;
        this.dependenciesAsLibraries = useShortDependencyNames;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.rewriteModule();
    }

    public void rewriteModule() throws MojoExecutionException {
        File moduleFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iml");
        try {
            String directory;
            Resource resource;
            String directory2;
            Document document = this.readXmlDocument(moduleFile, "module.xml");
            Element module = document.getRootElement();
            if ("war".equals(this.executedProject.getPackaging())) {
                this.addWebModule(module);
            } else if ("ejb".equals(this.executedProject.getPackaging())) {
                this.addEjbModule(module);
            } else if ("ear".equals(this.executedProject.getPackaging())) {
                this.addEarModule(module);
            }
            Element component = this.findComponent(module, "NewModuleRootManager");
            Element output = this.findElement(component, "output");
            output.addAttribute("url", this.getModuleFileUrl(this.executedProject.getBuild().getOutputDirectory()));
            Element outputTest = this.findElement(component, "output-test");
            outputTest.addAttribute("url", this.getModuleFileUrl(this.executedProject.getBuild().getTestOutputDirectory()));
            Element content = this.findElement(component, "content");
            this.removeOldElements(content, "sourceFolder");
            Iterator i = this.executedProject.getCompileSourceRoots().iterator();
            while (i.hasNext()) {
                directory2 = (String)i.next();
                this.addSourceFolder(content, directory2, false);
            }
            i = this.executedProject.getTestCompileSourceRoots().iterator();
            while (i.hasNext()) {
                directory2 = (String)i.next();
                this.addSourceFolder(content, directory2, true);
            }
            i = this.executedProject.getBuild().getResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                directory = resource.getDirectory();
                if (resource.getTargetPath() == null && !resource.isFiltering()) {
                    this.addSourceFolder(content, directory, false);
                    continue;
                }
                this.getLog().info((CharSequence)("Not adding resource directory as it has an incompatible target path or filtering: " + directory));
            }
            i = this.executedProject.getBuild().getTestResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                directory = resource.getDirectory();
                if (resource.getTargetPath() == null && !resource.isFiltering()) {
                    this.addSourceFolder(content, directory, true);
                    continue;
                }
                this.getLog().info((CharSequence)("Not adding test resource directory as it has an incompatible target path or filtering: " + directory));
            }
            this.removeOldElements(content, "excludeFolder");
            File target = new File(this.executedProject.getBuild().getDirectory());
            File classes = new File(this.executedProject.getBuild().getOutputDirectory());
            File testClasses = new File(this.executedProject.getBuild().getTestOutputDirectory());
            List sourceFolders = content.elements("sourceFolder");
            ArrayList filteredExcludes = new ArrayList();
            filteredExcludes.addAll(this.getExcludedDirectories(target, filteredExcludes, sourceFolders));
            filteredExcludes.addAll(this.getExcludedDirectories(classes, filteredExcludes, sourceFolders));
            filteredExcludes.addAll(this.getExcludedDirectories(testClasses, filteredExcludes, sourceFolders));
            if (this.exclude != null) {
                String[] dirs = this.exclude.split("[,\\s]+");
                for (int i2 = 0; i2 < dirs.length; ++i2) {
                    File excludedDir = new File(this.executedProject.getBasedir(), dirs[i2]);
                    filteredExcludes.addAll(this.getExcludedDirectories(excludedDir, filteredExcludes, sourceFolders));
                }
            }
            ArrayList<String> actuallyExcluded = new ArrayList<String>();
            Collections.sort(filteredExcludes);
            Iterator i3 = filteredExcludes.iterator();
            while (i3.hasNext()) {
                String dirToExclude = i3.next().toString();
                String dirToExcludeTemp = dirToExclude.replace('\\', '/');
                boolean addExclude = true;
                Iterator iterator = ((AbstractList)actuallyExcluded).iterator();
                while (iterator.hasNext()) {
                    String dir = iterator.next().toString();
                    String dirTemp = dir.replace('\\', '/');
                    if (dirToExcludeTemp.startsWith(dirTemp + "/")) {
                        addExclude = false;
                        break;
                    }
                    if (!dir.startsWith(dirToExcludeTemp + "/")) continue;
                    actuallyExcluded.remove(dir);
                }
                if (!addExclude) continue;
                actuallyExcluded.add(dirToExclude);
                this.addExcludeFolder(content, dirToExclude);
            }
            this.rewriteDependencies(component);
            this.writeXmlDocument(moduleFile, document);
        }
        catch (DocumentException e) {
            throw new MojoExecutionException("Error parsing existing IML file " + moduleFile.getAbsolutePath(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error parsing existing IML file " + moduleFile.getAbsolutePath(), (Exception)e);
        }
    }

    private void rewriteDependencies(Element component) {
        HashMap<String, Element> modulesByName = new HashMap<String, Element>();
        HashMap<String, Element> modulesByUrl = new HashMap<String, Element>();
        HashSet<Element> unusedModules = new HashSet<Element>();
        Iterator children = component.elementIterator("orderEntry");
        while (children.hasNext()) {
            String url;
            Element rootChild;
            Element orderEntry = (Element)children.next();
            String type = orderEntry.attributeValue("type");
            if ("module".equals(type)) {
                modulesByName.put(orderEntry.attributeValue("module-name"), orderEntry);
                continue;
            }
            if (!"module-library".equals(type)) continue;
            unusedModules.add(orderEntry);
            Element lib = orderEntry.element("library");
            String name = lib.attributeValue("name");
            if (name != null) {
                modulesByName.put(name, orderEntry);
                continue;
            }
            Element classesChild = lib.element("CLASSES");
            if (classesChild == null || (rootChild = classesChild.element("root")) == null || (url = rootChild.attributeValue("url")) == null) continue;
            modulesByUrl.put(url.toLowerCase(), orderEntry);
        }
        List testClasspathElements = this.executedProject.getTestArtifacts();
        Iterator i = testClasspathElements.iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            Library library = this.findLibrary(a);
            if (library != null && library.isExclude()) continue;
            String moduleName = this.useFullNames ? a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getType() + ':' + a.getVersion() : a.getArtifactId();
            Element dep = (Element)modulesByName.get(moduleName);
            if (dep == null) {
                dep = (Element)modulesByUrl.get(this.getLibraryUrl(a).toLowerCase());
            }
            if (dep != null) {
                unusedModules.remove(dep);
            } else {
                dep = this.createElement(component, "orderEntry");
            }
            boolean isIdeaModule = false;
            if (this.linkModules && (isIdeaModule = this.isReactorProject(a.getGroupId(), a.getArtifactId()))) {
                dep.addAttribute("type", "module");
                dep.addAttribute("module-name", moduleName);
            }
            if (a.getFile() == null || isIdeaModule) continue;
            dep.addAttribute("type", "module-library");
            Element lib = dep.element("library");
            if (lib == null) {
                lib = this.createElement(dep, "library");
            }
            if (this.dependenciesAsLibraries) {
                lib.addAttribute("name", moduleName);
            }
            this.removeOldElements(lib, "CLASSES");
            Element classes = this.createElement(lib, "CLASSES");
            if (library != null && library.getSplitClasses().length > 0) {
                lib.addAttribute("name", moduleName);
                String[] libraryClasses = library.getSplitClasses();
                for (int k = 0; k < libraryClasses.length; ++k) {
                    String classpath = libraryClasses[k];
                    this.extractMacro(classpath);
                    Element classEl = this.createElement(classes, "root");
                    classEl.addAttribute("url", classpath);
                }
            } else {
                this.createElement(classes, "root").addAttribute("url", this.getLibraryUrl(a));
            }
            if (library != null && library.getSplitSources().length > 0) {
                this.removeOldElements(lib, "SOURCES");
                Element sourcesElement = this.createElement(lib, "SOURCES");
                String[] sources = library.getSplitSources();
                for (int k = 0; k < sources.length; ++k) {
                    String source = sources[k];
                    this.extractMacro(source);
                    Element sourceEl = this.createElement(sourcesElement, "root");
                    sourceEl.addAttribute("url", source);
                }
            } else if (this.downloadSources) {
                this.resolveClassifier(this.createOrGetElement(lib, "SOURCES"), a, this.sourceClassifier);
            }
            if (!this.downloadJavadocs) continue;
            this.resolveClassifier(this.createOrGetElement(lib, "JAVADOC"), a, this.javadocClassifier);
        }
        i = unusedModules.iterator();
        while (i.hasNext()) {
            Element orderEntry = (Element)i.next();
            component.remove(orderEntry);
        }
    }

    private Element createOrGetElement(Element lib, String name) {
        Element el = lib.element("name");
        if (el == null) {
            el = this.createElement(lib, name);
        }
        return el;
    }

    private void addEarModule(Element module) {
        module.addAttribute("type", "J2EE_APPLICATION_MODULE");
        Element component = this.findComponent(module, "ApplicationModuleProperties");
        this.addDeploymentDescriptor(component, "application.xml", "1.3", this.executedProject.getBuild().getDirectory() + "/application.xml");
    }

    private void addEjbModule(Element module) {
        module.addAttribute("type", "J2EE_EJB_MODULE");
        String explodedDir = this.executedProject.getBuild().getDirectory() + "/" + this.executedProject.getArtifactId();
        Element component = this.findComponent(module, "EjbModuleBuildComponent");
        Element setting = this.findSetting(component, "EXPLODED_URL");
        setting.addAttribute("value", this.getModuleFileUrl(explodedDir));
        component = this.findComponent(module, "EjbModuleProperties");
        this.addDeploymentDescriptor(component, "ejb-jar.xml", "2.x", "src/main/resources/META-INF/ejb-jar.xml");
        this.removeOldElements(component, "containerElement");
        List artifacts = this.executedProject.getTestArtifacts();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Element uriAttribute;
            Element methodAttribute;
            Artifact artifact = (Artifact)i.next();
            Element containerElement = this.createElement(component, "containerElement");
            if (this.linkModules && this.isReactorProject(artifact.getGroupId(), artifact.getArtifactId())) {
                containerElement.addAttribute("type", "module");
                containerElement.addAttribute("name", artifact.getArtifactId());
                methodAttribute = this.createElement(containerElement, "attribute");
                methodAttribute.addAttribute("name", "method");
                methodAttribute.addAttribute("value", "6");
                uriAttribute = this.createElement(containerElement, "attribute");
                uriAttribute.addAttribute("name", "URI");
                uriAttribute.addAttribute("value", "/WEB-INF/classes");
                continue;
            }
            if (artifact.getFile() == null) continue;
            containerElement.addAttribute("type", "library");
            containerElement.addAttribute("level", "module");
            containerElement.addAttribute("name", artifact.getArtifactId());
            methodAttribute = this.createElement(containerElement, "attribute");
            methodAttribute.addAttribute("name", "method");
            methodAttribute.addAttribute("value", "2");
            uriAttribute = this.createElement(containerElement, "attribute");
            uriAttribute.addAttribute("name", "URI");
            uriAttribute.addAttribute("value", "/WEB-INF/lib/" + artifact.getFile().getName());
        }
    }

    private void extractMacro(String path) {
        if (this.macros != null) {
            Pattern p = Pattern.compile(".*\\$([^\\$]+)\\$.*");
            Matcher matcher = p.matcher(path);
            while (matcher.find()) {
                String macro = matcher.group(1);
                this.macros.add(macro);
            }
        }
    }

    private Library findLibrary(Artifact a) {
        if (this.libraries != null) {
            for (int j = 0; j < this.libraries.length; ++j) {
                Library library = this.libraries[j];
                if (!a.getArtifactId().equals(library.getName())) continue;
                return library;
            }
        }
        return null;
    }

    private List getExcludedDirectories(File target, List excludeList, List sourceFolders) {
        ArrayList<String> foundFolders = new ArrayList<String>();
        int totalDirs = 0;
        int excludedDirs = 0;
        if (target.exists() && !excludeList.contains(target.getAbsolutePath())) {
            File[] files = target.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isDirectory() || excludeList.contains(file.getAbsolutePath())) continue;
                ++totalDirs;
                String absolutePath = file.getAbsolutePath();
                String url = this.getModuleFileUrl(absolutePath);
                boolean addToExclude = true;
                Iterator sources = sourceFolders.iterator();
                while (sources.hasNext()) {
                    String source = ((Element)sources.next()).attributeValue("url");
                    if (source.equals(url)) {
                        addToExclude = false;
                        break;
                    }
                    if (source.indexOf(url) != 0) continue;
                    foundFolders.addAll(this.getExcludedDirectories(new File(absolutePath), excludeList, sourceFolders));
                    addToExclude = false;
                    break;
                }
                if (!addToExclude) continue;
                ++excludedDirs;
                foundFolders.add(absolutePath);
            }
            if (totalDirs > 0 && totalDirs == excludedDirs) {
                foundFolders.clear();
                foundFolders.add(target.getAbsolutePath());
            }
        } else if (!target.exists()) {
            foundFolders.add(target.getAbsolutePath());
        }
        return foundFolders;
    }

    private void addWebModule(Element module) {
        String warWebapp = this.executedProject.getBuild().getDirectory() + "/" + this.executedProject.getArtifactId();
        String warSrc = this.getPluginSetting("maven-war-plugin", "warSourceDirectory", "src/main/webapp");
        String webXml = warSrc + "/WEB-INF/web.xml";
        module.addAttribute("type", "J2EE_WEB_MODULE");
        Element component = this.findComponent(module, "WebModuleBuildComponent");
        Element setting = this.findSetting(component, "EXPLODED_URL");
        setting.addAttribute("value", this.getModuleFileUrl(warWebapp));
        component = this.findComponent(module, "WebModuleProperties");
        this.removeOldElements(component, "containerElement");
        List artifacts = this.executedProject.getTestArtifacts();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Element uriAttribute;
            Element methodAttribute;
            Artifact artifact = (Artifact)i.next();
            Element containerElement = this.createElement(component, "containerElement");
            if (this.linkModules && this.isReactorProject(artifact.getGroupId(), artifact.getArtifactId())) {
                containerElement.addAttribute("type", "module");
                containerElement.addAttribute("name", artifact.getArtifactId());
                methodAttribute = this.createElement(containerElement, "attribute");
                methodAttribute.addAttribute("name", "method");
                methodAttribute.addAttribute("value", "5");
                uriAttribute = this.createElement(containerElement, "attribute");
                uriAttribute.addAttribute("name", "URI");
                uriAttribute.addAttribute("value", "/WEB-INF/lib/" + artifact.getArtifactId() + "-" + artifact.getVersion() + ".jar");
                continue;
            }
            if (artifact.getFile() == null) continue;
            containerElement.addAttribute("type", "library");
            containerElement.addAttribute("level", "module");
            methodAttribute = this.createElement(containerElement, "attribute");
            methodAttribute.addAttribute("name", "method");
            methodAttribute.addAttribute("value", "1");
            uriAttribute = this.createElement(containerElement, "attribute");
            uriAttribute.addAttribute("name", "URI");
            uriAttribute.addAttribute("value", "/WEB-INF/lib/" + artifact.getFile().getName());
            Element url = this.createElement(containerElement, "url");
            url.setText(this.getLibraryUrl(artifact));
        }
        this.addDeploymentDescriptor(component, "web.xml", "2.3", webXml);
        Element element = this.findElement(component, "webroots");
        this.removeOldElements(element, "root");
        element = this.createElement(element, "root");
        element.addAttribute("relative", "/");
        element.addAttribute("url", this.getModuleFileUrl(warSrc));
    }

    private String getModuleFileUrl(File basedir, String path) {
        return "file://$MODULE_DIR$/" + this.toRelative(basedir, path);
    }

    private String getModuleFileUrl(String file) {
        return this.getModuleFileUrl(this.executedProject.getBasedir(), file);
    }

    private void addSourceFolder(Element content, String directory, boolean isTest) {
        if (!StringUtils.isEmpty((String)directory) && new File(directory).isDirectory()) {
            Element sourceFolder = this.createElement(content, "sourceFolder");
            sourceFolder.addAttribute("url", this.getModuleFileUrl(directory));
            sourceFolder.addAttribute("isTestSource", Boolean.toString(isTest));
        }
    }

    private void addExcludeFolder(Element content, String directory) {
        Element excludeFolder = this.createElement(content, "excludeFolder");
        excludeFolder.addAttribute("url", this.getModuleFileUrl(directory));
    }

    private boolean isReactorProject(String groupId, String artifactId) {
        if (this.reactorProjects != null) {
            Iterator j = this.reactorProjects.iterator();
            while (j.hasNext()) {
                MavenProject p = (MavenProject)j.next();
                if (!p.getGroupId().equals(groupId) || !p.getArtifactId().equals(artifactId)) continue;
                return true;
            }
        }
        return false;
    }

    private void resolveClassifier(Element element, Artifact a, String classifier) {
        String path;
        String id = a.getId() + '-' + classifier;
        if (attemptedDownloads.containsKey(id)) {
            this.getLog().debug((CharSequence)(id + " was already downloaded."));
            path = (String)attemptedDownloads.get(id);
        } else {
            this.getLog().debug((CharSequence)(id + " was not attempted to be downloaded yet: trying..."));
            path = this.resolveClassifiedArtifact(a, classifier);
            attemptedDownloads.put(id, path);
        }
        if (path != null) {
            String jarPath = "jar://" + path + "!/";
            this.getLog().debug((CharSequence)("Setting " + classifier + " for " + id + " to " + jarPath));
            this.removeOldElements(element, "root");
            this.createElement(element, "root").addAttribute("url", jarPath);
        }
    }

    private String resolveClassifiedArtifact(Artifact artifact, String classifier) {
        String basePath = artifact.getFile().getAbsolutePath().replace('\\', '/');
        int delIndex = basePath.indexOf(".jar");
        if (delIndex < 0) {
            return null;
        }
        List remoteRepos = this.executedProject.getRemoteArtifactRepositories();
        try {
            Artifact classifiedArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), classifier);
            String dstFilename = basePath.substring(0, delIndex) + '-' + classifier + ".jar";
            File dstFile = new File(dstFilename);
            classifiedArtifact.setFile(dstFile);
            if (!dstFile.exists()) {
                this.wagonManager.getArtifact(classifiedArtifact, remoteRepos);
            }
            return dstFile.getAbsolutePath().replace('\\', '/');
        }
        catch (TransferFailedException e) {
            this.getLog().debug((Throwable)e);
            return null;
        }
        catch (ResourceDoesNotExistException e) {
            this.getLog().debug((Throwable)e);
            return null;
        }
    }

    private Element findSetting(Element component, String name) {
        return this.findElement(component, "setting", name);
    }

    private String getLibraryUrl(Artifact artifact) {
        return "jar://" + artifact.getFile().getAbsolutePath().replace('\\', '/') + "!/";
    }

    private Element addDeploymentDescriptor(Element component, String name, String version, String file) {
        Element deploymentDescriptor = this.findElement(component, "deploymentDescriptor");
        if (deploymentDescriptor.attributeValue("version") == null) {
            deploymentDescriptor.addAttribute("version", version);
        }
        if (deploymentDescriptor.attributeValue("name") == null) {
            deploymentDescriptor.addAttribute("name", name);
        }
        deploymentDescriptor.addAttribute("optional", "false");
        if (this.deploymentDescriptorFile == null) {
            this.deploymentDescriptorFile = file;
        }
        deploymentDescriptor.addAttribute("url", this.getModuleFileUrl(this.deploymentDescriptorFile));
        return deploymentDescriptor;
    }
}

