/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.install;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.util.IOUtil;

public class InstallFileMojo
extends AbstractInstallMojo {
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String packaging;
    private File file;
    private File pomFile;
    private boolean generatePom = false;
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block11: {
            Artifact artifact = this.artifactFactory.createArtifact(this.groupId, this.artifactId, this.version, null, this.packaging);
            Artifact pomArtifact = null;
            if (this.pomFile != null && this.pomFile.exists()) {
                pomArtifact = this.artifactFactory.createArtifact(this.groupId, this.artifactId, this.version, null, "pom");
            }
            if (this.generatePom) {
                FileWriter fw = null;
                try {
                    File tempFile = File.createTempFile("mvninstall", ".pom");
                    tempFile.deleteOnExit();
                    Model model = new Model();
                    model.setModelVersion("4.0.0");
                    model.setGroupId(this.groupId);
                    model.setArtifactId(this.artifactId);
                    model.setVersion(this.version);
                    model.setPackaging(this.packaging);
                    model.setDescription("POM was created from install:install-file");
                    fw = new FileWriter(tempFile);
                    tempFile.deleteOnExit();
                    new MavenXpp3Writer().write((Writer)fw, model);
                    ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, tempFile);
                    artifact.addMetadata((ArtifactMetadata)metadata);
                }
                catch (IOException e) {
                    try {
                        throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(fw);
                        throw throwable;
                    }
                }
                IOUtil.close((Writer)fw);
            }
            try {
                String localPath = this.localRepository.pathOf(artifact);
                File destination = new File(this.localRepository.getBasedir(), localPath);
                if (!this.file.getPath().equals(destination.getPath())) {
                    this.installer.install(this.file, artifact, this.localRepository);
                    if (this.pomFile != null && this.pomFile.exists()) {
                        this.installer.install(this.pomFile, pomArtifact, this.localRepository);
                    }
                    break block11;
                }
                throw new MojoFailureException("Cannot install artifact. Artifact is already in the local repository.\n\nFile in question is: " + this.file + "\n");
            }
            catch (ArtifactInstallationException e) {
                throw new MojoExecutionException("Error installing artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

