package org.apache.maven.plugin.install;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-install-plugin.<br/> Call <pre>  mvn install:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Mon May 17 23:21:37 CEST 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-install-plugin:2.3.1", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Install Plugin", 0 );
        append( sb, "Copies the project artifacts to the user\'s local repository.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "install:help", 0 );
            append( sb, "Display help information on maven-install-plugin.\nCall\n\u00a0\u00a0mvn\u00a0install:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "install".equals( goal ) )
        {
            append( sb, "install:install", 0 );
            append( sb, "Installs the project\'s main artifact in the local repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "createChecksum (Default: false)", 2 );
                append( sb, "Flag whether to create checksums (MD5, SHA-1) or not.", 3 );
                append( sb, "", 0 );

                append( sb, "updateReleaseInfo (Default: false)", 2 );
                append( sb, "Whether to update the metadata to make the artifact a release version.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "install-file".equals( goal ) )
        {
            append( sb, "install:install-file", 0 );
            append( sb, "Installs a file in the local repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactId", 2 );
                append( sb, "ArtifactId of the artifact to be installed. Retrieved from POM file if one is specified.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Classifier type of the artifact to be installed. For example, \'sources\' or \'javadoc\'. Defaults to none which means this is the project\'s main artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "createChecksum (Default: false)", 2 );
                append( sb, "Flag whether to create checksums (MD5, SHA-1) or not.", 3 );
                append( sb, "", 0 );

                append( sb, "file", 2 );
                append( sb, "The file to be installed in the local repository.", 3 );
                append( sb, "", 0 );

                append( sb, "generatePom", 2 );
                append( sb, "Generate a minimal POM for the artifact if none is supplied via the parameter pomFile. Defaults to true if there is no existing POM in the local repository yet.", 3 );
                append( sb, "", 0 );

                append( sb, "groupId", 2 );
                append( sb, "GroupId of the artifact to be installed. Retrieved from POM file if one is specified.", 3 );
                append( sb, "", 0 );

                append( sb, "javadoc", 2 );
                append( sb, "The bundled API docs for the artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepositoryPath", 2 );
                append( sb, "The path for a specific local repository directory. If not specified the local repository path configured in the Maven settings will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "packaging", 2 );
                append( sb, "Packaging type of the artifact to be installed. Retrieved from POM file if one is specified.", 3 );
                append( sb, "", 0 );

                append( sb, "pomFile", 2 );
                append( sb, "Location of an existing POM file to be installed alongside the main artifact, given by the file parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryLayout (Default: default)", 2 );
                append( sb, "The type of remote repository layout to install to. Try legacy for a Maven 1.x-style repository layout.", 3 );
                append( sb, "", 0 );

                append( sb, "sources", 2 );
                append( sb, "The bundled sources for the artifact.", 3 );
                append( sb, "", 0 );

                append( sb, "updateReleaseInfo (Default: false)", 2 );
                append( sb, "Whether to update the metadata to make the artifact a release version.", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "Version of the artifact to be installed. Retrieved from POM file if one is specified.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
