/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

class CompositeMap
implements Map {
    private MavenProject mavenProject;
    private Map properties;

    protected CompositeMap(MavenProject mavenProject, Map properties) {
        if (mavenProject == null) {
            throw new IllegalArgumentException("no project specified");
        }
        this.mavenProject = mavenProject;
        this.properties = properties == null ? new Properties() : properties;
    }

    public void clear() {
    }

    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String expression = (String)key;
        if (expression.startsWith("project.") || expression.startsWith("pom.")) {
            try {
                Object evaluated = ReflectionValueExtractor.evaluate((String)expression, (Object)this.mavenProject);
                if (evaluated != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.properties.containsKey(key) || this.mavenProject.getProperties().containsKey(key);
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        Object value;
        if (!(key instanceof String)) {
            return null;
        }
        String expression = (String)key;
        if (expression.startsWith("project.") || expression.startsWith("pom.")) {
            try {
                Object evaluated = ReflectionValueExtractor.evaluate((String)expression, (Object)this.mavenProject);
                if (evaluated != null) {
                    return evaluated;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return (value = this.properties.get(key)) != null ? value : this.mavenProject.getProperties().get(key);
    }

    public boolean isEmpty() {
        return this.mavenProject == null && this.mavenProject.getProperties().isEmpty() && this.properties.isEmpty();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }
}

