/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-invoker-plugin:1.6", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Invoker Plugin", 0);
        this.append(sb, "The Maven Invoker Plugin is used to run a set of Maven projects. The plugin can determine whether each project execution is successful, and optionally can verify the output generated from a given project execution.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "invoker:help", 0);
            this.append(sb, "Display help information on maven-invoker-plugin.\nCall\n\u00a0\u00a0mvn\u00a0invoker:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "install".equals(this.goal)) {
            this.append(sb, "invoker:install", 0);
            this.append(sb, "Installs the project artifacts of the main build into the local repository as a preparation to run the sub projects. More precisely, all artifacts of the project itself, all its locally reachable parent POMs and all its dependencies from the reactor will be installed to the local repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "extraArtifacts", 2);
                this.append(sb, "Extra dependencies that need to be installed on the local repository.\nFormat:\ngroupId:artifactId:version:type:classifier\nExamples:\norg.apache.maven.plugins:maven-clean-plugin:2.4:maven-plugin\norg.apache.maven.plugins:maven-clean-plugin:2.4:jar:javadoc\nIf the type is 'maven-plugin' the plugin will try to resolve the artifact using plugin remote repositories, instead of using artifact remote repositories.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepositoryPath", 2);
                this.append(sb, "The path to the local repository into which the project artifacts should be installed for the integration tests. If not set, the regular local repository will be used. To prevent soiling of your regular local repository with possibly broken artifacts, it is strongly recommended to use an isolated repository for the integration tests (e.g. ${project.build.directory}/it-repo).", 3);
                this.append(sb, "Expression: ${invoker.localRepositoryPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipInstallation (Default: false)", 2);
                this.append(sb, "A flag used to disable the installation procedure. This is primarily intended for usage from the command line to occasionally adjust the build.", 3);
                this.append(sb, "Expression: ${invoker.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "integration-test".equals(this.goal)) {
            this.append(sb, "invoker:integration-test", 0);
            this.append(sb, "Searches for integration test Maven projects, and executes each, collecting a log in the project directory, will never fail the build, designed to be used in conjunction with the verify mojo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addTestClassPath (Default: false)", 2);
                this.append(sb, "A flag whether the test class path of the project under test should be included in the class path of the pre-/post-build scripts. If set to false, the class path of script interpreter consists only of the runtime dependencies of the Maven Invoker Plugin. If set the true, the project's test class path will be prepended to the interpreter class path. Among others, this feature allows the scripts to access utility classes from the test sources of your project.", 3);
                this.append(sb, "Expression: ${invoker.addTestClassPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "cloneAllFiles (Default: false)", 2);
                this.append(sb, "Some files are normally excluded when copying the IT projects from the directory specified by the parameter projectsDirectory to the directory given by cloneProjectsTo (e.g. .svn, CVS, *~, etc). Setting this parameter to true will cause all files to be copied to the cloneProjectsTo directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cloneClean (Default: false)", 2);
                this.append(sb, "Ensure the cloneProjectsTo directory is not polluted with files from earlier invoker runs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cloneProjectsTo", 2);
                this.append(sb, "Directory to which projects should be cloned prior to execution. If not specified, each integration test will be run in the directory in which the corresponding IT POM was found. In this case, you most likely want to configure your SCM to ignore target and build.log in the test's base directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Whether to show debug statements in the build output.", 3);
                this.append(sb, "Expression: ${invoker.debug}", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableReports (Default: false)", 2);
                this.append(sb, "A flag to disable the generation of build reports.", 3);
                this.append(sb, "Expression: ${invoker.disableReports}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding for the pre-/post-build scripts and the list files for goals and profiles.", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "filterProperties", 2);
                this.append(sb, "A list of additional properties which will be used to filter tokens in POMs and goal files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals", 2);
                this.append(sb, "The list of goals to execute on each project. Default value is: package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goalsFile (Default: goals.txt)", 2);
                this.append(sb, "Deprecated. As of version 1.2, the key invoker.goals from the properties file specified by the parameter invokerPropertiesFile should be used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "The name of the project-specific file that contains the enumeration of goals to execute for that test.", 3);
                this.append(sb, "Expression: ${invoker.goalsFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interpolationsProperties", 2);
                this.append(sb, "Deprecated. As of version 1.3, the parameter filterProperties should be used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "List of properties which will be used to interpolate goal files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "invokerPropertiesFile (Default: invoker.properties)", 2);
                this.append(sb, "The name of an optional project-specific file that contains properties used to specify settings for an individual Maven invocation. Any property present in the file will override the corresponding setting from the plugin configuration. The values of the properties are filtered and may use expressions like ${project.version} to reference project properties or values from the parameter filterProperties. The snippet below describes the supported properties:\n#\u00a0A\u00a0comma\u00a0or\u00a0space\u00a0separated\u00a0list\u00a0of\u00a0goals/phases\u00a0to\u00a0execute,\u00a0may\n#\u00a0specify\u00a0an\u00a0empty\u00a0list\u00a0to\u00a0execute\u00a0the\u00a0default\u00a0goal\u00a0of\u00a0the\u00a0IT\u00a0project\ninvoker.goals\u00a0=\u00a0clean\u00a0install\n\n#\u00a0Optionally,\u00a0a\u00a0list\u00a0of\u00a0goals\u00a0to\u00a0run\u00a0during\u00a0further\u00a0invocations\u00a0of\u00a0Maven\ninvoker.goals.2\u00a0=\u00a0${project.groupId}:${project.artifactId}:${project.version}:run\n\n#\u00a0A\u00a0comma\u00a0or\u00a0space\u00a0separated\u00a0list\u00a0of\u00a0profiles\u00a0to\u00a0activate\ninvoker.profiles\u00a0=\u00a0its,jdk15\n\n#\u00a0The\u00a0path\u00a0to\u00a0an\u00a0alternative\u00a0POM\u00a0or\u00a0base\u00a0directory\u00a0to\u00a0invoke\u00a0Maven\u00a0on,\u00a0defaults\u00a0to\u00a0the\n#\u00a0project\u00a0that\u00a0was\u00a0originally\u00a0specified\u00a0in\u00a0the\u00a0plugin\u00a0configuration\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.project\u00a0=\u00a0sub-module\n\n#\u00a0The\u00a0value\u00a0for\u00a0the\u00a0environment\u00a0variable\u00a0MAVEN_OPTS\ninvoker.mavenOpts\u00a0=\u00a0-Dfile.encoding=UTF-16\u00a0-Xms32m\u00a0-Xmx256m\n\n#\u00a0Possible\u00a0values\u00a0are\u00a0'fail-fast'\u00a0(default),\u00a0'fail-at-end'\u00a0and\u00a0'fail-never'\ninvoker.failureBehavior\u00a0=\u00a0fail-never\n\n#\u00a0The\u00a0expected\u00a0result\u00a0of\u00a0the\u00a0build,\u00a0possible\u00a0values\u00a0are\u00a0'success'\u00a0(default)\u00a0and\u00a0'failure'\ninvoker.buildResult\u00a0=\u00a0failure\n\n#\u00a0A\u00a0boolean\u00a0value\u00a0controlling\u00a0the\u00a0aggregator\u00a0mode\u00a0of\u00a0Maven,\u00a0defaults\u00a0to\u00a0'false'\ninvoker.nonRecursive\u00a0=\u00a0true\n\n#\u00a0A\u00a0boolean\u00a0value\u00a0controlling\u00a0the\u00a0network\u00a0behavior\u00a0of\u00a0Maven,\u00a0defaults\u00a0to\u00a0'false'\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.offline\u00a0=\u00a0true\n\n#\u00a0The\u00a0path\u00a0to\u00a0the\u00a0properties\u00a0file\u00a0from\u00a0which\u00a0to\u00a0load\u00a0system\u00a0properties,\u00a0defaults\u00a0to\u00a0the\n#\u00a0filename\u00a0given\u00a0by\u00a0the\u00a0plugin\u00a0parameter\u00a0testPropertiesFile\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.systemPropertiesFile\u00a0=\u00a0test.properties\n\n#\u00a0An\u00a0optional\u00a0human\u00a0friendly\u00a0name\u00a0for\u00a0this\u00a0build\u00a0job\u00a0to\u00a0be\u00a0included\u00a0in\u00a0the\u00a0build\u00a0reports.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.name\u00a0=\u00a0Test\u00a0Build\u00a001\n\n#\u00a0An\u00a0optional\u00a0description\u00a0for\u00a0this\u00a0build\u00a0job\u00a0to\u00a0be\u00a0included\u00a0in\u00a0the\u00a0build\u00a0reports.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.description\u00a0=\u00a0Checks\u00a0the\u00a0support\u00a0for\u00a0build\u00a0reports.\n\n#\u00a0A\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0JRE\u00a0versions\u00a0on\u00a0which\u00a0this\u00a0build\u00a0job\u00a0should\u00a0be\u00a0run.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.java.version\u00a0=\u00a01.4+,\u00a0!1.4.1,\u00a01.7-\n\n#\u00a0A\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0OS\u00a0families\u00a0on\u00a0which\u00a0this\u00a0build\u00a0job\u00a0should\u00a0be\u00a0run.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.os.family\u00a0=\u00a0!windows,\u00a0unix,\u00a0mac\n\n#\u00a0A\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0Maven\u00a0versions\u00a0on\u00a0which\u00a0this\u00a0build\u00a0should\u00a0be\u00a0run.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.5\ninvoker.maven.version\u00a0=\u00a02.0.10+,\u00a0!2.1.0,\u00a0!2.2.0\n", 3);
                this.append(sb, "Expression: ${invoker.invokerPropertiesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "invokerTest", 2);
                this.append(sb, "A comma separated list of project names to run. Specify this parameter to run individual tests by file name, overriding the setupIncludes, pomIncludes and pomExcludes parameters. Each pattern you specify here will be used to create an include pattern formatted like ${projectsDirectory}/pattern, so you can just type -Dinvoker.test=FirstTest,SecondTest to run builds in ${projectsDirectory}/FirstTest and ${projectsDirectory}/SecondTest.", 3);
                this.append(sb, "Expression: ${invoker.test}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome", 2);
                this.append(sb, "The JAVA_HOME environment variable to use for forked Maven invocations. Defaults to the current Java home directory.", 3);
                this.append(sb, "Expression: ${invoker.javaHome}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepositoryPath (Default: ${settings.localRepository})", 2);
                this.append(sb, "The local repository for caching artifacts. It is strongly recommended to specify a path to an isolated repository like ${project.build.directory}/it-repo. Otherwise, your ordinary local repository will be used, potentially soiling it with broken artifacts.", 3);
                this.append(sb, "Expression: ${invoker.localRepositoryPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome", 2);
                this.append(sb, "The home directory of the Maven installation to use for the forked builds. Defaults to the current Maven installation.", 3);
                this.append(sb, "Expression: ${invoker.mavenHome}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenOpts", 2);
                this.append(sb, "The MAVEN_OPTS environment variable to use when invoking Maven. This value can be overridden for individual integration tests by using invokerPropertiesFile.", 3);
                this.append(sb, "Expression: ${invoker.mavenOpts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mergeUserSettings (Default: false)", 2);
                this.append(sb, "If enable and if you have a settings file configured for the execution, it will be merged with your user settings.", 3);
                this.append(sb, "Expression: ${invoker.mergeUserSettings}", 3);
                this.append(sb, "", 0);
                this.append(sb, "noLog (Default: false)", 2);
                this.append(sb, "Suppress logging to the build.log file.", 3);
                this.append(sb, "Expression: ${invoker.noLog}", 3);
                this.append(sb, "", 0);
                this.append(sb, "parallelThreads (Default: 1)", 2);
                this.append(sb, "number of threads for running tests in parallel. This will be the number of maven forked process in parallel.", 3);
                this.append(sb, "Expression: ${invoker.parallelThreads}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pom", 2);
                this.append(sb, "A single POM to build, skipping any scanning parameters and behavior.", 3);
                this.append(sb, "Expression: ${invoker.pom}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomExcludes", 2);
                this.append(sb, "Exclude patterns for searching the integration test directory. This parameter is meant to be set from the POM. By default, no POM files are excluded. For the convenience of using an include pattern like *, the custom settings file specified by the parameter settingsFile will always be excluded automatically.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomIncludes", 2);
                this.append(sb, "Include patterns for searching the integration test directory for projects. This parameter is meant to be set from the POM. If this parameter is not set, the plugin will search for all pom.xml files one directory below projectsDirectory (i.e. */pom.xml).\n\nStarting with version 1.3, mere directories can also be matched by these patterns. For example, the include pattern * will run Maven builds on all immediate sub directories of projectsDirectory, regardless if they contain a pom.xml. This allows to perform builds that need/should not depend on the existence of a POM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postBuildHookScript (Default: postbuild)", 2);
                this.append(sb, "Relative path of a cleanup/verification hook script to run after executing the build. This script may be written with either BeanShell or Groovy (since 1.3). If the file extension is omitted (e.g. verify), the plugin searches for the file by trying out the well-known extensions .bsh and .groovy. If this script exists for a particular project but returns any non-null value different from true or throws an exception, the corresponding build is flagged as a failure.", 3);
                this.append(sb, "Expression: ${invoker.postBuildHookScript}", 3);
                this.append(sb, "", 0);
                this.append(sb, "preBuildHookScript (Default: prebuild)", 2);
                this.append(sb, "Relative path of a pre-build hook script to run prior to executing the build. This script may be written with either BeanShell or Groovy (since 1.3). If the file extension is omitted (e.g. prebuild), the plugin searches for the file by trying out the well-known extensions .bsh and .groovy. If this script exists for a particular project but returns any non-null value different from true or throws an exception, the corresponding build is flagged as a failure. In this case, neither Maven nor the post-build hook script will be invoked.", 3);
                this.append(sb, "Expression: ${invoker.preBuildHookScript}", 3);
                this.append(sb, "", 0);
                this.append(sb, "profiles", 2);
                this.append(sb, "List of profile identifiers to explicitly trigger in the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profilesFile (Default: profiles.txt)", 2);
                this.append(sb, "Deprecated. As of version 1.2, the key invoker.profiles from the properties file specified by the parameter invokerPropertiesFile should be used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "The name of the project-specific file that contains the enumeration of profiles to use for that test. If the file exists and is empty no profiles will be used even if the parameter profiles is set.", 3);
                this.append(sb, "Expression: ${invoker.profilesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectsDirectory (Default: ${basedir}/src/it/)", 2);
                this.append(sb, "Directory to search for integration tests.", 3);
                this.append(sb, "Expression: ${invoker.projectsDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "Common set of properties to pass in on each project's command line, via -D parameters.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory (Default: ${project.build.directory}/invoker-reports)", 2);
                this.append(sb, "Base directory where all build reports are written to. Every execution of an integration test will produce an XML file which contains the information about success or failure of that particular build job. The format of the resulting XML file is documented in the given build-job reference.", 3);
                this.append(sb, "Expression: ${invoker.reportsDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "selectorScript (Default: selector)", 2);
                this.append(sb, "Relative path of a selector script to run prior in order to decide if the build should be executed. This script may be written with either BeanShell or Groovy. If the file extension is omitted (e.g. selector), the plugin searches for the file by trying out the well-known extensions .bsh and .groovy. If this script exists for a particular project but returns any non-null value different from true, the corresponding build is flagged as skipped. In this case, none of the pre-build hook script, Maven nor the post-build hook script will be invoked. If this script throws an exception, the corresponding build is flagged as in error, and none of the pre-build hook script, Maven not the post-build hook script will be invoked.", 3);
                this.append(sb, "Expression: ${invoker.selectorScript}", 3);
                this.append(sb, "", 0);
                this.append(sb, "settingsFile", 2);
                this.append(sb, "Path to an alternate settings.xml to use for Maven invocation with all ITs. Note that the <localRepository> element of this settings file is always ignored, i.e. the path given by the parameter localRepositoryPath is dominant.", 3);
                this.append(sb, "Expression: ${invoker.settingsFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "setupIncludes", 2);
                this.append(sb, "Include patterns for searching the projects directory for projects that need to be run before the other projects. This parameter allows to declare projects that perform setup tasks like installing utility artifacts into the local repository. Projects matched by these patterns are implicitly excluded from the scan for ordinary projects. Also, the exclusions defined by the parameter pomExcludes apply to the setup projects, too. Default value is: setup*/pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showErrors (Default: false)", 2);
                this.append(sb, "Whether to show errors in the build output.", 3);
                this.append(sb, "Expression: ${invoker.showErrors}", 3);
                this.append(sb, "", 0);
                this.append(sb, "showVersion (Default: false)", 2);
                this.append(sb, "flag to enable show mvn version used for running its (cli option : -V,--show-version )", 3);
                this.append(sb, "Expression: ${invoker.showVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipInvocation (Default: false)", 2);
                this.append(sb, "Flag used to suppress certain invocations. This is useful in tailoring the build using profiles.", 3);
                this.append(sb, "Expression: ${invoker.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "streamLogs (Default: false)", 2);
                this.append(sb, "Flag used to determine whether the build logs should be output to the normal mojo log.", 3);
                this.append(sb, "Expression: ${invoker.streamLogs}", 3);
                this.append(sb, "", 0);
                this.append(sb, "suppressSummaries (Default: false)", 2);
                this.append(sb, "Flag used to suppress the summary output notifying of successes and failures. If set to true, the only indication of the build's success or failure will be the effect it has on the main build (if it fails, the main build should fail as well). If streamLogs is enabled, the sub-build summary will also provide an indication.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testProperties", 2);
                this.append(sb, "Deprecated. As of version 1.1, use the properties parameter instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "Common set of test properties to pass in on each IT's command line, via -D parameters.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testPropertiesFile (Default: test.properties)", 2);
                this.append(sb, "Location of a properties file that defines CLI properties for the test.", 3);
                this.append(sb, "Expression: ${invoker.testPropertiesFile}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(sb, "invoker:report", 0);
            this.append(sb, "Generate a report based on the results of the Maven invocations. Note: This mojo doesn't fork any lifecycle, if you have a clean working copy, you have to use a command like mvn clean integration-test site to ensure the build results are present when this goal is invoked.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory (Default: ${project.build.directory}/invoker-reports)", 2);
                this.append(sb, "Base directory where all build reports have been written to.", 3);
                this.append(sb, "Expression: ${invoker.reportsDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "invoker:run", 0);
            this.append(sb, "Searches for integration test Maven projects, and executes each, collecting a log in the project directory, and outputting the results to the command line.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addTestClassPath (Default: false)", 2);
                this.append(sb, "A flag whether the test class path of the project under test should be included in the class path of the pre-/post-build scripts. If set to false, the class path of script interpreter consists only of the runtime dependencies of the Maven Invoker Plugin. If set the true, the project's test class path will be prepended to the interpreter class path. Among others, this feature allows the scripts to access utility classes from the test sources of your project.", 3);
                this.append(sb, "Expression: ${invoker.addTestClassPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "cloneAllFiles (Default: false)", 2);
                this.append(sb, "Some files are normally excluded when copying the IT projects from the directory specified by the parameter projectsDirectory to the directory given by cloneProjectsTo (e.g. .svn, CVS, *~, etc). Setting this parameter to true will cause all files to be copied to the cloneProjectsTo directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cloneClean (Default: false)", 2);
                this.append(sb, "Ensure the cloneProjectsTo directory is not polluted with files from earlier invoker runs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cloneProjectsTo", 2);
                this.append(sb, "Directory to which projects should be cloned prior to execution. If not specified, each integration test will be run in the directory in which the corresponding IT POM was found. In this case, you most likely want to configure your SCM to ignore target and build.log in the test's base directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug (Default: false)", 2);
                this.append(sb, "Whether to show debug statements in the build output.", 3);
                this.append(sb, "Expression: ${invoker.debug}", 3);
                this.append(sb, "", 0);
                this.append(sb, "disableReports (Default: false)", 2);
                this.append(sb, "A flag to disable the generation of build reports.", 3);
                this.append(sb, "Expression: ${invoker.disableReports}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding for the pre-/post-build scripts and the list files for goals and profiles.", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "filterProperties", 2);
                this.append(sb, "A list of additional properties which will be used to filter tokens in POMs and goal files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals", 2);
                this.append(sb, "The list of goals to execute on each project. Default value is: package.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goalsFile (Default: goals.txt)", 2);
                this.append(sb, "Deprecated. As of version 1.2, the key invoker.goals from the properties file specified by the parameter invokerPropertiesFile should be used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "The name of the project-specific file that contains the enumeration of goals to execute for that test.", 3);
                this.append(sb, "Expression: ${invoker.goalsFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "A flag controlling whether failures of the sub builds should fail the main build, too. If set to true, the main build will proceed even if one or more sub builds failed.", 3);
                this.append(sb, "Expression: ${maven.test.failure.ignore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "interpolationsProperties", 2);
                this.append(sb, "Deprecated. As of version 1.3, the parameter filterProperties should be used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "List of properties which will be used to interpolate goal files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "invokerPropertiesFile (Default: invoker.properties)", 2);
                this.append(sb, "The name of an optional project-specific file that contains properties used to specify settings for an individual Maven invocation. Any property present in the file will override the corresponding setting from the plugin configuration. The values of the properties are filtered and may use expressions like ${project.version} to reference project properties or values from the parameter filterProperties. The snippet below describes the supported properties:\n#\u00a0A\u00a0comma\u00a0or\u00a0space\u00a0separated\u00a0list\u00a0of\u00a0goals/phases\u00a0to\u00a0execute,\u00a0may\n#\u00a0specify\u00a0an\u00a0empty\u00a0list\u00a0to\u00a0execute\u00a0the\u00a0default\u00a0goal\u00a0of\u00a0the\u00a0IT\u00a0project\ninvoker.goals\u00a0=\u00a0clean\u00a0install\n\n#\u00a0Optionally,\u00a0a\u00a0list\u00a0of\u00a0goals\u00a0to\u00a0run\u00a0during\u00a0further\u00a0invocations\u00a0of\u00a0Maven\ninvoker.goals.2\u00a0=\u00a0${project.groupId}:${project.artifactId}:${project.version}:run\n\n#\u00a0A\u00a0comma\u00a0or\u00a0space\u00a0separated\u00a0list\u00a0of\u00a0profiles\u00a0to\u00a0activate\ninvoker.profiles\u00a0=\u00a0its,jdk15\n\n#\u00a0The\u00a0path\u00a0to\u00a0an\u00a0alternative\u00a0POM\u00a0or\u00a0base\u00a0directory\u00a0to\u00a0invoke\u00a0Maven\u00a0on,\u00a0defaults\u00a0to\u00a0the\n#\u00a0project\u00a0that\u00a0was\u00a0originally\u00a0specified\u00a0in\u00a0the\u00a0plugin\u00a0configuration\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.project\u00a0=\u00a0sub-module\n\n#\u00a0The\u00a0value\u00a0for\u00a0the\u00a0environment\u00a0variable\u00a0MAVEN_OPTS\ninvoker.mavenOpts\u00a0=\u00a0-Dfile.encoding=UTF-16\u00a0-Xms32m\u00a0-Xmx256m\n\n#\u00a0Possible\u00a0values\u00a0are\u00a0'fail-fast'\u00a0(default),\u00a0'fail-at-end'\u00a0and\u00a0'fail-never'\ninvoker.failureBehavior\u00a0=\u00a0fail-never\n\n#\u00a0The\u00a0expected\u00a0result\u00a0of\u00a0the\u00a0build,\u00a0possible\u00a0values\u00a0are\u00a0'success'\u00a0(default)\u00a0and\u00a0'failure'\ninvoker.buildResult\u00a0=\u00a0failure\n\n#\u00a0A\u00a0boolean\u00a0value\u00a0controlling\u00a0the\u00a0aggregator\u00a0mode\u00a0of\u00a0Maven,\u00a0defaults\u00a0to\u00a0'false'\ninvoker.nonRecursive\u00a0=\u00a0true\n\n#\u00a0A\u00a0boolean\u00a0value\u00a0controlling\u00a0the\u00a0network\u00a0behavior\u00a0of\u00a0Maven,\u00a0defaults\u00a0to\u00a0'false'\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.offline\u00a0=\u00a0true\n\n#\u00a0The\u00a0path\u00a0to\u00a0the\u00a0properties\u00a0file\u00a0from\u00a0which\u00a0to\u00a0load\u00a0system\u00a0properties,\u00a0defaults\u00a0to\u00a0the\n#\u00a0filename\u00a0given\u00a0by\u00a0the\u00a0plugin\u00a0parameter\u00a0testPropertiesFile\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.systemPropertiesFile\u00a0=\u00a0test.properties\n\n#\u00a0An\u00a0optional\u00a0human\u00a0friendly\u00a0name\u00a0for\u00a0this\u00a0build\u00a0job\u00a0to\u00a0be\u00a0included\u00a0in\u00a0the\u00a0build\u00a0reports.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.name\u00a0=\u00a0Test\u00a0Build\u00a001\n\n#\u00a0An\u00a0optional\u00a0description\u00a0for\u00a0this\u00a0build\u00a0job\u00a0to\u00a0be\u00a0included\u00a0in\u00a0the\u00a0build\u00a0reports.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.description\u00a0=\u00a0Checks\u00a0the\u00a0support\u00a0for\u00a0build\u00a0reports.\n\n#\u00a0A\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0JRE\u00a0versions\u00a0on\u00a0which\u00a0this\u00a0build\u00a0job\u00a0should\u00a0be\u00a0run.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.java.version\u00a0=\u00a01.4+,\u00a0!1.4.1,\u00a01.7-\n\n#\u00a0A\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0OS\u00a0families\u00a0on\u00a0which\u00a0this\u00a0build\u00a0job\u00a0should\u00a0be\u00a0run.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.4\ninvoker.os.family\u00a0=\u00a0!windows,\u00a0unix,\u00a0mac\n\n#\u00a0A\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0Maven\u00a0versions\u00a0on\u00a0which\u00a0this\u00a0build\u00a0should\u00a0be\u00a0run.\n#\u00a0Since\u00a0plugin\u00a0version\u00a01.5\ninvoker.maven.version\u00a0=\u00a02.0.10+,\u00a0!2.1.0,\u00a0!2.2.0\n", 3);
                this.append(sb, "Expression: ${invoker.invokerPropertiesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "invokerTest", 2);
                this.append(sb, "A comma separated list of project names to run. Specify this parameter to run individual tests by file name, overriding the setupIncludes, pomIncludes and pomExcludes parameters. Each pattern you specify here will be used to create an include pattern formatted like ${projectsDirectory}/pattern, so you can just type -Dinvoker.test=FirstTest,SecondTest to run builds in ${projectsDirectory}/FirstTest and ${projectsDirectory}/SecondTest.", 3);
                this.append(sb, "Expression: ${invoker.test}", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaHome", 2);
                this.append(sb, "The JAVA_HOME environment variable to use for forked Maven invocations. Defaults to the current Java home directory.", 3);
                this.append(sb, "Expression: ${invoker.javaHome}", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepositoryPath (Default: ${settings.localRepository})", 2);
                this.append(sb, "The local repository for caching artifacts. It is strongly recommended to specify a path to an isolated repository like ${project.build.directory}/it-repo. Otherwise, your ordinary local repository will be used, potentially soiling it with broken artifacts.", 3);
                this.append(sb, "Expression: ${invoker.localRepositoryPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenHome", 2);
                this.append(sb, "The home directory of the Maven installation to use for the forked builds. Defaults to the current Maven installation.", 3);
                this.append(sb, "Expression: ${invoker.mavenHome}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mavenOpts", 2);
                this.append(sb, "The MAVEN_OPTS environment variable to use when invoking Maven. This value can be overridden for individual integration tests by using invokerPropertiesFile.", 3);
                this.append(sb, "Expression: ${invoker.mavenOpts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mergeUserSettings (Default: false)", 2);
                this.append(sb, "If enable and if you have a settings file configured for the execution, it will be merged with your user settings.", 3);
                this.append(sb, "Expression: ${invoker.mergeUserSettings}", 3);
                this.append(sb, "", 0);
                this.append(sb, "noLog (Default: false)", 2);
                this.append(sb, "Suppress logging to the build.log file.", 3);
                this.append(sb, "Expression: ${invoker.noLog}", 3);
                this.append(sb, "", 0);
                this.append(sb, "parallelThreads (Default: 1)", 2);
                this.append(sb, "number of threads for running tests in parallel. This will be the number of maven forked process in parallel.", 3);
                this.append(sb, "Expression: ${invoker.parallelThreads}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pom", 2);
                this.append(sb, "A single POM to build, skipping any scanning parameters and behavior.", 3);
                this.append(sb, "Expression: ${invoker.pom}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomExcludes", 2);
                this.append(sb, "Exclude patterns for searching the integration test directory. This parameter is meant to be set from the POM. By default, no POM files are excluded. For the convenience of using an include pattern like *, the custom settings file specified by the parameter settingsFile will always be excluded automatically.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pomIncludes", 2);
                this.append(sb, "Include patterns for searching the integration test directory for projects. This parameter is meant to be set from the POM. If this parameter is not set, the plugin will search for all pom.xml files one directory below projectsDirectory (i.e. */pom.xml).\n\nStarting with version 1.3, mere directories can also be matched by these patterns. For example, the include pattern * will run Maven builds on all immediate sub directories of projectsDirectory, regardless if they contain a pom.xml. This allows to perform builds that need/should not depend on the existence of a POM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "postBuildHookScript (Default: postbuild)", 2);
                this.append(sb, "Relative path of a cleanup/verification hook script to run after executing the build. This script may be written with either BeanShell or Groovy (since 1.3). If the file extension is omitted (e.g. verify), the plugin searches for the file by trying out the well-known extensions .bsh and .groovy. If this script exists for a particular project but returns any non-null value different from true or throws an exception, the corresponding build is flagged as a failure.", 3);
                this.append(sb, "Expression: ${invoker.postBuildHookScript}", 3);
                this.append(sb, "", 0);
                this.append(sb, "preBuildHookScript (Default: prebuild)", 2);
                this.append(sb, "Relative path of a pre-build hook script to run prior to executing the build. This script may be written with either BeanShell or Groovy (since 1.3). If the file extension is omitted (e.g. prebuild), the plugin searches for the file by trying out the well-known extensions .bsh and .groovy. If this script exists for a particular project but returns any non-null value different from true or throws an exception, the corresponding build is flagged as a failure. In this case, neither Maven nor the post-build hook script will be invoked.", 3);
                this.append(sb, "Expression: ${invoker.preBuildHookScript}", 3);
                this.append(sb, "", 0);
                this.append(sb, "profiles", 2);
                this.append(sb, "List of profile identifiers to explicitly trigger in the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profilesFile (Default: profiles.txt)", 2);
                this.append(sb, "Deprecated. As of version 1.2, the key invoker.profiles from the properties file specified by the parameter invokerPropertiesFile should be used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "The name of the project-specific file that contains the enumeration of profiles to use for that test. If the file exists and is empty no profiles will be used even if the parameter profiles is set.", 3);
                this.append(sb, "Expression: ${invoker.profilesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectsDirectory (Default: ${basedir}/src/it/)", 2);
                this.append(sb, "Directory to search for integration tests.", 3);
                this.append(sb, "Expression: ${invoker.projectsDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "Common set of properties to pass in on each project's command line, via -D parameters.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory (Default: ${project.build.directory}/invoker-reports)", 2);
                this.append(sb, "Base directory where all build reports are written to. Every execution of an integration test will produce an XML file which contains the information about success or failure of that particular build job. The format of the resulting XML file is documented in the given build-job reference.", 3);
                this.append(sb, "Expression: ${invoker.reportsDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "selectorScript (Default: selector)", 2);
                this.append(sb, "Relative path of a selector script to run prior in order to decide if the build should be executed. This script may be written with either BeanShell or Groovy. If the file extension is omitted (e.g. selector), the plugin searches for the file by trying out the well-known extensions .bsh and .groovy. If this script exists for a particular project but returns any non-null value different from true, the corresponding build is flagged as skipped. In this case, none of the pre-build hook script, Maven nor the post-build hook script will be invoked. If this script throws an exception, the corresponding build is flagged as in error, and none of the pre-build hook script, Maven not the post-build hook script will be invoked.", 3);
                this.append(sb, "Expression: ${invoker.selectorScript}", 3);
                this.append(sb, "", 0);
                this.append(sb, "settingsFile", 2);
                this.append(sb, "Path to an alternate settings.xml to use for Maven invocation with all ITs. Note that the <localRepository> element of this settings file is always ignored, i.e. the path given by the parameter localRepositoryPath is dominant.", 3);
                this.append(sb, "Expression: ${invoker.settingsFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "setupIncludes", 2);
                this.append(sb, "Include patterns for searching the projects directory for projects that need to be run before the other projects. This parameter allows to declare projects that perform setup tasks like installing utility artifacts into the local repository. Projects matched by these patterns are implicitly excluded from the scan for ordinary projects. Also, the exclusions defined by the parameter pomExcludes apply to the setup projects, too. Default value is: setup*/pom.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showErrors (Default: false)", 2);
                this.append(sb, "Whether to show errors in the build output.", 3);
                this.append(sb, "Expression: ${invoker.showErrors}", 3);
                this.append(sb, "", 0);
                this.append(sb, "showVersion (Default: false)", 2);
                this.append(sb, "flag to enable show mvn version used for running its (cli option : -V,--show-version )", 3);
                this.append(sb, "Expression: ${invoker.showVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipInvocation (Default: false)", 2);
                this.append(sb, "Flag used to suppress certain invocations. This is useful in tailoring the build using profiles.", 3);
                this.append(sb, "Expression: ${invoker.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "streamLogs (Default: false)", 2);
                this.append(sb, "Flag used to determine whether the build logs should be output to the normal mojo log.", 3);
                this.append(sb, "Expression: ${invoker.streamLogs}", 3);
                this.append(sb, "", 0);
                this.append(sb, "suppressSummaries (Default: false)", 2);
                this.append(sb, "Flag used to suppress the summary output notifying of successes and failures. If set to true, the only indication of the build's success or failure will be the effect it has on the main build (if it fails, the main build should fail as well). If streamLogs is enabled, the sub-build summary will also provide an indication.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testProperties", 2);
                this.append(sb, "Deprecated. As of version 1.1, use the properties parameter instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "Common set of test properties to pass in on each IT's command line, via -D parameters.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testPropertiesFile (Default: test.properties)", 2);
                this.append(sb, "Location of a properties file that defines CLI properties for the test.", 3);
                this.append(sb, "Expression: ${invoker.testPropertiesFile}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "verify".equals(this.goal)) {
            this.append(sb, "invoker:verify", 0);
            this.append(sb, "Checks the results of maven-invoker-plugin based integration tests and fails the build if any tests failed.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "ignoreFailures (Default: false)", 2);
                this.append(sb, "A flag controlling whether failures of the sub builds should fail the main build, too. If set to true, the main build will proceed even if one or more sub builds failed.", 3);
                this.append(sb, "Expression: ${maven.test.failure.ignore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory (Default: ${project.build.directory}/invoker-reports)", 2);
                this.append(sb, "Base directory where all build reports are read from.", 3);
                this.append(sb, "Expression: ${invoker.reportsDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipInvocation (Default: false)", 2);
                this.append(sb, "Flag used to suppress certain invocations. This is useful in tailoring the build using profiles.", 3);
                this.append(sb, "Expression: ${invoker.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "suppressSummaries (Default: false)", 2);
                this.append(sb, "Flag used to suppress the summary output notifying of successes and failures. If set to true, the only indication of the build's success or failure will be the effect it has on the main build (if it fails, the main build should fail as well).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List<String> lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

