/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.invoker;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.invoker.ReportUtils;
import org.apache.maven.plugin.invoker.model.BuildJob;
import org.apache.maven.plugin.invoker.model.io.xpp3.BuildJobXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokerReport
extends AbstractMavenReport {
    protected MavenProject project;
    protected Renderer siteRenderer;
    protected I18N i18n;
    protected File outputDirectory;
    private File reportsDirectory;
    private NumberFormat percentFormat;
    private NumberFormat secondsFormat;

    protected void executeReport(Locale locale) throws MavenReportException {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        this.percentFormat = new DecimalFormat(this.getText(locale, "report.invoker.format.percent"), symbols);
        this.secondsFormat = new DecimalFormat(this.getText(locale, "report.invoker.format.seconds"), symbols);
        Sink sink = this.getSink();
        sink.head();
        sink.title();
        sink.text(this.getText(locale, "report.invoker.result.title"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.getText(locale, "report.invoker.result.title"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.getText(locale, "report.invoker.result.description"));
        sink.paragraph_();
        sink.section1_();
        File[] reportFiles = ReportUtils.getReportFiles(this.reportsDirectory);
        if (reportFiles.length <= 0) {
            this.getLog().info((CharSequence)"no invoker report files found, skip report generation");
            return;
        }
        ArrayList<BuildJob> buildJobs = new ArrayList<BuildJob>(reportFiles.length);
        for (File reportFile : reportFiles) {
            try {
                BuildJobXpp3Reader reader = new BuildJobXpp3Reader();
                buildJobs.add(reader.read((Reader)ReaderFactory.newXmlReader((File)reportFile)));
            }
            catch (XmlPullParserException e) {
                throw new MavenReportException("Failed to parse report file: " + reportFile, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to read report file: " + reportFile, (Exception)e);
            }
        }
        this.constructSummarySection(buildJobs, locale);
        sink.section2();
        sink.sectionTitle2();
        sink.text(this.getText(locale, "report.invoker.detail.title"));
        sink.sectionTitle2_();
        sink.section2_();
        sink.table();
        sink.tableRow();
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.detail.name"));
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.detail.result"));
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.detail.time"));
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.detail.message"));
        sink.tableRow_();
        for (BuildJob buildJob : buildJobs) {
            this.renderBuildJob(buildJob, locale);
        }
        sink.table_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void constructSummarySection(List<? extends BuildJob> buildJobs, Locale locale) {
        Sink sink = this.getSink();
        sink.section2();
        sink.sectionTitle2();
        sink.text(this.getText(locale, "report.invoker.summary.title"));
        sink.sectionTitle2_();
        sink.section2_();
        sink.table();
        sink.tableRow();
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.summary.number"));
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.summary.success"));
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.summary.failed"));
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.summary.success.rate"));
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.summary.time.total"));
        this.sinkTableHeader(sink, this.getText(locale, "report.invoker.summary.time.avg"));
        int number = buildJobs.size();
        int success = 0;
        int failed = 0;
        double totalTime = 0.0;
        for (BuildJob buildJob : buildJobs) {
            if ("success".equals(buildJob.getResult())) {
                ++success;
            } else if (!"skipped".equals(buildJob.getResult())) {
                ++failed;
            }
            totalTime += buildJob.getTime();
        }
        sink.tableRow_();
        sink.tableRow();
        this.sinkCell(sink, Integer.toString(number));
        this.sinkCell(sink, Integer.toString(success));
        this.sinkCell(sink, Integer.toString(failed));
        if (success + failed > 0) {
            this.sinkCell(sink, this.percentFormat.format((double)success / (double)(success + failed)));
        } else {
            this.sinkCell(sink, "");
        }
        this.sinkCell(sink, this.secondsFormat.format(totalTime));
        this.sinkCell(sink, this.secondsFormat.format(totalTime / (double)number));
        sink.tableRow_();
        sink.table_();
    }

    private void renderBuildJob(BuildJob buildJob, Locale locale) {
        Sink sink = this.getSink();
        sink.tableRow();
        StringBuffer buffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)buildJob.getName()) && !StringUtils.isEmpty((String)buildJob.getDescription())) {
            buffer.append(buildJob.getName());
            buffer.append(" : ");
            buffer.append(buildJob.getDescription());
        } else {
            buffer.append(buildJob.getProject());
        }
        this.sinkCell(sink, buffer.toString());
        this.sinkCell(sink, buildJob.getResult());
        this.sinkCell(sink, this.secondsFormat.format(buildJob.getTime()));
        this.sinkCell(sink, buildJob.getFailureMessage());
        sink.tableRow_();
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return this.getText(locale, "report.invoker.result.description");
    }

    public String getName(Locale locale) {
        return this.getText(locale, "report.invoker.result.name");
    }

    public String getOutputName() {
        return "invoker-report";
    }

    public boolean canGenerateReport() {
        return ReportUtils.getReportFiles(this.reportsDirectory).length > 0;
    }

    private String getText(Locale locale, String key) {
        return this.i18n.getString("invoker-report", locale, key);
    }

    private void sinkTableHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }
}

