/*
 * $Id$
 */

package org.apache.maven.plugin.javadoc.options;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * An offline link parameter.
 * 
 * @version $Revision$ $Date$
 */
public class OfflineLink implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field url
     */
    private String url;

    /**
     * Field location
     */
    private String location;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof OfflineLink) )
        {
            return false;
        }
        
        OfflineLink that = (OfflineLink) other;
        boolean result = true;
        result = result && ( getUrl() == null ? that.getUrl() == null : getUrl().equals( that.getUrl() ) );
        result = result && ( getLocation() == null ? that.getLocation() == null : getLocation().equals( that.getLocation() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get The location of the link.
     */
    public String getLocation()
    {
        return this.location;
    } //-- String getLocation() 

    /**
     * Get The url of the link.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( url != null ? url.hashCode() : 0 );
        result = 37 * result + ( location != null ? location.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set The location of the link.
     * 
     * @param location
     */
    public void setLocation(String location)
    {
        this.location = location;
    } //-- void setLocation(String) 

    /**
     * Set The url of the link.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "url = '" );
        buf.append( getUrl() + "'" );
        buf.append( "\n" ); 
        buf.append( "location = '" );
        buf.append( getLocation() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
