/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavadocUtil {
    public static final int DEFAULT_TIMEOUT = 2000;

    protected static List pruneDirs(MavenProject project, List dirs) {
        ArrayList<String> pruned = new ArrayList<String>(dirs.size());
        Iterator i = dirs.iterator();
        while (i.hasNext()) {
            String dir = (String)i.next();
            if (dir == null) continue;
            File directory = new File(dir);
            if (!directory.isAbsolute()) {
                directory = new File(project.getBasedir(), directory.getPath());
            }
            if (!directory.isDirectory() || pruned.contains(directory.getAbsolutePath())) continue;
            pruned.add(directory.getAbsolutePath());
        }
        return pruned;
    }

    protected static List pruneFiles(List files) {
        ArrayList<String> pruned = new ArrayList<String>(files.size());
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File file;
            String f = (String)i.next();
            if (f == null || !(file = new File(f)).isFile() || pruned.contains(f)) continue;
            pruned.add(f);
        }
        return pruned;
    }

    protected static List getExcludedNames(List sourcePaths, String[] subpackagesList, String[] excludedPackages) {
        ArrayList excludedNames = new ArrayList();
        Iterator i = sourcePaths.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            for (int j = 0; j < subpackagesList.length; ++j) {
                List excludes = JavadocUtil.getExcludedPackages(path, excludedPackages);
                excludedNames.addAll(excludes);
            }
        }
        return excludedNames;
    }

    protected static List getCompileArtifacts(Set artifacts) {
        return JavadocUtil.getCompileArtifacts(artifacts, false);
    }

    protected static List getCompileArtifacts(Set artifacts, boolean withTestScope) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts.size());
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!a.getArtifactHandler().isAddedToClasspath()) continue;
            if (withTestScope) {
                if (!"compile".equals(a.getScope()) && !"provided".equals(a.getScope()) && !"system".equals(a.getScope()) && !"test".equals(a.getScope())) continue;
                list.add(a);
                continue;
            }
            if (!"compile".equals(a.getScope()) && !"provided".equals(a.getScope()) && !"system".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    protected static String quotedArgument(String value) {
        String arg = value;
        if (StringUtils.isNotEmpty((String)arg)) {
            if (arg.indexOf("'") != -1) {
                arg = StringUtils.replace((String)arg, (String)"'", (String)"\\'");
            }
            arg = "'" + arg + "'";
            arg = StringUtils.replace((String)arg, (String)"\n", (String)" ");
        }
        return arg;
    }

    protected static String quotedPathArgument(String value) {
        String path = value;
        if (StringUtils.isNotEmpty((String)path)) {
            if ((path = path.replace('\\', '/')).indexOf("'") != -1) {
                String[] split = path.split("'");
                path = "";
                for (int i = 0; i < split.length; ++i) {
                    path = i != split.length - 1 ? path + split[i] + "\\'" : path + split[i];
                }
            }
            path = "'" + path + "'";
        }
        return path;
    }

    protected static void copyJavadocResources(File outputDirectory, File javadocDir) throws IOException {
        JavadocUtil.copyJavadocResources(outputDirectory, javadocDir, null);
    }

    protected static void copyJavadocResources(File outputDirectory, File javadocDir, String excludedocfilessubdir) throws IOException {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(Arrays.asList(FileUtils.getDefaultExcludes()));
        if (StringUtils.isNotEmpty((String)excludedocfilessubdir)) {
            StringTokenizer st = new StringTokenizer(excludedocfilessubdir, ":");
            while (st.hasMoreTokens()) {
                String current = st.nextToken();
                excludes.add("**/" + current + "/**");
            }
        }
        if (javadocDir.exists() && javadocDir.isDirectory()) {
            List docFiles = FileUtils.getDirectoryNames((File)javadocDir, (String)"**/doc-files", (String)StringUtils.join(excludes.iterator(), (String)","), (boolean)false, (boolean)true);
            Iterator it = docFiles.iterator();
            while (it.hasNext()) {
                String docFile = (String)it.next();
                File docFileOutput = new File(outputDirectory, docFile);
                FileUtils.mkdir((String)docFileOutput.getAbsolutePath());
                FileUtils.copyDirectoryStructure((File)new File(javadocDir, docFile), (File)docFileOutput);
                List files = FileUtils.getFileAndDirectoryNames((File)docFileOutput, (String)StringUtils.join(excludes.iterator(), (String)","), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                Iterator it2 = files.iterator();
                while (it2.hasNext()) {
                    File file = new File(it2.next().toString());
                    if (file.isDirectory()) {
                        FileUtils.deleteDirectory((File)file);
                        continue;
                    }
                    file.delete();
                }
            }
        }
    }

    protected static List getIncludedFiles(File sourceDirectory, String[] fileList, String[] excludePackages) {
        ArrayList<String> files = new ArrayList<String>();
        for (int j = 0; j < fileList.length; ++j) {
            boolean include = true;
            for (int k = 0; k < excludePackages.length && include; ++k) {
                String[] excludeName = excludePackages[k].split("[*]");
                if (excludeName.length == 0) continue;
                if (excludeName.length > 1) {
                    for (int u = 0; include && u < excludeName.length; ++u) {
                        if ("".equals(excludeName[u].trim()) || fileList[j].indexOf(excludeName[u]) == -1) continue;
                        include = false;
                    }
                    continue;
                }
                if (!fileList[j].startsWith(sourceDirectory.toString() + File.separatorChar + excludeName[0])) continue;
                if (excludeName[0].endsWith(String.valueOf(File.separatorChar))) {
                    File excludedPackage;
                    int i = fileList[j].lastIndexOf(File.separatorChar);
                    String packageName = fileList[j].substring(0, i + 1);
                    File currentPackage = new File(packageName);
                    if (currentPackage.equals(excludedPackage = new File(sourceDirectory, excludeName[0])) && fileList[j].substring(i).indexOf(".java") != -1) {
                        include = true;
                        continue;
                    }
                    include = false;
                    continue;
                }
                include = false;
            }
            if (!include) continue;
            files.add(JavadocUtil.quotedPathArgument(fileList[j]));
        }
        return files;
    }

    protected static List getExcludedPackages(String sourceDirectory, String[] excludePackagenames) {
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < excludePackagenames.length; ++i) {
            String[] fileList = FileUtils.getFilesFromExtension((String)sourceDirectory, (String[])new String[]{"java"});
            for (int j = 0; j < fileList.length; ++j) {
                String[] excludeName = excludePackagenames[i].split("[*]");
                for (int u = 0; u < excludeName.length; ++u) {
                    if ("".equals(excludeName[u].trim()) || fileList[j].indexOf(excludeName[u]) == -1 || sourceDirectory.indexOf(excludeName[u]) != -1) continue;
                    files.add(fileList[j]);
                }
            }
        }
        ArrayList<String> excluded = new ArrayList<String>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String file = (String)it.next();
            int idx = file.lastIndexOf(File.separatorChar);
            String tmpStr = file.substring(0, idx);
            String[] srcSplit = (tmpStr = tmpStr.replace('\\', '/')).split(sourceDirectory.replace('\\', '/') + '/');
            String excludedPackage = srcSplit[1].replace('/', '.');
            if (excluded.contains(excludedPackage)) continue;
            excluded.add(excludedPackage);
        }
        return excluded;
    }

    protected static void addFilesFromSource(List files, File sourceDirectory, String[] excludePackages) {
        String[] fileList = FileUtils.getFilesFromExtension((String)sourceDirectory.getPath(), (String[])new String[]{"java"});
        if (fileList != null && fileList.length != 0) {
            List tmpFiles = JavadocUtil.getIncludedFiles(sourceDirectory, fileList, excludePackages);
            files.addAll(tmpFiles);
        }
    }

    protected static float getJavadocVersion(File javadocExe) throws IOException, CommandLineException, IllegalArgumentException, PatternSyntaxException {
        if (javadocExe == null || !javadocExe.exists() || !javadocExe.isFile()) {
            throw new IOException("The javadoc executable '" + javadocExe + "' doesn't exist or is not a file. ");
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable(javadocExe.getAbsolutePath());
        cmd.setWorkingDirectory(javadocExe.getParentFile());
        cmd.createArg().setValue("-J-version");
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        if (exitCode != 0) {
            StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
            msg.append('\n');
            msg.append("Command line was:" + CommandLineUtils.toString((String[])cmd.getCommandline()));
            throw new CommandLineException(msg.toString());
        }
        if (StringUtils.isNotEmpty((String)err.getOutput())) {
            return JavadocUtil.parseJavadocVersion(err.getOutput());
        }
        if (StringUtils.isNotEmpty((String)out.getOutput())) {
            return JavadocUtil.parseJavadocVersion(out.getOutput());
        }
        throw new IllegalArgumentException("No output found from the command line 'javadoc -J-version'");
    }

    protected static float parseJavadocVersion(String output) throws IllegalArgumentException, PatternSyntaxException {
        if (StringUtils.isEmpty((String)output)) {
            throw new IllegalArgumentException("The output could not be null.");
        }
        Pattern pattern = Pattern.compile("(?s).*?([0-9]+\\.[0-9]+)(\\.([0-9]+))?.*");
        Matcher matcher = pattern.matcher(output);
        if (!matcher.matches()) {
            throw new PatternSyntaxException("Unrecognized version of Javadoc: '" + output + "'", pattern.pattern(), pattern.toString().length() - 1);
        }
        String version = matcher.group(3);
        version = version == null ? matcher.group(1) : matcher.group(1) + version;
        return Float.parseFloat(version);
    }

    protected static String parseJavadocMemory(String memory) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)memory)) {
            throw new IllegalArgumentException("The memory could not be null.");
        }
        Pattern p = Pattern.compile("^\\s*(\\d+)\\s*?\\s*$");
        Matcher m = p.matcher(memory);
        if (m.matches()) {
            return m.group(1) + "m";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*k(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return m.group(1) + "k";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*m(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return m.group(1) + "m";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*g(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return Integer.parseInt(m.group(1)) * 1024 + "m";
        }
        p = Pattern.compile("^\\s*(\\d+)\\s*t(b)?\\s*$", 2);
        m = p.matcher(memory);
        if (m.matches()) {
            return Integer.parseInt(m.group(1)) * 1024 * 1024 + "m";
        }
        throw new IllegalArgumentException("Could convert not to a memory size: " + memory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fetchURL(Settings settings, URL url) throws IOException {
        InputStream in;
        block12: {
            if (url == null) {
                throw new IllegalArgumentException("The url is null");
            }
            HttpClient httpClient = null;
            if (!"file".equals(url.getProtocol())) {
                Proxy activeProxy;
                httpClient = new HttpClient();
                httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(2000);
                httpClient.getHttpConnectionManager().getParams().setSoTimeout(2000);
                if (settings != null && (activeProxy = settings.getActiveProxy()) != null) {
                    String proxyHost = settings.getActiveProxy().getHost();
                    int proxyPort = settings.getActiveProxy().getPort();
                    String proxyUser = settings.getActiveProxy().getUsername();
                    String proxyPass = settings.getActiveProxy().getPassword();
                    if (StringUtils.isNotEmpty((String)proxyHost)) {
                        httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
                    }
                    if (StringUtils.isNotEmpty((String)proxyUser)) {
                        AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
                        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(proxyUser, proxyPass);
                        httpClient.getState().setProxyCredentials(authScope, (Credentials)usernamePasswordCredentials);
                    }
                }
            }
            in = null;
            try {
                if (httpClient != null) {
                    GetMethod getMethod = new GetMethod(url.toString());
                    try {
                        int status = httpClient.executeMethod((HttpMethod)getMethod);
                        if (status != 200) {
                            throw new FileNotFoundException(url.toString());
                        }
                        break block12;
                    }
                    finally {
                        getMethod.releaseConnection();
                    }
                }
                in = url.openStream();
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean validateEncoding(String charsetName) {
        if (StringUtils.isEmpty((String)charsetName)) {
            return false;
        }
        ByteArrayOutputStream ost = new ByteArrayOutputStream();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)ost, charsetName);
        }
        catch (UnsupportedEncodingException exc) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtil.close(osw);
                throw throwable;
            }
            IOUtil.close((Writer)osw);
            return bl;
        }
        IOUtil.close((Writer)osw);
        return true;
    }

    protected static String hideProxyPassword(String cmdLine, Settings settings) {
        if (cmdLine == null) {
            throw new IllegalArgumentException("cmdLine could not be null");
        }
        if (settings == null) {
            return cmdLine;
        }
        Proxy activeProxy = settings.getActiveProxy();
        if (activeProxy != null && StringUtils.isNotEmpty((String)activeProxy.getHost()) && StringUtils.isNotEmpty((String)activeProxy.getUsername()) && StringUtils.isNotEmpty((String)activeProxy.getPassword())) {
            String pass = "-J-Dhttp.proxyPassword=\"" + activeProxy.getPassword() + "\"";
            String hidepass = "-J-Dhttp.proxyPassword=\"" + StringUtils.repeat((String)"*", (int)activeProxy.getPassword().length()) + "\"";
            return StringUtils.replace((String)cmdLine, (String)pass, (String)hidepass);
        }
        return cmdLine;
    }

    protected static List getTagletClassNames(File jarFile) throws IOException, ClassNotFoundException, NoClassDefFoundError {
        List classes = JavadocUtil.getClassNamesFromJar(jarFile);
        File tools = new File(System.getProperty("java.home"), "../lib/tools.jar");
        URLClassLoader cl = tools.exists() && tools.isFile() ? new URLClassLoader(new URL[]{jarFile.toURI().toURL(), tools.toURI().toURL()}, null) : new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, null);
        ArrayList<String> tagletClasses = new ArrayList<String>();
        Class<?> tagletClass = cl.loadClass("com.sun.tools.doclets.Taglet");
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            Class<?> c = cl.loadClass(s);
            if (!tagletClass.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
            tagletClasses.add(c.getName());
        }
        return tagletClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyResource(URL url, File file) throws IOException {
        if (file == null) {
            throw new IOException("The file " + file + " can't be null.");
        }
        if (url == null) {
            throw new IOException("The url " + url + " could not be null.");
        }
        InputStream is = url.openStream();
        if (is == null) {
            throw new IOException("The resource " + url + " doesn't exists.");
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            IOUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            IOUtil.close((InputStream)is);
            IOUtil.close((OutputStream)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void invokeMaven(Log log, File localRepositoryDir, File projectFile, List goals, Properties properties, File invokerLog) {
        InvocationResult result;
        File javaHome;
        if (projectFile == null) {
            throw new IllegalArgumentException("projectFile should be not null.");
        }
        if (!projectFile.isFile()) {
            throw new IllegalArgumentException(projectFile.getAbsolutePath() + " is not a file.");
        }
        if (goals == null || goals.size() == 0) {
            throw new IllegalArgumentException("goals should be not empty.");
        }
        if (localRepositoryDir == null || !localRepositoryDir.isDirectory()) {
            throw new IllegalArgumentException("localRepositoryDir '" + localRepositoryDir + "' should be a directory.");
        }
        String mavenHome = JavadocUtil.getMavenHome(log);
        if (StringUtils.isEmpty((String)mavenHome)) {
            String msg = "Could NOT invoke Maven because no Maven Home is defined. You need to have set the M2_HOME system env variable or a maven.home Java system properties.";
            if (log != null) {
                log.error((CharSequence)msg);
            } else {
                System.err.println(msg);
            }
            return;
        }
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        invoker.setLocalRepositoryDirectory(localRepositoryDir);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setBaseDirectory(projectFile.getParentFile());
        request.setPomFile(projectFile);
        if (log != null) {
            request.setDebug(log.isDebugEnabled());
        } else {
            request.setDebug(true);
        }
        request.setGoals(goals);
        if (properties != null) {
            request.setProperties(properties);
        }
        if ((javaHome = JavadocUtil.getJavaHome(log)) != null) {
            request.setJavaHome(javaHome);
        }
        try {
            if (log != null) {
                log.debug((CharSequence)("Invoking Maven for the goals: " + goals + " with properties=" + properties));
            }
            result = JavadocUtil.invoke(log, (Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, null);
        }
        catch (MavenInvocationException e) {
            if (log != null) {
                if (log.isDebugEnabled()) {
                    log.error((CharSequence)("MavenInvocationException: " + e.getMessage()), (Throwable)e);
                } else {
                    log.error((CharSequence)("MavenInvocationException: " + e.getMessage()));
                }
                log.error((CharSequence)"Error when invoking Maven, consult the invoker log.");
            }
            return;
        }
        String invokerLogContent = null;
        Reader reader = null;
        try {
            reader = ReaderFactory.newReader((File)invokerLog, (String)"UTF-8");
            invokerLogContent = IOUtil.toString((Reader)reader);
        }
        catch (IOException e) {
            if (log != null) {
                log.error((CharSequence)("IOException: " + e.getMessage()));
            }
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        if (invokerLogContent != null && invokerLogContent.indexOf("Error occurred during initialization of VM") != -1) {
            if (log != null) {
                log.info((CharSequence)"Error occurred during initialization of VM, try to use an empty MAVEN_OPTS.");
                log.debug((CharSequence)("Reinvoking Maven for the goals: " + goals + " with an empty MAVEN_OPTS"));
            }
            try {
                result = JavadocUtil.invoke(log, (Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, "");
            }
            catch (MavenInvocationException e) {
                if (log != null) {
                    if (log.isDebugEnabled()) {
                        log.error((CharSequence)("MavenInvocationException: " + e.getMessage()), (Throwable)e);
                    } else {
                        log.error((CharSequence)("MavenInvocationException: " + e.getMessage()));
                    }
                    log.error((CharSequence)"Error when reinvoking Maven, consult the invoker log.");
                }
                return;
            }
        }
        if (result.getExitCode() != 0 && log != null) {
            log.error((CharSequence)("Error when invoking Maven, consult the invoker log file: " + invokerLog.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getClassNamesFromJar(File jarFile) throws IOException {
        if (jarFile == null || !jarFile.exists() || !jarFile.isFile()) {
            throw new IOException("The jar '" + jarFile + "' doesn't exist or is not a file.");
        }
        ArrayList<String> classes = new ArrayList<String>();
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(new FileInputStream(jarFile));
            JarEntry jarEntry = jarStream.getNextJarEntry();
            while (jarEntry != null && jarEntry != null) {
                if (jarEntry.getName().toLowerCase(Locale.ENGLISH).endsWith(".class")) {
                    String name = jarEntry.getName().substring(0, jarEntry.getName().indexOf("."));
                    classes.add(name.replaceAll("/", "\\."));
                }
                jarStream.closeEntry();
                jarEntry = jarStream.getNextJarEntry();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(jarStream);
            throw throwable;
        }
        IOUtil.close((InputStream)jarStream);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InvocationResult invoke(Log log, Invoker invoker, InvocationRequest request, File invokerLog, List goals, Properties properties, String mavenOpts) throws MavenInvocationException {
        PrintStream ps;
        FileOutputStream os = null;
        if (invokerLog != null) {
            log.debug((CharSequence)("Using " + invokerLog.getAbsolutePath() + " to log the invoker"));
            try {
                if (!invokerLog.exists()) {
                    invokerLog.getParentFile().mkdirs();
                }
                os = new FileOutputStream(invokerLog);
                ps = new PrintStream((OutputStream)os, true, "UTF-8");
            }
            catch (FileNotFoundException e) {
                if (log != null) {
                    log.error((CharSequence)("FileNotFoundException: " + e.getMessage() + ". Using System.out to log the invoker."));
                }
                ps = System.out;
            }
            catch (UnsupportedEncodingException e) {
                if (log != null) {
                    log.error((CharSequence)("UnsupportedEncodingException: " + e.getMessage() + ". Using System.out to log the invoker."));
                }
                ps = System.out;
            }
        } else {
            log.debug((CharSequence)"Using System.out to log the invoker.");
            ps = System.out;
        }
        if (mavenOpts != null) {
            request.setMavenOpts(mavenOpts);
        }
        PrintStreamHandler outputHandler = new PrintStreamHandler(ps, false);
        request.setOutputHandler((InvocationOutputHandler)outputHandler);
        outputHandler.consumeLine("Invoking Maven for the goals: " + goals + " with properties=" + properties);
        outputHandler.consumeLine("");
        outputHandler.consumeLine("M2_HOME=" + JavadocUtil.getMavenHome(log));
        outputHandler.consumeLine("MAVEN_OPTS=" + JavadocUtil.getMavenOpts(log));
        outputHandler.consumeLine("JAVA_HOME=" + JavadocUtil.getJavaHome(log));
        outputHandler.consumeLine("JAVA_OPTS=" + JavadocUtil.getJavaOpts(log));
        outputHandler.consumeLine("");
        try {
            InvocationResult invocationResult = invoker.execute(request);
            return invocationResult;
        }
        finally {
            IOUtil.close((OutputStream)os);
            ps = null;
        }
    }

    private static String getMavenHome(Log log) {
        File m2Home;
        String mavenHome;
        block4: {
            mavenHome = System.getProperty("maven.home");
            if (mavenHome == null) {
                try {
                    mavenHome = CommandLineUtils.getSystemEnvVars().getProperty("M2_HOME");
                }
                catch (IOException e) {
                    if (log == null) break block4;
                    log.debug((CharSequence)("IOException: " + e.getMessage()));
                }
            }
        }
        if (!(m2Home = new File(mavenHome)).exists() && log != null) {
            log.error((CharSequence)"Cannot find Maven application directory. Either specify 'maven.home' system property, or M2_HOME environment variable.");
        }
        return mavenHome;
    }

    private static String getMavenOpts(Log log) {
        String mavenOpts;
        block2: {
            mavenOpts = null;
            try {
                mavenOpts = CommandLineUtils.getSystemEnvVars().getProperty("MAVEN_OPTS");
            }
            catch (IOException e) {
                if (log == null) break block2;
                log.debug((CharSequence)("IOException: " + e.getMessage()));
            }
        }
        return mavenOpts;
    }

    private static File getJavaHome(Log log) {
        File javaHome;
        block4: {
            javaHome = SystemUtils.IS_OS_MAC_OSX ? SystemUtils.getJavaHome() : new File(SystemUtils.getJavaHome(), "..");
            if (javaHome == null || !javaHome.exists()) {
                try {
                    javaHome = new File(CommandLineUtils.getSystemEnvVars().getProperty("JAVA_HOME"));
                }
                catch (IOException e) {
                    if (log == null) break block4;
                    log.debug((CharSequence)("IOException: " + e.getMessage()));
                }
            }
        }
        if (!(javaHome != null && javaHome.exists() || log == null)) {
            log.error((CharSequence)"Cannot find Java application directory. Either specify 'java.home' system property, or JAVA_HOME environment variable.");
        }
        return javaHome;
    }

    private static String getJavaOpts(Log log) {
        String javaOpts;
        block2: {
            javaOpts = null;
            try {
                javaOpts = CommandLineUtils.getSystemEnvVars().getProperty("JAVA_OPTS");
            }
            catch (IOException e) {
                if (log == null) break block2;
                log.debug((CharSequence)("IOException: " + e.getMessage()));
            }
        }
        return javaOpts;
    }
}

