package org.apache.maven.plugin.javadoc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-javadoc-plugin.<br/> Call <pre>  mvn javadoc:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Apr 30 14:03:34 EDT 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-javadoc-plugin:2.7", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Javadoc Plugin", 0 );
        append( sb, "The Maven Javadoc Plugin is a plugin that uses the javadoc tool for generating javadocs for the specified project.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 13 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "aggregate".equals( goal ) )
        {
            append( sb, "javadoc:aggregate", 0 );
            append( sb, "Generates documentation for the Java code in an aggregator project using the standard Javadoc Tool.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "description", 2 );
                append( sb, "The description of the Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "destDir (Default: apidocs)", 2 );
                append( sb, "The name of the destination directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "name", 2 );
                append( sb, "The name of the Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "reportOutputDirectory (Default: ${project.reporting.outputDirectory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "aggregate-jar".equals( goal ) )
        {
            append( sb, "javadoc:aggregate-jar", 0 );
            append( sb, "Bundles the Javadoc documentation for main Java code in an aggregator project into a jar using the standard Javadoc Tool.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether to attach the generated artifact to the project helper.\n", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "destDir", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files. See d.", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName", 2 );
                append( sb, "Specifies the filename that will be used for the generated jar file. Please note that -javadoc or -test-javadoc will be appended to the file name.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "jarOutputDirectory", 2 );
                append( sb, "Specifies the directory where the generated jar file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultManifestFile (Default: false)", 2 );
                append( sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "fix".equals( goal ) )
        {
            append( sb, "javadoc:fix", 0 );
            append( sb, "Fix Javadoc documentation and tags for the Java code for the project. See Where Tags Can Be Used.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "comparisonVersion (Default: (,${project.version}))", 2 );
                append( sb, "Version to compare the current code against using the Clirr Maven Plugin.\nSee defaultSince.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultAuthor", 2 );
                append( sb, "Default value for the Javadoc tag @author.\nIf not specified, the user.name defined in the System properties will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultSince (Default: ${project.version})", 2 );
                append( sb, "Default value for the Javadoc tag @since.\n", 3 );
                append( sb, "", 0 );

                append( sb, "defaultVersion", 2 );
                append( sb, "Default value for the Javadoc tag @version.\nBy default, it is $Id:$, corresponding to a SVN keyword. Refer to your SCM to use an other SCM keyword.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separated excludes Java files, i.e. **/*Test.java.", 3 );
                append( sb, "", 0 );

                append( sb, "fixClassComment (Default: true)", 2 );
                append( sb, "Flag to fix the classes or interfaces Javadoc comments according the level.", 3 );
                append( sb, "", 0 );

                append( sb, "fixFieldComment (Default: true)", 2 );
                append( sb, "Flag to fix the fields Javadoc comments according the level.", 3 );
                append( sb, "", 0 );

                append( sb, "fixMethodComment (Default: true)", 2 );
                append( sb, "Flag to fix the methods Javadoc comments according the level.", 3 );
                append( sb, "", 0 );

                append( sb, "fixTags (Default: all)", 2 );
                append( sb, "Comma separated tags to fix in classes, interfaces or methods Javadoc comments. Possible values are:\n-\tall (fix all Javadoc tags)\n-\tauthor (fix only @author tag)\n-\tversion (fix only @version tag)\n-\tsince (fix only @since tag)\n-\tparam (fix only @param tag)\n-\treturn (fix only @return tag)\n-\tthrows (fix only @throws tag)\n", 3 );
                append( sb, "", 0 );

                append( sb, "force", 2 );
                append( sb, "Forcing the goal execution i.e. skip warranty messages (not recommended).", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreClirr (Default: false)", 2 );
                append( sb, "Flag to ignore or not Clirr.", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **/*.java)", 2 );
                append( sb, "Comma separated includes Java files, i.e. **/*Test.java.", 3 );
                append( sb, "", 0 );

                append( sb, "level (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located, used by the tests.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.sourceDirectory})", 2 );
                append( sb, "Output directory where Java classes will be rewrited.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "javadoc:help", 0 );
            append( sb, "Display help information on maven-javadoc-plugin.\nCall\n\u00a0\u00a0mvn\u00a0javadoc:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jar".equals( goal ) )
        {
            append( sb, "javadoc:jar", 0 );
            append( sb, "Bundles the Javadoc documentation for main Java code in an NON aggregator project into a jar using the standard Javadoc Tool.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether to attach the generated artifact to the project helper.\n", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "destDir", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files. See d.", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName", 2 );
                append( sb, "Specifies the filename that will be used for the generated jar file. Please note that -javadoc or -test-javadoc will be appended to the file name.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "jarOutputDirectory", 2 );
                append( sb, "Specifies the directory where the generated jar file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultManifestFile (Default: false)", 2 );
                append( sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "javadoc".equals( goal ) )
        {
            append( sb, "javadoc:javadoc", 0 );
            append( sb, "Generates documentation for the Java code in an NON aggregator project using the standard Javadoc Tool.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "description", 2 );
                append( sb, "The description of the Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "destDir (Default: apidocs)", 2 );
                append( sb, "The name of the destination directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "name", 2 );
                append( sb, "The name of the Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "reportOutputDirectory (Default: ${project.reporting.outputDirectory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "resource-bundle".equals( goal ) )
        {
            append( sb, "javadoc:resource-bundle", 0 );
            append( sb, "Bundle AbstractJavadocMojo.javadocDirectory, along with javadoc configuration options such as taglet, doclet, and link information into a deployable artifact. This artifact can then be consumed by the javadoc plugin mojos when used by the includeDependencySources option, to generate javadocs that are somewhat consistent with those generated in the original project itself.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-aggregate".equals( goal ) )
        {
            append( sb, "javadoc:test-aggregate", 0 );
            append( sb, "Generates documentation for the Java Test code in an aggregator project using the standard Javadoc Tool.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "description", 2 );
                append( sb, "The description of the Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "destDir (Default: testapidocs)", 2 );
                append( sb, "The name of the destination directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "name", 2 );
                append( sb, "The name of the Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "reportOutputDirectory (Default: ${project.reporting.outputDirectory}/testapidocs)", 2 );
                append( sb, "Specifies the destination directory where test Javadoc saves the generated HTML files.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testDescription", 2 );
                append( sb, "The description of the Test Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "testDoctitle (Default: ${project.name} ${project.version} Test API)", 2 );
                append( sb, "Specifies the Test title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testJavadocDirectory", 2 );
                append( sb, "Specifies the Test Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "testName", 2 );
                append( sb, "The name of the Test Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "testOverview (Default: ${basedir}/src/test/javadoc/overview.html)", 2 );
                append( sb, "Specifies that Javadoc should retrieve the text for the Test overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testWindowtitle (Default: ${project.name} ${project.version} Test API)", 2 );
                append( sb, "Specifies the Test title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-aggregate-jar".equals( goal ) )
        {
            append( sb, "javadoc:test-aggregate-jar", 0 );
            append( sb, "Bundles the Javadoc documentation for Java Test code in an aggregator project into a jar using the standard Javadoc Tool.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether to attach the generated artifact to the project helper.\n", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "destDir", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files. See d.", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName", 2 );
                append( sb, "Specifies the filename that will be used for the generated jar file. Please note that -javadoc or -test-javadoc will be appended to the file name.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "jarOutputDirectory", 2 );
                append( sb, "Specifies the directory where the generated jar file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/testapidocs)", 2 );
                append( sb, "Specifies the destination directory where Javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testDoctitle (Default: ${project.name} ${project.version} Test API)", 2 );
                append( sb, "Specifies the Test title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testJavadocDirectory", 2 );
                append( sb, "Specifies the Test Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).", 3 );
                append( sb, "", 0 );

                append( sb, "testOverview (Default: ${basedir}/src/test/javadoc/overview.html)", 2 );
                append( sb, "Specifies that Javadoc should retrieve the text for the Test overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testWindowtitle (Default: ${project.name} ${project.version} Test API)", 2 );
                append( sb, "Specifies the Test title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultManifestFile (Default: false)", 2 );
                append( sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-fix".equals( goal ) )
        {
            append( sb, "javadoc:test-fix", 0 );
            append( sb, "Fix Javadoc documentation and tags for the Test Java code for the project. See Where Tags Can Be Used.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "comparisonVersion (Default: (,${project.version}))", 2 );
                append( sb, "Version to compare the current code against using the Clirr Maven Plugin.\nSee defaultSince.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultAuthor", 2 );
                append( sb, "Default value for the Javadoc tag @author.\nIf not specified, the user.name defined in the System properties will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultSince (Default: ${project.version})", 2 );
                append( sb, "Default value for the Javadoc tag @since.\n", 3 );
                append( sb, "", 0 );

                append( sb, "defaultVersion", 2 );
                append( sb, "Default value for the Javadoc tag @version.\nBy default, it is $Id:$, corresponding to a SVN keyword. Refer to your SCM to use an other SCM keyword.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Comma separated excludes Java files, i.e. **/*Test.java.", 3 );
                append( sb, "", 0 );

                append( sb, "fixClassComment (Default: true)", 2 );
                append( sb, "Flag to fix the classes or interfaces Javadoc comments according the level.", 3 );
                append( sb, "", 0 );

                append( sb, "fixFieldComment (Default: true)", 2 );
                append( sb, "Flag to fix the fields Javadoc comments according the level.", 3 );
                append( sb, "", 0 );

                append( sb, "fixMethodComment (Default: true)", 2 );
                append( sb, "Flag to fix the methods Javadoc comments according the level.", 3 );
                append( sb, "", 0 );

                append( sb, "fixTags (Default: all)", 2 );
                append( sb, "Comma separated tags to fix in classes, interfaces or methods Javadoc comments. Possible values are:\n-\tall (fix all Javadoc tags)\n-\tauthor (fix only @author tag)\n-\tversion (fix only @version tag)\n-\tsince (fix only @since tag)\n-\tparam (fix only @param tag)\n-\treturn (fix only @return tag)\n-\tthrows (fix only @throws tag)\n", 3 );
                append( sb, "", 0 );

                append( sb, "force", 2 );
                append( sb, "Forcing the goal execution i.e. skip warranty messages (not recommended).", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreClirr (Default: false)", 2 );
                append( sb, "Flag to ignore or not Clirr.", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **/*.java)", 2 );
                append( sb, "Comma separated includes Java files, i.e. **/*Test.java.", 3 );
                append( sb, "", 0 );

                append( sb, "level (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located, used by the tests.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.sourceDirectory})", 2 );
                append( sb, "Output directory where Java classes will be rewrited.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-jar".equals( goal ) )
        {
            append( sb, "javadoc:test-jar", 0 );
            append( sb, "Bundles the Javadoc documentation for test Java code in an NON aggregator project into a jar using the standard Javadoc Tool.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether to attach the generated artifact to the project helper.\n", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "destDir", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files. See d.", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName", 2 );
                append( sb, "Specifies the filename that will be used for the generated jar file. Please note that -javadoc or -test-javadoc will be appended to the file name.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "jarOutputDirectory", 2 );
                append( sb, "Specifies the directory where the generated jar file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/testapidocs)", 2 );
                append( sb, "Specifies the destination directory where Javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testDoctitle (Default: ${project.name} ${project.version} Test API)", 2 );
                append( sb, "Specifies the Test title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testJavadocDirectory", 2 );
                append( sb, "Specifies the Test Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).", 3 );
                append( sb, "", 0 );

                append( sb, "testOverview (Default: ${basedir}/src/test/javadoc/overview.html)", 2 );
                append( sb, "Specifies that Javadoc should retrieve the text for the Test overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testWindowtitle (Default: ${project.name} ${project.version} Test API)", 2 );
                append( sb, "Specifies the Test title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultManifestFile (Default: false)", 2 );
                append( sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-javadoc".equals( goal ) )
        {
            append( sb, "javadoc:test-javadoc", 0 );
            append( sb, "Generates documentation for the Java Test code in an NON aggregator project using the standard Javadoc Tool.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "description", 2 );
                append( sb, "The description of the Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "destDir (Default: testapidocs)", 2 );
                append( sb, "The name of the destination directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "name", 2 );
                append( sb, "The name of the Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "reportOutputDirectory (Default: ${project.reporting.outputDirectory}/testapidocs)", 2 );
                append( sb, "Specifies the destination directory where test Javadoc saves the generated HTML files.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testDescription", 2 );
                append( sb, "The description of the Test Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "testDoctitle (Default: ${project.name} ${project.version} Test API)", 2 );
                append( sb, "Specifies the Test title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testJavadocDirectory", 2 );
                append( sb, "Specifies the Test Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "testName", 2 );
                append( sb, "The name of the Test Javadoc report to be displayed in the Maven Generated Reports page (i.e. project-reports.html).", 3 );
                append( sb, "", 0 );

                append( sb, "testOverview (Default: ${basedir}/src/test/javadoc/overview.html)", 2 );
                append( sb, "Specifies that Javadoc should retrieve the text for the Test overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testWindowtitle (Default: ${project.name} ${project.version} Test API)", 2 );
                append( sb, "Specifies the Test title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-resource-bundle".equals( goal ) )
        {
            append( sb, "javadoc:test-resource-bundle", 0 );
            append( sb, "Bundle TestJavadocJar.testJavadocDirectory, along with javadoc configuration options from AbstractJavadocMojo such as taglet, doclet, and link information into a deployable artifact. This artifact can then be consumed by the javadoc plugin mojos when used by the includeDependencySources option, to generate javadocs that are somewhat consistent with those generated in the original project itself.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "additionalJOption", 2 );
                append( sb, "Set an additional Javadoc option(s) (i.e. JVM options) on the command line. Example:\n<additionalJOption>-J-Xss128m</additionalJOption>\nSee Jflag.\nSee vmoptions.\nSee Networking Properties.", 3 );
                append( sb, "", 0 );

                append( sb, "additionalparam", 2 );
                append( sb, "Set an additional parameter(s) on the command line. This value should include quotes as necessary for parameters that include spaces. Useful for a custom doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Deprecated. since 2.5. Use the goals javadoc:aggregate and javadoc:test-aggregate instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "", 0 );

                append( sb, "author (Default: true)", 2 );
                append( sb, "Specifies whether or not the author text is included in the generated Javadocs.\nSee author.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspath", 2 );
                append( sb, "Specifies the paths where the boot classes reside. The bootclasspath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee bootclasspath.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bootclasspathArtifacts", 2 );
                append( sb, "Specifies the artifacts where the boot classes reside.\nSee bootclasspath.\nExample:\n<bootclasspathArtifacts>\n\u00a0\u00a0<bootclasspathArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>my-groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>my-artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>my-version</version>\n\u00a0\u00a0</bootclasspathArtifact>\n</bootclasspathArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "bottom (Default: Copyright &#169; {inceptionYear}-{currentYear} {organizationName}. All Rights Reserved.)", 2 );
                append( sb, "Specifies the text to be placed at the bottom of each output file.\nIf you want to use html you have to put it in a CDATA section,\neg. <![CDATA[Copyright 2005, <a href=\'http://www.mycompany.com\'>MyCompany, Inc.<a>]]>\nSee bottom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "breakiterator (Default: false)", 2 );
                append( sb, "Uses the sentence break iterator to determine the end of the first sentence.\nSee breakiterator.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "charset", 2 );
                append( sb, "Specifies the HTML character set for this document. If not specificed, the charset value will be the value of the docencoding parameter.\nSee charset.\n", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Set this to true to debug the Javadoc plugin. With this, javadoc.bat(or.sh), options, @packages or argfile files are provided in the output directory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceExcludes", 2 );
                append( sb, "List of excluded dependency-source patterns. Example: org.apache.maven.shared:*", 3 );
                append( sb, "", 0 );

                append( sb, "dependencySourceIncludes", 2 );
                append( sb, "List of included dependency-source patterns. Example: org.apache.maven:*", 3 );
                append( sb, "", 0 );

                append( sb, "detectJavaApiLink (Default: true)", 2 );
                append( sb, "Detect the Java API link for the current build, i.e. http://java.sun.com/j2se/1.4.2/docs/api for Java source 1.4.\nBy default, the goal detects the Javadoc API link depending the value of the source parameter in the org.apache.maven.plugins:maven-compiler-plugin (defined in ${project.build.plugins} or in ${project.build.pluginManagement}), or try to compute it from the javadocExecutable version.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "detectLinks (Default: false)", 2 );
                append( sb, "Detect the Javadoc links for all dependencies defined in the project. The detection is based on the default Maven conventions, i.e.: ${project.url}/apidocs.\nFor instance, if the project has a dependency to Apache Commons Lang i.e.:\n<dependency>\n\u00a0\u00a0<groupId>commons-lang</groupId>\n\u00a0\u00a0<artifactId>commons-lang</artifactId>\n</dependency>\nThe added Javadoc -link parameter will be http://commons.apache.org/lang/apidocs.", 3 );
                append( sb, "", 0 );

                append( sb, "detectOfflineLinks (Default: true)", 2 );
                append( sb, "Detect the links for all modules defined in the project.\nIf reactorProjects is defined in a non-aggregator way, it generates default offline links between modules based on the defined project\'s urls. For instance, if a parent project has two projects module1 and module2, the -linkoffline will be:\nThe added Javadoc -linkoffline parameter for module1 will be /absolute/path/to/module2/target/site/apidocs\nThe added Javadoc -linkoffline parameter for module2 will be /absolute/path/to/module1/target/site/apidocs", 3 );
                append( sb, "", 0 );

                append( sb, "docencoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the encoding of the generated HTML files. If not specificed, the docencoding value will be UTF-8.\nSee docencoding.", 3 );
                append( sb, "", 0 );

                append( sb, "docfilessubdirs (Default: false)", 2 );
                append( sb, "Enables deep copying of the **/doc-files directories and the specifc resources directory from the javadocDirectory directory (for instance, src/main/javadoc/com/mycompany/myapp/doc-files and src/main/javadoc/resources).\nSee docfilessubdirs.\nSince Java 1.4.\nSee javadocDirectory.\n", 3 );
                append( sb, "", 0 );

                append( sb, "doclet", 2 );
                append( sb, "Specifies the class file that starts the doclet used in generating the documentation.\nSee doclet.", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifact", 2 );
                append( sb, "Specifies the artifact containing the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifact>\n\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0<version>1.2b2</version>\n</docletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletArtifacts", 2 );
                append( sb, "Specifies multiple artifacts containing the path for the doclet starting class file (specified with the -doclet option).\nSee docletpath.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "docletPath", 2 );
                append( sb, "Specifies the path to the doclet starting class file (specified with the -doclet option) and any jar files it depends on. The docletPath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee docletpath.", 3 );
                append( sb, "", 0 );

                append( sb, "doctitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed near the top of the overview summary file.\nSee doctitle.\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding name of the source files. If not specificed, the encoding value will be the value of the file.encoding system property.\nSee encoding.\nNote: In 2.4, the default value was locked to ISO-8859-1 to ensure reproducing build, but this was reverted in 2.5.\n", 3 );
                append( sb, "", 0 );

                append( sb, "excludedocfilessubdir", 2 );
                append( sb, "Excludes any \'doc-files\' subdirectories with the given names. Multiple patterns can be excluded by separating them with colons (:).\nSee excludedocfilessubdir.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "excludePackageNames", 2 );
                append( sb, "Unconditionally excludes the specified packages and their subpackages from the list formed by -subpackages. Multiple packages can be separated by commas (,), colons (:) or semicolons (;).\nExample:\n<excludePackageNames>*.internal:org.acme.exclude1.*:org.acme.exclude2</excludePackageNames>\n\nSee exclude.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "extdirs", 2 );
                append( sb, "Specifies the directories where extension classes reside. Separate directories in extdirs with a colon (:) or a semi-colon (;).\nSee extdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Specifies whether the build will continue even if there are errors.", 3 );
                append( sb, "", 0 );

                append( sb, "footer", 2 );
                append( sb, "Specifies the footer text to be placed at the bottom of each output file.\nSee footer.", 3 );
                append( sb, "", 0 );

                append( sb, "groups", 2 );
                append( sb, "Separates packages on the overview page into whatever groups you specify, one group per table. The packages pattern can be any package name, or can be the start of any package name followed by an asterisk (*) meaning \'match any characters\'. Multiple patterns can be included in a group by separating them with colons (:).\nExample:\n<groups>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Core\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0includes\u00a0java.lang,\u00a0java.lang.ref,\n\u00a0\u00a0\u00a0\u00a0java.lang.reflect\u00a0and\u00a0only\u00a0java.util\n\u00a0\u00a0\u00a0\u00a0(i.e.\u00a0not\u00a0java.util.jar)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>java.lang*:java.util</packages>\n\u00a0\u00a0</group>\n\u00a0\u00a0<group>\n\u00a0\u00a0\u00a0\u00a0<title>Extension\u00a0Packages</title>\n\u00a0\u00a0\u00a0\u00a0\u00a0<!--\u00a0To\u00a0include\u00a0javax.accessibility,\n\u00a0\u00a0\u00a0\u00a0javax.crypto,\u00a0...\u00a0(among\u00a0others)\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<packages>javax.*</packages>\n\u00a0\u00a0</group>\n</groups>\nNote: using java.lang.* for packages would omit the java.lang package but using java.lang* will include it.\nSee group.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "header", 2 );
                append( sb, "Specifies the header text to be placed at the top of each output file.\nSee header.", 3 );
                append( sb, "", 0 );

                append( sb, "helpfile", 2 );
                append( sb, "Specifies the path of an alternate help file path\\filename that the HELP link in the top and bottom navigation bars link to.\nNote: could be in conflict with <nohelp/>.\nThe helpfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\nWhere path/to/your/resource/yourhelp-doc.html could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<helpfile>path/to/your/resource/yourhelp-doc.html</helpfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourhelp-doc.html is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee helpfile.", 3 );
                append( sb, "", 0 );

                append( sb, "includeDependencySources (Default: false)", 2 );
                append( sb, "Whether dependency -sources jars should be resolved and included as source paths for javadoc generation. This is useful when creating javadocs for a distribution project.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTransitiveDependencySources (Default: false)", 2 );
                append( sb, "Whether to include transitive dependencies in the list of dependency -sources jars to include in this javadoc run.", 3 );
                append( sb, "", 0 );

                append( sb, "javaApiLinks", 2 );
                append( sb, "Use this parameter only if the Sun Javadoc API urls have been changed or to use custom urls for Javadoc API url.\nSee Javadoc for the default values.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocDirectory", 2 );
                append( sb, "Specifies the Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).\nCould be used in addition of docfilessubdirs parameter.\nSee docfilessubdirs.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocExecutable", 2 );
                append( sb, "Sets the absolute path of the Javadoc Tool executable to use. Since version 2.5, a mere directory specification is sufficient to have the plugin use \'javadoc\' or \'javadoc.exe\' respectively from this directory.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocVersion", 2 );
                append( sb, "Version of the Javadoc Tool executable to use, ex. \'1.3\', \'1.5\'.", 3 );
                append( sb, "", 0 );

                append( sb, "keywords (Default: false)", 2 );
                append( sb, "Adds HTML meta keyword tags to the generated file for each class.\nSee keywords.\nSince Java 1.4.2.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "links", 2 );
                append( sb, "Creates links to existing javadoc-generated documentation of external referenced classes.\nNotes:\n1.\tonly used is isOffline is set to false.\n2.\tall given links should have a fetchable /package-list file. For instance:\n\t<links>\n\u00a0\u00a0<link>http://java.sun.com/j2se/1.4.2/docs/api</link>\n<links>\n\twill be used because http://java.sun.com/j2se/1.4.2/docs/api/package-list exists.\n3.\tif detectLinks is defined, the links between the project dependencies are automatically added.\n4.\tif detectJavaApiLink is defined, a Java API link, based on the Java verion of the project\'s sources, will be added automatically.\nSee link.", 3 );
                append( sb, "", 0 );

                append( sb, "linksource (Default: false)", 2 );
                append( sb, "Creates an HTML version of each source file (with line numbers) and adds links to them from the standard HTML documentation.\nSee linksource.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "Specifies the locale that javadoc uses when generating documentation.\nSee locale.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository where the artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "maxmemory", 2 );
                append( sb, "Specifies the maximum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xmx parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "minmemory", 2 );
                append( sb, "Specifies the minimum Java heap size to be used when launching the Javadoc tool. JVMs refer to this property as the -Xms parameter. Example: \'512\' or \'512m\'. The memory unit depends on the JVM used. The units supported could be: k, kb, m, mb, g, gb, t, tb. If no unit specified, the default unit is m.", 3 );
                append( sb, "", 0 );

                append( sb, "nocomment (Default: false)", 2 );
                append( sb, "Suppress the entire comment body, including the main description and all tags, generating only declarations.\nSee nocomment.\nSince Java 1.4.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecated (Default: false)", 2 );
                append( sb, "Prevents the generation of any deprecated API at all in the documentation.\nSee nodeprecated.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nodeprecatedlist (Default: false)", 2 );
                append( sb, "Prevents the generation of the file containing the list of deprecated APIs (deprecated-list.html) and the link in the navigation bar to that page.\nSee nodeprecatedlist.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nohelp (Default: false)", 2 );
                append( sb, "Omits the HELP link in the navigation bars at the top and bottom of each page of output.\nNote: could be in conflict with <helpfile/>.\nSee nohelp.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noindex (Default: false)", 2 );
                append( sb, "Omits the index from the generated docs.\nNote: could be in conflict with <splitindex/>.\nSee noindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nonavbar (Default: false)", 2 );
                append( sb, "Omits the navigation bar from the generated docs.\nSee nonavbar.\n", 3 );
                append( sb, "", 0 );

                append( sb, "nooverview (Default: false)", 2 );
                append( sb, "Omits the entire overview page from the generated docs.\nNote: could be in conflict with <overview/>.\nStandard Doclet undocumented option.\n", 3 );
                append( sb, "", 0 );

                append( sb, "noqualifier", 2 );
                append( sb, "Omits qualifying package name from ahead of class names in output. Example:\n<noqualifier>all</noqualifier>\nor\n<noqualifier>packagename1:packagename2</noqualifier>\nSee noqualifier.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "nosince (Default: false)", 2 );
                append( sb, "Omits from the generated docs the \'Since\' sections associated with the since tags.\nSee nosince.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notimestamp (Default: false)", 2 );
                append( sb, "Suppresses the timestamp, which is hidden in an HTML comment in the generated HTML near the top of each page.\nSee notimestamp.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "notree (Default: false)", 2 );
                append( sb, "Omits the class/interface hierarchy pages from the generated docs.\nSee notree.\n", 3 );
                append( sb, "", 0 );

                append( sb, "offlineLinks", 2 );
                append( sb, "This option is a variation of -link; they both create links to javadoc-generated documentation for external referenced classes.\nSee linkoffline.\nExample:\n<offlineLinks>\n\u00a0\u00a0<offlineLink>\n\u00a0\u00a0\u00a0\u00a0<url>http://java.sun.com/j2se/1.5.0/docs/api/</url>\n\u00a0\u00a0\u00a0\u00a0<location>../javadoc/jdk-5.0/</location>\n\u00a0\u00a0</offlineLink>\n</offlineLinks>\n\nNote: if detectOfflineLinks is defined, the offline links between the project modules are automatically added if the goal is calling in a non-aggregator way.\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "old (Default: false)", 2 );
                append( sb, "This option creates documentation with the appearance and functionality of documentation generated by Javadoc 1.1.\nSee 1.1.\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/apidocs)", 2 );
                append( sb, "Specifies the destination directory where javadoc saves the generated HTML files.\nSee d.\n", 3 );
                append( sb, "", 0 );

                append( sb, "overview (Default: ${basedir}/src/main/javadoc/overview.html)", 2 );
                append( sb, "Specifies that javadoc should retrieve the text for the overview documentation from the \'source\' file specified by path/filename and place it on the Overview page (overview-summary.html).\nNote: could be in conflict with <nooverview/>.\nSee overview.\n", 3 );
                append( sb, "", 0 );

                append( sb, "packagesheader", 2 );
                append( sb, "Specify the text for upper left frame.\nSince Java 1.4.2.", 3 );
                append( sb, "", 0 );

                append( sb, "proxyHost", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy host in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy host where the javadoc web access in -link would pass through. It defaults to the proxy host of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "proxyPort", 2 );
                append( sb, "Deprecated. since 2.4. Instead of, configure an active proxy port in settings.xml.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the proxy port where the javadoc web access in -link would pass through. It defaults to the proxy port of the active proxy set in the settings.xml, otherwise it gets the proxy configuration set in the pom.\n", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Shuts off non-error and non-warning messages, leaving only the warnings and errors appear, making them easier to view.\nNote: was a standard doclet in Java 1.4.2 (refer to bug ID 4714350).\nSee quiet.\nSince Java 5.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "remoteRepositories", 2 );
                append( sb, "The remote repositories where artifacts are located.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesArtifacts", 2 );
                append( sb, "A list of artifacts containing resources which should be copied into the Javadoc output directory (like stylesheets, icons, etc.).\nExample:\n<resourcesArtifacts>\n\u00a0\u00a0<resourcesArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>external.group.id</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>external-resources</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.0</version>\n\u00a0\u00a0</resourcesArtifact>\n</resourcesArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "serialwarn (Default: false)", 2 );
                append( sb, "Generates compile-time warnings for missing serial tags.\nSee serialwarn\n", 3 );
                append( sb, "", 0 );

                append( sb, "show (Default: protected)", 2 );
                append( sb, "Specifies the access level for classes and members to show in the Javadocs. Possible values are:\n-\tpublic (shows only public classes and members)\n-\tprotected (shows only public and protected classes and members)\n-\tpackage (shows all classes and members not marked private)\n-\tprivate (shows all classes and members)\n\n", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Specifies whether the Javadoc generation should be skipped.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "Necessary to enable javadoc to handle assertions present in J2SE v 1.4 source code.\nSee source.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDependencyCacheDir (Default: ${project.build.directory}/distro-javadoc-sources)", 2 );
                append( sb, "Directory where unpacked project sources / test-sources should be cached.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcepath", 2 );
                append( sb, "Specifies the source paths where the subpackages are located. The sourcepath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee sourcepath.", 3 );
                append( sb, "", 0 );

                append( sb, "sourcetab", 2 );
                append( sb, "Specify the number of spaces each tab takes up in the source. If no tab is used in source, the default space is used.\nNote: was linksourcetab in Java 1.4.2 (refer to bug ID 4788919).\nSince 1.4.2.\nSince Java 5.0.", 3 );
                append( sb, "", 0 );

                append( sb, "splitindex (Default: false)", 2 );
                append( sb, "Splits the index file into multiple files, alphabetically, one file per letter, plus a file for any index entries that start with non-alphabetical characters.\nNote: could be in conflict with <noindex/>.\nSee splitindex.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheet (Default: java)", 2 );
                append( sb, "Specifies whether the stylesheet to be used is the maven\'s javadoc stylesheet or java\'s default stylesheet when a stylesheetfile parameter is not specified.\nPossible values: maven or java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "stylesheetfile", 2 );
                append( sb, "Specifies the path of an alternate HTML stylesheet file.\nThe stylesheetfile could be an absolute File path.\nSince 2.6, it could be also be a path from a resource in the current project source directories (i.e. src/main/java, src/main/resources or src/main/javadoc) or from a resource in the Javadoc plugin dependencies, for instance:\n<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\nWhere path/to/your/resource/yourstylesheet.css could be in src/main/javadoc.\n<build>\n\u00a0\u00a0<plugins>\n\u00a0\u00a0\u00a0\u00a0<plugin>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>org.apache.maven.plugins</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>maven-javadoc-plugin</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<stylesheetfile>path/to/your/resource/yourstylesheet.css</stylesheetfile>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</configuration>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependencies>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>groupId</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifactId</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version</version>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependency>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</dependencies>\n\u00a0\u00a0\u00a0\u00a0</plugin>\n\u00a0\u00a0\u00a0\u00a0...\n\u00a0\u00a0<plugins>\n</build>\nWhere path/to/your/resource/yourstylesheet.css is defined in the groupId:artifactId:version javadoc plugin dependency.\nSee stylesheetfile.", 3 );
                append( sb, "", 0 );

                append( sb, "subpackages", 2 );
                append( sb, "Specifies the package directory where javadoc will be executed. Multiple packages can be separated by colons (:).\nSee subpackages.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglet", 2 );
                append( sb, "Specifies the class file that starts the taglet used in generating the documentation for that tag.\nSee taglet.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifact", 2 );
                append( sb, "Specifies the Taglet artifact containing the taglet class files (.class).\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>package.to.AnotherTagletClass</tagletClass>\n\u00a0\u00a0</taglet>\n\u00a0\u00a0...\n</taglets>\n<tagletArtifact>\n\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0<version>version-Taglet</version>\n</tagletArtifact>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletArtifacts", 2 );
                append( sb, "Specifies several Taglet artifacts containing the taglet class files (.class). These taglets class names will be auto-detect and so no need to specify them.\nSee taglet.\nSee tagletpath.\nExample:\n<tagletArtifacts>\n\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0...\n</tagletArtifacts>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tagletpath", 2 );
                append( sb, "Specifies the search paths for finding taglet class files (.class). The tagletpath can contain multiple paths by separating them with a colon (:) or a semi-colon (;).\nSee tagletpath.\nSince Java 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "taglets", 2 );
                append( sb, "Enables the Javadoc tool to interpret multiple taglets.\nSee taglet.\nSee tagletpath.\nExample:\n<taglets>\n\u00a0\u00a0<taglet>\n\u00a0\u00a0\u00a0\u00a0<tagletClass>com.sun.tools.doclets.ToDoTaglet</tagletClass>\n\u00a0\u00a0\u00a0\u00a0<!--<tagletpath>/home/taglets</tagletpath>-->\n\u00a0\u00a0\u00a0\u00a0<tagletArtifact>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<groupId>group-Taglet</groupId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<artifactId>artifact-Taglet</artifactId>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<version>version-Taglet</version>\n\u00a0\u00a0\u00a0\u00a0</tagletArtifact>\n\u00a0\u00a0</taglet>\n</taglets>\n\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "tags", 2 );
                append( sb, "Enables the Javadoc tool to interpret a simple, one-argument custom block tag tagname in doc comments.\nSee tag.\nSince Java 1.4.\nExample:\n<tags>\n\u00a0\u00a0<tag>\n\u00a0\u00a0\u00a0\u00a0<name>todo</name>\n\u00a0\u00a0\u00a0\u00a0<placement>a</placement>\n\u00a0\u00a0\u00a0\u00a0<head>To\u00a0Do:</head>\n\u00a0\u00a0</tag>\n</tags>\nNote: the placement should be a combinaison of Xaoptcmf letters:\n-\tX (disable tag)\n-\ta (all)\n-\to (overview)\n-\tp (packages)\n-\tt (types, that is classes and interfaces)\n-\tc (constructors)\n-\tm (methods)\n-\tf (fields)\nSee Javadoc.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testJavadocDirectory (Default: ${basedir}/src/test/javadoc)", 2 );
                append( sb, "Specifies the Test Javadoc resources directory to be included in the Javadoc (i.e. package.html, images...).", 3 );
                append( sb, "", 0 );

                append( sb, "top", 2 );
                append( sb, "Specifies the top text to be placed at the top of each output file.\nSee 6227616.\nSince Java 6.0", 3 );
                append( sb, "", 0 );

                append( sb, "use (Default: true)", 2 );
                append( sb, "Includes one \'Use\' page for each documented class and package.\nSee use.\n", 3 );
                append( sb, "", 0 );

                append( sb, "useStandardDocletOptions (Default: true)", 2 );
                append( sb, "Specifies to use the options provided by the Standard Doclet for a custom doclet.\nExample:\n<docletArtifacts>\n\u00a0\u00a0<docletArtifact>\n\u00a0\u00a0\u00a0\u00a0<groupId>com.sun.tools.doclets</groupId>\n\u00a0\u00a0\u00a0\u00a0<artifactId>doccheck</artifactId>\n\u00a0\u00a0\u00a0\u00a0<version>1.2b2</version>\n\u00a0\u00a0</docletArtifact>\n</docletArtifacts>\n<useStandardDocletOptions>true</useStandardDocletOptions>\n", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Provides more detailed messages while javadoc is running.\nSee verbose.\n", 3 );
                append( sb, "", 0 );

                append( sb, "version (Default: true)", 2 );
                append( sb, "Includes the version text in the generated docs.\nSee version.\n", 3 );
                append( sb, "", 0 );

                append( sb, "windowtitle (Default: ${project.name} ${project.version} API)", 2 );
                append( sb, "Specifies the title to be placed in the HTML title tag.\nSee windowtitle.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
