/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.javadoc.AbstractJavadocMojo;
import org.apache.maven.plugins.javadoc.JavadocArchiveConfiguration;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class JavadocJarMojo
extends AbstractJavadocMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{DEBUG_JAVADOC_SCRIPT_NAME, "options", "packages", "argfile", "files"};
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter(property="project.build.directory")
    private String jarOutputDirectory;
    @Parameter(property="project.build.finalName")
    private String finalName;
    @Parameter(property="attach", defaultValue="true")
    private boolean attach;
    @Parameter
    private MavenArchiveConfiguration archive = new JavadocArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", required=true, readonly=true)
    private File defaultManifestFile;
    @Parameter(defaultValue="false")
    private boolean useDefaultManifestFile;
    @Parameter(property="maven.javadoc.classifier", defaultValue="javadoc", required=true)
    private String classifier;

    @Override
    protected void doExecute() throws MojoExecutionException {
        block12: {
            ArtifactHandler artifactHandler;
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping javadoc generation");
                return;
            }
            if (!(this.isAggregator() && "pom".equalsIgnoreCase(this.project.getPackaging()) || "java".equals((artifactHandler = this.project.getArtifact().getArtifactHandler()).getLanguage()))) {
                this.getLog().info((CharSequence)"Not executing Javadoc as the project is not a Java classpath-capable package");
                return;
            }
            try {
                this.executeReport(SiteTool.DEFAULT_LOCALE);
            }
            catch (MavenReportException e) {
                this.failOnError("MavenReportException: Error while generating Javadoc", (Exception)((Object)e));
            }
            catch (RuntimeException e) {
                this.failOnError("RuntimeException: Error while generating Javadoc", e);
            }
            File javadocOutputDirectory = new File(this.getPluginReportOutputDirectory());
            if (javadocOutputDirectory.exists()) {
                try {
                    File outputFile = this.generateArchive(javadocOutputDirectory, this.finalName + "-" + this.getClassifier() + ".jar");
                    if (!this.attach) {
                        this.getLog().info((CharSequence)"NOT adding javadoc to attached artifacts list.");
                        break block12;
                    }
                    this.projectHelper.attachArtifact(this.project, "javadoc", this.getClassifier(), outputFile);
                }
                catch (ArchiverException e) {
                    this.failOnError("ArchiverException: Error while creating archive", (Exception)((Object)e));
                }
                catch (IOException e) {
                    this.failOnError("IOException: Error while creating archive", e);
                }
                catch (RuntimeException e) {
                    this.failOnError("RuntimeException: Error while creating archive", e);
                }
            } else {
                this.getLog().info((CharSequence)"No Javadoc in project. Archive not created.");
            }
        }
    }

    protected String getClassifier() {
        return this.classifier;
    }

    private File generateArchive(File javadocFiles, String jarFileName) throws ArchiverException, IOException {
        File outputFile;
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setCreatedBy("Maven Javadoc Plugin", "org.apache.maven.plugins", "maven-javadoc-plugin");
        archiver.configureReproducibleBuild(this.outputTimestamp);
        if (javadocFiles.exists()) {
            archiver.getArchiver().addDirectory(javadocFiles, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
        }
        List resources = this.project.getBuild().getResources();
        for (Resource r : resources) {
            if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
            archiver.getArchiver().addDirectory(new File(r.getDirectory()));
        }
        if (this.useDefaultManifestFile && this.defaultManifestFile.exists() && this.archive.getManifestFile() == null) {
            this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + this.defaultManifestFile.getPath()));
            this.archive.setManifestFile(this.defaultManifestFile);
        }
        if ((outputFile = new File(this.jarOutputDirectory, jarFileName)).exists()) {
            outputFile.delete();
        }
        archiver.setOutputFile(outputFile);
        try {
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (DependencyResolutionRequiredException | ManifestException e) {
            throw new ArchiverException("Error creating Javadoc archive: " + e.getMessage(), e);
        }
        return outputFile;
    }
}

