/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jdeprscan;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJDeprScanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String jExecutable;
        try {
            jExecutable = this.getJDeprScanExecutable();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to find jdeprscan command: " + e.getMessage(), (Throwable)e);
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable(jExecutable);
        this.addJDeprScanOptions(cmd);
        this.executeJDeprScanCommandLine(cmd, this.getConsumer());
        this.verify();
    }

    protected CommandLineUtils.StringStreamConsumer getConsumer() {
        return null;
    }

    protected void verify() throws MojoExecutionException {
    }

    protected abstract boolean isForRemoval();

    protected void addJDeprScanOptions(Commandline cmd) throws MojoFailureException {
        if (this.isForRemoval()) {
            cmd.createArg().setValue("--for-removal");
        }
    }

    private String getJDeprScanExecutable() throws IOException {
        Toolchain tc = this.getToolchain();
        String jdeprscanExecutable = null;
        if (tc != null) {
            jdeprscanExecutable = tc.findTool("jdeprscan");
        }
        String jdepsCommand = "jdeprscan" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (StringUtils.isNotEmpty((String)jdeprscanExecutable)) {
            File jdeprscanExe = new File(jdeprscanExecutable);
            if (jdeprscanExe.isDirectory()) {
                jdeprscanExe = new File(jdeprscanExe, jdepsCommand);
            }
            if (SystemUtils.IS_OS_WINDOWS && jdeprscanExe.getName().indexOf(46) < 0) {
                jdeprscanExe = new File(jdeprscanExe.getPath() + ".exe");
            }
            if (!jdeprscanExe.isFile()) {
                throw new IOException("The jdeprscan executable '" + jdeprscanExe + "' doesn't exist or is not a file.");
            }
            return jdeprscanExe.getAbsolutePath();
        }
        File jdeprscanExe = new File(SystemUtils.getJavaHome() + File.separator + ".." + File.separator + "sh", jdepsCommand);
        if (!jdeprscanExe.exists() || !jdeprscanExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            String javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).getCanonicalFile().exists() || new File(javaHome).getCanonicalFile().isFile()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            jdeprscanExe = new File(javaHome + File.separator + "bin", jdepsCommand);
        }
        if (!jdeprscanExe.getCanonicalFile().exists() || !jdeprscanExe.getCanonicalFile().isFile()) {
            throw new IOException("The jdeps executable '" + jdeprscanExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return jdeprscanExe.getAbsolutePath();
    }

    private void executeJDeprScanCommandLine(Commandline cmd, CommandLineUtils.StringStreamConsumer consumer) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executing: " + CommandLineUtils.toString((String[])cmd.getCommandline()).replaceAll("'", "")));
        }
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = consumer != null ? consumer : new CommandLineUtils.StringStreamConsumer();
        try {
            String output;
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
            String string = output = StringUtils.isEmpty((String)out.getOutput()) ? null : '\n' + out.getOutput().trim();
            if (StringUtils.isNotEmpty(output)) {
                this.getLog().info(output);
            }
            if (exitCode != 0) {
                StringBuilder msg = new StringBuilder("\nExit code: ");
                msg.append(exitCode);
                if (StringUtils.isNotEmpty((String)err.getOutput())) {
                    msg.append(" - ").append(err.getOutput());
                }
                msg.append('\n');
                msg.append("Command line was: ").append(cmd).append('\n').append('\n');
                throw new MojoExecutionException(msg.toString());
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute jdeprscan command: " + e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isNotEmpty((String)err.getOutput()) && this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)"JDeprScan Warnings");
            StringTokenizer token = new StringTokenizer(err.getOutput(), "\n");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                this.getLog().warn((CharSequence)current);
            }
        }
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null && (tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session)) == null) {
            try {
                Method getToolchainsMethod = this.toolchainManager.getClass().getMethod("getToolchains", MavenSession.class, String.class, Map.class);
                List tcs = (List)getToolchainsMethod.invoke((Object)this.toolchainManager, this.session, "jdk", Collections.singletonMap("version", "[9,)"));
                if (tcs != null && tcs.size() > 0) {
                    tc = (Toolchain)tcs.get(tcs.size() - 1);
                }
            }
            catch (ReflectiveOperationException e) {
            }
            catch (SecurityException e) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return tc;
    }
}

