/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jdeprscan;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.jdeprscan.AbstractJDeprScanMojo;
import org.apache.maven.plugins.jdeprscan.consumers.JDeprScanConsumer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class BaseJDeprScanMojo
extends AbstractJDeprScanMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="true")
    private boolean failOnWarning;
    @Parameter(property="maven.jdeprscan.forremoval")
    private boolean forRemoval;
    @Parameter
    private String release;
    private JDeprScanConsumer consumer = new JDeprScanConsumer();

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!Files.exists(this.getClassesDirectory(), new LinkOption[0])) {
            this.getLog().debug((CharSequence)"No classes to scan");
            return;
        }
        super.execute();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    @Override
    protected boolean isForRemoval() {
        return this.forRemoval;
    }

    @Override
    protected CommandLineUtils.StringStreamConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    protected final void addJDeprScanOptions(Commandline cmd) throws MojoFailureException {
        super.addJDeprScanOptions(cmd);
        if (this.release != null) {
            cmd.createArg().setValue("--release");
            cmd.createArg().setValue(this.release);
        }
        try {
            Collection<Path> cp = this.getClassPath();
            if (!cp.isEmpty()) {
                cmd.createArg().setValue("--class-path");
                cmd.createArg().setValue(StringUtils.join(cp.iterator(), (String)File.pathSeparator));
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        cmd.createArg().setFile(this.getClassesDirectory().toFile());
    }

    @Override
    protected void verify() throws MojoExecutionException {
        if (!this.consumer.getDeprecatedClasses().isEmpty() || !this.consumer.getDeprecatedMethods().isEmpty()) {
            if (!this.consumer.getDeprecatedClasses().isEmpty()) {
                this.getLog().warn((CharSequence)"Found usage of deprecated classes:");
                for (Map.Entry<String, Set<String>> classes : this.consumer.getDeprecatedClasses().entrySet()) {
                    this.getLog().warn((CharSequence)("class " + classes.getKey() + " uses deprecated class(es)"));
                    for (String deprClass : classes.getValue()) {
                        this.getLog().warn((CharSequence)("  * " + deprClass));
                    }
                }
            }
            if (!this.consumer.getDeprecatedMethods().isEmpty()) {
                this.getLog().warn((CharSequence)"Found usage of deprecated methods:");
                for (Map.Entry<String, Set<String>> classes : this.consumer.getDeprecatedMethods().entrySet()) {
                    this.getLog().warn((CharSequence)("class " + classes.getKey() + " uses deprecated method(s)"));
                    for (String deprMethod : classes.getValue()) {
                        this.getLog().warn((CharSequence)("  * " + deprMethod));
                    }
                }
            }
            if (this.failOnWarning) {
                throw new MojoExecutionException("JDeprScan detected usage of deprecated classes/methods");
            }
        }
    }

    protected abstract Path getClassesDirectory();

    protected abstract Collection<Path> getClassPath() throws DependencyResolutionRequiredException;
}

