/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jdeprscan;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jdeprscan.BaseJDeprScanMojo;

@Mojo(name="test-jdeprscan", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true)
public class TestJDeprScanMojo
extends BaseJDeprScanMojo {
    @Override
    protected Path getClassesDirectory() {
        return Paths.get(this.getProject().getBuild().getTestOutputDirectory(), new String[0]);
    }

    @Override
    protected Collection<Path> getClassPath() throws DependencyResolutionRequiredException {
        LinkedHashSet<Path> classPath = new LinkedHashSet<Path>(this.getProject().getTestClasspathElements().size());
        for (String elm : this.getProject().getTestClasspathElements()) {
            classPath.add(Paths.get(elm, new String[0]));
        }
        return classPath;
    }
}

