/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jdeprscan.consumers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JDeprScanConsumer
extends CommandLineUtils.StringStreamConsumer
implements StreamConsumer {
    private Map<String, Set<String>> deprecatedClasses = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> deprecatedMethods = new HashMap<String, Set<String>>();
    public static final Pattern DEPRECATED_CLASS = Pattern.compile("^class (\\S+) uses deprecated class (\\S+)");
    public static final Pattern DEPRECATED_METHOD = Pattern.compile("^class (\\S+) uses deprecated method (\\S+)");

    public Map<String, Set<String>> getDeprecatedClasses() {
        return this.deprecatedClasses;
    }

    public Map<String, Set<String>> getDeprecatedMethods() {
        return this.deprecatedMethods;
    }

    public void consumeLine(String line) {
        super.consumeLine(line);
        Matcher matcher = DEPRECATED_CLASS.matcher(line);
        if (matcher.find()) {
            Set<String> dc = this.deprecatedClasses.get(matcher.group(1));
            if (dc == null) {
                dc = new HashSet<String>();
                this.deprecatedClasses.put(matcher.group(1), dc);
            }
            dc.add(matcher.group(2));
            return;
        }
        matcher = DEPRECATED_METHOD.matcher(line);
        if (matcher.find()) {
            Set<String> dm = this.deprecatedMethods.get(matcher.group(1));
            if (dm == null) {
                dm = new HashSet<String>();
                this.deprecatedMethods.put(matcher.group(1), dm);
            }
            dm.add(matcher.group(2));
            return;
        }
    }
}

