/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.linkcheck;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-linkcheck-plugin:1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Linkcheck Plugin", 0);
        this.append(sb, "This plugin allows you to generate a linkcheck report of your project's documentation.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "linkcheck:help", 0);
            this.append(sb, "Display help information on maven-linkcheck-plugin.\nCall\n\u00a0\u00a0mvn\u00a0linkcheck:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "linkcheck".equals(this.goal)) {
            this.append(sb, "linkcheck:linkcheck", 0);
            this.append(sb, "Generates a Linkcheck report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "baseURL (Default: ${project.url})", 2);
                this.append(sb, "The base URL to use for absolute links (eg /index.html) in the site.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The file encoding to use when Linkcheck reads the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedHttpStatusErrors", 2);
                this.append(sb, "The list of HTTP errors to ignored, like 404.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedHttpStatusWarnings", 2);
                this.append(sb, "The list of HTTP warnings to ignored, like 301.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedLinks", 2);
                this.append(sb, "The list of links to exclude.\nNote: Patterns like **/dummy/* are allowed for excludedLink.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedPages", 2);
                this.append(sb, "The list of site pages to exclude. By default, this report, i.e. linkcheck.html, will be excluded.\nNote: No pattern is allowed for excludedPage, only specific file names.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceSite (Default: true)", 2);
                this.append(sb, "true to force the site generation, false otherwise. Using this parameter ensures that all documents have been correctly generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpClientParameters", 2);
                this.append(sb, "The extra HttpClient parameters to be used when fetching links. For instance:\n<httpClientParameters>\n\u00a0<property>\n\u00a0\u00a0<name>http.protocol.max-redirects</name>\n\u00a0\u00a0<value>10</value>\n\u00a0</property>\n</httpClientParameters>\nSee HttpClient preference page", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpFollowRedirect (Default: true)", 2);
                this.append(sb, "If online, the HTTP method should automatically follow HTTP redirects, false otherwise.", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpMethod (Default: head)", 2);
                this.append(sb, "The HTTP method to use. Currently supported are 'GET' and 'HEAD'.\nHTTP GET\n\tThe HTTP GET method is defined in section 9.3 of RFC2616: The GET method means retrieve whatever information (in the form of an entity) is identified by the Request-URI.\nHTTP HEAD\n\tThe HTTP HEAD method is defined in section 9.4 of RFC2616: The HEAD method is identical to GET except that the server MUST NOT return a message-body in the response.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkcheckCache (Default: ${project.build.directory}/linkcheck/linkcheck.cache)", 2);
                this.append(sb, "The location of the Linkcheck cache file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkcheckOutput (Default: ${project.build.directory}/linkcheck/linkcheck.xml)", 2);
                this.append(sb, "The location of the Linkcheck report file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "offline (Default: ${settings.offline})", 2);
                this.append(sb, "Whether we are offline or not.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Report output directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "true to skip the report execution, false otherwise. The purpose is to prevent infinite call when forceSite is enable.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 2000)", 2);
                this.append(sb, "Set the timeout to be used when fetching links. A value of zero means the timeout is not used.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

