/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.linkcheck;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.linkcheck.HttpBean;
import org.apache.maven.doxia.linkcheck.LinkCheck;
import org.apache.maven.doxia.linkcheck.LinkCheckException;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFile;
import org.apache.maven.doxia.linkcheck.model.LinkcheckFileResult;
import org.apache.maven.doxia.linkcheck.model.LinkcheckModel;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class LinkcheckReport
extends AbstractMavenReport {
    private I18N i18n;
    private Renderer siteRenderer;
    private LinkCheck linkCheck;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private File outputDirectory;
    private Settings settings;
    private boolean offline;
    private boolean httpFollowRedirect;
    protected File linkcheckCache;
    protected File linkcheckOutput;
    private String httpMethod;
    private int[] excludedHttpStatusErrors;
    private int[] excludedHttpStatusWarnings;
    private String[] excludedPages;
    private String[] excludedLinks;
    private String encoding;
    private Properties httpClientParameters;
    private int timeout;
    private boolean skip;
    private boolean forceSite;
    private String baseURL;
    private LinkcheckModel result;

    public String getDescription(Locale locale) {
        return this.i18n.getString("linkcheck-report", locale, "report.linkcheck.description");
    }

    public String getName(Locale locale) {
        return this.i18n.getString("linkcheck-report", locale, "report.linkcheck.name");
    }

    public String getOutputName() {
        return "linkcheck";
    }

    public boolean canGenerateReport() {
        return !this.skip;
    }

    public void execute() throws MojoExecutionException {
        File basedir;
        if (!this.canGenerateReport()) {
            return;
        }
        if (StringUtils.isEmpty((String)this.encoding)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            this.encoding = ReaderFactory.FILE_ENCODING;
        }
        File tmpReportingOutputDirectory = new File(this.linkcheckOutput.getParentFile(), "tmpsite");
        tmpReportingOutputDirectory.mkdirs();
        if (this.forceSite) {
            basedir = tmpReportingOutputDirectory;
            List documents = null;
            try {
                documents = FileUtils.getFiles((File)basedir, (String)"**/*.html", null);
            }
            catch (IOException e) {
                String msg = "IOException: " + e.getMessage();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)msg, (Throwable)e);
                }
                this.getLog().error((CharSequence)msg);
            }
            if (documents == null || documents != null && documents.size() == 0) {
                this.getLog().info((CharSequence)"Trying to invoke the maven-site-plugin to be sure that all files are generated...");
                try {
                    this.invokeSite(tmpReportingOutputDirectory);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
                }
            }
        } else {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)"WARRANTY: The number of documents analyzed by Linkcheck could differ with the real number of documents!");
            }
            basedir = this.outputDirectory;
            basedir.mkdirs();
        }
        try {
            this.result = this.executeLinkCheck(basedir);
        }
        catch (LinkCheckException e) {
            throw new MojoExecutionException("LinkCheckException: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.result == null) {
            this.getLog().debug((CharSequence)"Calling execute()");
            try {
                this.execute();
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException("MojoExecutionException: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        if (this.result != null) {
            this.generateReport(locale, this.result);
            this.result = null;
        }
    }

    private LinkcheckModel executeLinkCheck(File basedir) throws LinkCheckException {
        Proxy proxy;
        this.linkCheck.setOnline(!this.offline);
        this.linkCheck.setBasedir(basedir);
        this.linkCheck.setBaseURL(this.baseURL);
        this.linkCheck.setReportOutput(this.linkcheckOutput);
        this.linkCheck.setLinkCheckCache(this.linkcheckCache);
        this.linkCheck.setExcludedLinks(this.excludedLinks);
        this.linkCheck.setExcludedPages(this.getExcludedPages());
        this.linkCheck.setExcludedHttpStatusErrors(this.excludedHttpStatusErrors);
        this.linkCheck.setExcludedHttpStatusWarnings(this.excludedHttpStatusWarnings);
        this.linkCheck.setEncoding(StringUtils.isNotEmpty((String)this.encoding) ? this.encoding : "UTF-8");
        HttpBean bean = new HttpBean();
        bean.setMethod(this.httpMethod);
        bean.setFollowRedirects(this.httpFollowRedirect);
        bean.setTimeout(this.timeout);
        if (this.httpClientParameters != null) {
            bean.setHttpClientParameters(this.httpClientParameters);
        }
        if ((proxy = this.settings.getActiveProxy()) != null) {
            bean.setProxyHost(proxy.getHost());
            bean.setProxyPort(proxy.getPort());
            bean.setProxyUser(proxy.getUsername());
            bean.setProxyPassword(proxy.getPassword());
        }
        this.linkCheck.setHttp(bean);
        return this.linkCheck.execute();
    }

    private String[] getExcludedPages() {
        ArrayList<String> pagesToExclude = this.excludedPages != null ? new ArrayList<String>(Arrays.asList(this.excludedPages)) : new ArrayList();
        pagesToExclude.add(this.getOutputName() + ".html");
        return pagesToExclude.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSite(File tmpReportingOutputDirectory) throws IOException {
        MavenProject clone;
        String mavenHome = this.getMavenHome();
        if (StringUtils.isEmpty((String)mavenHome)) {
            if (this.getLog().isErrorEnabled()) {
                String msg = "Could NOT invoke Maven because no Maven Home is defined. You need to have set the M2_HOME system env variable or a 'maven.home' Java system properties.";
                this.getLog().error((CharSequence)msg);
            }
            return;
        }
        List<String> goals = Collections.singletonList("site");
        Properties properties = new Properties();
        properties.put("linkcheck.skip", "true");
        File invokerLog = FileUtils.createTempFile((String)"invoker-site-plugin", (String)".txt", (File)new File(this.project.getBuild().getDirectory()));
        try {
            clone = (MavenProject)this.project.clone();
        }
        catch (CloneNotSupportedException e) {
            IOException ioe = new IOException("CloneNotSupportedException: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        clone.getOriginalModel().getReporting().setOutputDirectory(tmpReportingOutputDirectory.getAbsolutePath());
        File tmpProjectFile = FileUtils.createTempFile((String)"pom", (String)".xml", (File)this.project.getBasedir());
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)tmpProjectFile);
            clone.writeOriginalModel((Writer)writer);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        try {
            this.invoke(tmpProjectFile, invokerLog, mavenHome, goals, properties);
        }
        finally {
            if (!this.getLog().isDebugEnabled()) {
                tmpProjectFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(File projectFile, File invokerLog, String mavenHome, List goals, Properties properties) {
        InvocationResult result;
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        invoker.setLocalRepositoryDirectory(new File(this.localRepository.getBasedir()));
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setBaseDirectory(projectFile.getParentFile());
        request.setPomFile(projectFile);
        request.setDebug(this.getLog().isDebugEnabled());
        request.setGoals(goals);
        request.setProperties(properties);
        File javaHome = this.getJavaHome();
        if (javaHome != null) {
            request.setJavaHome(javaHome);
        }
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Invoking Maven for the goals: " + goals + " with properties=" + properties));
            }
            result = this.invoke((Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, null);
        }
        catch (MavenInvocationException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("MavenInvocationException: " + e.getMessage()), (Throwable)e);
            }
            this.getLog().error((CharSequence)"Error when invoking Maven, consult the invoker log.");
            return;
        }
        String invokerLogContent = null;
        Reader reader = null;
        try {
            reader = ReaderFactory.newReader((File)invokerLog, (String)"UTF-8");
            invokerLogContent = IOUtil.toString((Reader)reader);
        }
        catch (IOException e) {
            String msg = "IOException: " + e.getMessage();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)msg, (Throwable)e);
            } else {
                this.getLog().error((CharSequence)msg);
            }
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        if (invokerLogContent != null && invokerLogContent.indexOf("Error occurred during initialization of VM") != -1) {
            this.getLog().info((CharSequence)"Error occurred during initialization of VM, try to use an empty MAVEN_OPTS.");
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Reinvoking Maven for the goals: " + goals + " with an empty MAVEN_OPTS"));
            }
            try {
                result = this.invoke((Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, "");
            }
            catch (MavenInvocationException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)("MavenInvocationException: " + e.getMessage()), (Throwable)e);
                }
                this.getLog().error((CharSequence)"Error when reinvoking Maven, consult the invoker log.");
                return;
            }
        }
        if (result.getExitCode() != 0 && this.getLog().isErrorEnabled()) {
            this.getLog().error((CharSequence)("Error when invoking Maven, consult the invoker log file: " + invokerLog.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvocationResult invoke(Invoker invoker, InvocationRequest request, File invokerLog, List goals, Properties properties, String mavenOpts) throws MavenInvocationException {
        PrintStream ps;
        FileOutputStream os = null;
        if (invokerLog != null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Using " + invokerLog.getAbsolutePath() + " to log the invoker"));
            }
            try {
                if (!invokerLog.exists()) {
                    invokerLog.getParentFile().mkdirs();
                }
                os = new FileOutputStream(invokerLog);
                ps = new PrintStream((OutputStream)os, true, "UTF-8");
            }
            catch (FileNotFoundException e) {
                if (this.getLog().isErrorEnabled()) {
                    this.getLog().error((CharSequence)("FileNotFoundException: " + e.getMessage() + ". Using System.out to log the invoker."));
                }
                ps = System.out;
            }
            catch (UnsupportedEncodingException e) {
                if (this.getLog().isErrorEnabled()) {
                    this.getLog().error((CharSequence)("UnsupportedEncodingException: " + e.getMessage() + ". Using System.out to log the invoker."));
                }
                ps = System.out;
            }
        } else {
            this.getLog().debug((CharSequence)"Using System.out to log the invoker.");
            ps = System.out;
        }
        if (mavenOpts != null) {
            request.setMavenOpts(mavenOpts);
        }
        PrintStreamHandler outputHandler = new PrintStreamHandler(ps, false);
        request.setOutputHandler((InvocationOutputHandler)outputHandler);
        outputHandler.consumeLine("Invoking Maven for the goals: " + goals + " with properties=" + properties);
        outputHandler.consumeLine("");
        outputHandler.consumeLine("M2_HOME=" + this.getMavenHome());
        outputHandler.consumeLine("MAVEN_OPTS=" + this.getMavenOpts());
        outputHandler.consumeLine("JAVA_HOME=" + this.getJavaHome());
        outputHandler.consumeLine("JAVA_OPTS=" + this.getJavaOpts());
        outputHandler.consumeLine("");
        try {
            InvocationResult invocationResult = invoker.execute(request);
            return invocationResult;
        }
        finally {
            IOUtil.close((OutputStream)os);
            ps = null;
        }
    }

    private String getMavenHome() {
        File m2Home;
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome == null) {
            try {
                mavenHome = CommandLineUtils.getSystemEnvVars().getProperty("M2_HOME");
            }
            catch (IOException e) {
                String msg = "IOException: " + e.getMessage();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)msg, (Throwable)e);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        if (!(m2Home = new File(mavenHome)).exists() && this.getLog().isErrorEnabled()) {
            this.getLog().error((CharSequence)"Cannot find Maven application directory. Either specify 'maven.home' system property, or M2_HOME environment variable.");
        }
        return mavenHome;
    }

    private String getMavenOpts() {
        String mavenOpts = null;
        try {
            mavenOpts = CommandLineUtils.getSystemEnvVars().getProperty("MAVEN_OPTS");
        }
        catch (IOException e) {
            String msg = "IOException: " + e.getMessage();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)msg, (Throwable)e);
            }
            this.getLog().error((CharSequence)msg);
        }
        return mavenOpts;
    }

    private File getJavaHome() {
        File javaHome = SystemUtils.IS_OS_MAC_OSX ? SystemUtils.getJavaHome() : new File(SystemUtils.getJavaHome(), "..");
        if (javaHome == null || !javaHome.exists()) {
            try {
                javaHome = new File(CommandLineUtils.getSystemEnvVars().getProperty("JAVA_HOME"));
            }
            catch (IOException e) {
                String msg = "IOException: " + e.getMessage();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)msg, (Throwable)e);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        if ((javaHome == null || !javaHome.exists()) && this.getLog().isErrorEnabled()) {
            this.getLog().error((CharSequence)"Cannot find Java application directory. Either specify 'java.home' system property, or JAVA_HOME environment variable.");
        }
        return javaHome;
    }

    private String getJavaOpts() {
        String javaOpts = null;
        try {
            javaOpts = CommandLineUtils.getSystemEnvVars().getProperty("JAVA_OPTS");
        }
        catch (IOException e) {
            String msg = "IOException: " + e.getMessage();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)msg, (Throwable)e);
            }
            this.getLog().error((CharSequence)msg);
        }
        return javaOpts;
    }

    private void generateReport(Locale locale, LinkcheckModel linkcheckModel) {
        this.getSink().head();
        this.getSink().title();
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.title"));
        this.getSink().title_();
        this.getSink().head_();
        this.getSink().body();
        if (linkcheckModel == null) {
            this.getSink().section1();
            this.getSink().sectionTitle1();
            this.getSink().text(this.getName(locale));
            this.getSink().sectionTitle1_();
            this.getSink().paragraph();
            this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.empty"));
            this.getSink().paragraph_();
            this.getSink().section1_();
            this.getSink().body_();
            this.getSink().flush();
            this.getSink().close();
            return;
        }
        this.getSink().section1();
        this.getSink().sectionTitle1();
        this.getSink().text(this.getName(locale));
        this.getSink().sectionTitle1_();
        this.getSink().paragraph();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.overview"));
        this.getSink().paragraph_();
        this.getSink().section1_();
        this.generateSummarySection(locale, linkcheckModel);
        if (linkcheckModel.getFiles().size() > 0) {
            this.generateDetailsSection(locale, linkcheckModel);
        }
        this.getSink().body_();
        this.getSink().flush();
        this.getSink().close();
        this.closeReport();
    }

    private void generateSummarySection(Locale locale, LinkcheckModel linkcheckModel) {
        List linkcheckFiles = linkcheckModel.getFiles();
        int totalFiles = linkcheckFiles.size();
        int totalLinks = 0;
        int totalValidLinks = 0;
        int totalErrorLinks = 0;
        int totalWarningLinks = 0;
        Iterator it = linkcheckFiles.iterator();
        while (it.hasNext()) {
            LinkcheckFile linkcheckFile = (LinkcheckFile)it.next();
            totalLinks += linkcheckFile.getNumberOfLinks();
            totalValidLinks += linkcheckFile.getNumberOfLinks(3);
            totalErrorLinks += linkcheckFile.getNumberOfLinks(1);
            totalWarningLinks += linkcheckFile.getNumberOfLinks(2);
        }
        this.getSink().section1();
        this.getSink().sectionTitle1();
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary"));
        this.getSink().sectionTitle1_();
        this.getSink().paragraph();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.overview1"));
        this.getSink().paragraph_();
        this.getSink().table();
        this.getSink().tableRow();
        this.getSink().tableHeaderCell();
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.parameter"));
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.value"));
        this.getSink().tableHeaderCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.httpFollowRedirect"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().text(String.valueOf(this.httpFollowRedirect));
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.httpMethod"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (StringUtils.isEmpty((String)this.httpMethod)) {
            this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(this.httpMethod);
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.offline"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().text(String.valueOf(this.offline));
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.excludedPages"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (this.getExcludedPages() == null || this.getExcludedPages().length == 0) {
            this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(StringUtils.join((Object[])this.getExcludedPages(), (String)","));
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.excludedLinks"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (this.excludedLinks == null || this.excludedLinks.length == 0) {
            this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(StringUtils.join((Object[])this.excludedLinks, (String)","));
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.excludedHttpStatusErrors"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (this.excludedHttpStatusErrors == null || this.excludedHttpStatusErrors.length == 0) {
            this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(LinkcheckReport.toString(this.excludedHttpStatusErrors));
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.excludedHttpStatusWarnings"));
        this.getSink().tableCell_();
        this.getSink().tableCell();
        if (this.excludedHttpStatusWarnings == null || this.excludedHttpStatusWarnings.length == 0) {
            this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.none"));
        } else {
            this.getSink().text(LinkcheckReport.toString(this.excludedHttpStatusWarnings));
        }
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().table_();
        this.getSink().paragraph();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.overview2"));
        this.getSink().paragraph_();
        this.getSink().table();
        this.generateTableHeader(locale, false);
        this.getSink().tableRow();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(totalFiles + "");
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(totalLinks + "");
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(String.valueOf(totalValidLinks));
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(String.valueOf(totalWarningLinks));
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableCell();
        this.getSink().bold();
        this.getSink().text(String.valueOf(totalErrorLinks));
        this.getSink().bold_();
        this.getSink().tableCell_();
        this.getSink().tableRow_();
        this.getSink().table_();
        this.getSink().section1_();
    }

    private void generateDetailsSection(Locale locale, LinkcheckModel linkcheckModel) {
        this.getSink().section1();
        this.getSink().sectionTitle1();
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.detail"));
        this.getSink().sectionTitle1_();
        this.getSink().paragraph();
        this.getSink().rawText(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.detail.overview"));
        this.getSink().paragraph_();
        this.getSink().table();
        this.generateTableHeader(locale, true);
        List linkcheckFiles = linkcheckModel.getFiles();
        Iterator it = linkcheckFiles.iterator();
        while (it.hasNext()) {
            LinkcheckFile linkcheckFile = (LinkcheckFile)it.next();
            this.getSink().tableRow();
            this.getSink().tableCell();
            if (linkcheckFile.getUnsuccessful() == 0) {
                this.iconValid(locale);
            } else {
                this.iconError(locale);
            }
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().link(linkcheckFile.getRelativePath());
            this.getSink().text(linkcheckFile.getRelativePath());
            this.getSink().link_();
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().text(String.valueOf(linkcheckFile.getNumberOfLinks()));
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().text(String.valueOf(linkcheckFile.getNumberOfLinks(3)));
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().text(String.valueOf(linkcheckFile.getNumberOfLinks(2)));
            this.getSink().tableCell_();
            this.getSink().tableCell();
            this.getSink().text(String.valueOf(linkcheckFile.getNumberOfLinks(1)));
            this.getSink().tableCell_();
            this.getSink().tableRow_();
            if (linkcheckFile.getUnsuccessful() == 0) continue;
            this.getSink().tableRow();
            this.getSink().tableCell();
            this.getSink().text("");
            this.getSink().tableCell_();
            this.getSink().rawText("<td colspan=\"5\">");
            this.getSink().table();
            Iterator it2 = linkcheckFile.getResults().iterator();
            while (it2.hasNext()) {
                LinkcheckFileResult linkcheckFileResult = (LinkcheckFileResult)it2.next();
                if (linkcheckFileResult.getStatusLevel() == 3) continue;
                this.getSink().tableRow();
                this.getSink().tableCell();
                if (linkcheckFileResult.getStatusLevel() == 2) {
                    this.iconWarning(locale);
                } else if (linkcheckFileResult.getStatusLevel() == 1) {
                    this.iconError(locale);
                }
                this.getSink().tableCell_();
                this.getSink().tableCell();
                this.getSink().italic();
                if (linkcheckFileResult.getTarget().startsWith("#")) {
                    this.getSink().link(linkcheckFile.getRelativePath() + linkcheckFileResult.getTarget());
                } else if (linkcheckFileResult.getTarget().startsWith(".")) {
                    String absolutePath = FilenameUtils.getFullPath((String)linkcheckFile.getRelativePath()) + linkcheckFileResult.getTarget();
                    String normalizedPath = FilenameUtils.normalize((String)absolutePath);
                    if (normalizedPath == null) {
                        normalizedPath = absolutePath;
                    }
                    this.getSink().link(normalizedPath);
                } else {
                    this.getSink().link(linkcheckFileResult.getTarget());
                }
                this.getSink().text(linkcheckFileResult.getTarget());
                this.getSink().link_();
                this.getSink().text(": ");
                this.getSink().text(linkcheckFileResult.getErrorMessage());
                this.getSink().italic_();
                this.getSink().tableCell_();
                this.getSink().tableRow_();
            }
            this.getSink().table_();
            this.getSink().tableCell_();
            this.getSink().tableRow_();
        }
        this.getSink().table_();
        this.getSink().section1_();
    }

    private void generateTableHeader(Locale locale, boolean detail) {
        this.getSink().tableRow();
        if (detail) {
            this.getSink().rawText("<th rowspan=\"2\">");
            this.getSink().text("");
            this.getSink().tableHeaderCell_();
        }
        this.getSink().rawText("<th rowspan=\"2\">");
        this.getSink().text(detail ? this.i18n.getString("linkcheck-report", locale, "report.linkcheck.detail.table.documents") : this.i18n.getString("linkcheck-report", locale, "report.linkcheck.summary.table.documents"));
        this.getSink().tableHeaderCell_();
        this.getSink().rawText("<th colspan=\"4\" align=\"center\">");
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.table.links"));
        this.getSink().tableHeaderCell_();
        this.getSink().tableRow_();
        this.getSink().tableRow();
        this.getSink().tableHeaderCell();
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.table.totalLinks"));
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.iconValid(locale);
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.iconWarning(locale);
        this.getSink().tableHeaderCell_();
        this.getSink().tableHeaderCell();
        this.iconError(locale);
        this.getSink().tableHeaderCell_();
        this.getSink().tableRow_();
    }

    private void iconError(Locale locale) {
        this.getSink().figure();
        this.getSink().figureCaption();
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.icon.error"));
        this.getSink().figureCaption_();
        this.getSink().figureGraphics("images/icon_error_sml.gif");
        this.getSink().figure_();
    }

    private void iconValid(Locale locale) {
        this.getSink().figure();
        this.getSink().figureCaption();
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.icon.valid"));
        this.getSink().figureCaption_();
        this.getSink().figureGraphics("images/icon_success_sml.gif");
        this.getSink().figure_();
    }

    private void iconWarning(Locale locale) {
        this.getSink().figure();
        this.getSink().figureCaption();
        this.getSink().text(this.i18n.getString("linkcheck-report", locale, "report.linkcheck.icon.warning"));
        this.getSink().figureCaption_();
        this.getSink().figureGraphics("images/icon_warning_sml.gif");
        this.getSink().figure_();
    }

    private static String toString(int[] a) {
        if (a == null || a.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        return buf.toString();
    }
}

