/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.patch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-patch-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Patch Plugin 1.1", 0);
        this.append(sb, "The Patch Plugin is used to apply patches to source files.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "apply".equals(this.goal)) {
            this.append(sb, "patch:apply", 0);
            this.append(sb, "Apply one or more patches to project sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "backups (Default: false)", 2);
                this.append(sb, "Whether to make backups of the original files before modding them.", 3);
                this.append(sb, "", 0);
                this.append(sb, "destFile", 2);
                this.append(sb, "The output file which is the original file, plus modifications from the patch.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failFast (Default: true)", 2);
                this.append(sb, "Flag being true if the desired behavior is to fail the build on the first failed patch detected.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failurePhrases", 2);
                this.append(sb, "List of phrases to watch for in the command output from the patch tool. If one is found, it will cause the build to fail. All phrases should be lower-case only. By default, the phrases fail, skip and reject are used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreWhitespace (Default: true)", 2);
                this.append(sb, "Whether to ignore whitespaces when applying the patches.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoredPatches", 2);
                this.append(sb, "When the strictPatching flag is set, this parameter is useful to mark certain contents of the patch-source directory that should be ignored without causing the build to fail.", 3);
                this.append(sb, "", 0);
                this.append(sb, "naturalOrderProcessing (Default: false)", 2);
                this.append(sb, "Setting natural order processing to true will cause all patches in a directory to be processed in a natural order alleviating the need to declare patches directly in the project file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "optimizations (Default: true)", 2);
                this.append(sb, "Flag to enable/disable optimization file from being written. This file tracks the patches that were applied the last time this goal actually executed. It is required for cases where project-sources optimizations are enabled, since project-sources will not be re-unpacked if they are at least as fresh as the source archive. If we avoid re-unpacking project sources, we need to make sure we don't reapply patches.\nNote: If the list of patches changes and this flag is enabled, a 'mvn clean' must be executed before the next build, to remove the tracking file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "originalFile", 2);
                this.append(sb, "The original file which will be modified by the patch. By default, the patch tool will automatically derive the original file from the header of the patch file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "patchDirectory (Default: src/main/patches)", 2);
                this.append(sb, "The base directory for the file names specified by the parameter patches.", 3);
                this.append(sb, "", 0);
                this.append(sb, "patchFile", 2);
                this.append(sb, "The single patch file to apply. This parameter is mutually exclusive with the patches parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "patchTrackingFile (Default: ${project.build.directory}/optimization-files/patches-applied.txt)", 2);
                this.append(sb, "This is the tracking file used to maintain a list of the patches applied to the unpacked project sources which are currently in the target directory. If this file is present, and project-source unpacking is optimized (meaning it won't re-unpack unless the project-sources archive is newer), this goal will not execute and no patches will be applied in the current build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "patches", 2);
                this.append(sb, "The list of patch file names, supplying the order in which patches should be applied. The path names in this list must be relative to the base directory specified by the parameter patchDirectory. This parameter is mutually exclusive with the patchfile parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "removeEmptyFiles (Default: false)", 2);
                this.append(sb, "When set to true, the empty files resulting from the patching process are removed. Empty ancestor directories are removed as well.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reverse (Default: false)", 2);
                this.append(sb, "Whether to treat these patches as having reversed source and dest in the patch syntax.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipApplication (Default: false)", 2);
                this.append(sb, "Whether to skip this goal's execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "strictPatching (Default: false)", 2);
                this.append(sb, "Flag that, when set to true, will make sure that all patches included in the patches list must be present and describe the full contents of the patch directory. If strictPatching is set to true, and the patches list has a value that does not correspond to a file in the patch directory, the build will fail. If strictPatching is set to true, and the patch directory contains files not listed in the patches parameter, the build will fail. If set to false, only the patches listed in the patches parameter that have corresponding files will be applied; the rest will be ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "strip (Default: 0)", 2);
                this.append(sb, "The number of directories to be stripped from patch file paths, before applying, starting from the leftmost, or root-est.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetDirectory (Default: ${project.build.sourceDirectory})", 2);
                this.append(sb, "The target directory for applying patches. Files in this directory will be modified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultIgnores (Default: true)", 2);
                this.append(sb, "Whether to exclude default ignored patch items, such as .svn or CVS directories.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "patch:help", 0);
            this.append(sb, "Display help information on maven-patch-plugin.\nCall\n\u00a0\u00a0mvn\u00a0patch:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

