/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private static final int DEFAULT_WIDTH = 80;
    private static final String DEFAULT_INDENT = HelpMojo.repeat(" ", 2);
    private boolean detail;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        sb.append("The 'org.apache.maven.plugins:maven-plugin-plugin' plugin has 7 goals:").append("\n");
        sb.append("\n");
        sb.append("plugin:addPluginArtifactMetadata").append("\n");
        Iterator it = HelpMojo.toLines("Inject any plugin-specific artifact metadata to the project's artifact, for subsequent installation and deployment. The first use-case for this is to add the LATEST metadata (which is plugin-specific) for shipping alongside the plugin's artifact.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("goalPrefix", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The prefix for the plugin goal.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("plugin:descriptor").append("\n");
        it = HelpMojo.toLines("Generate a plugin descriptor. Note: Phase is after the 'compilation' of any scripts.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("extractors", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The names of extractors to use. If not set, all extractors will be used. If set to an empty extractor name, no extractors will be used. Example:<!-- Use all extractors --> <extractors/> <!-- Use no extractors --> <extractors> <extractor/> </extractors> <!-- Use only bsh extractor --> <extractors> <extractor>bsh</extractor> </extractors>", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("goalPrefix", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The goal prefix that will appear before the ':'.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("outputDirectory (Default: '${project.build.outputDirectory}/META-INF/maven')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The directory where the generated plugin.xml file will be put.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("plugin:report").append("\n");
        it = HelpMojo.toLines("Generates the Plugin's documentation report.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("goalPrefix", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The goal prefix that will appear before the ':'.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("outputDirectory (Default: '${project.build.directory}/generated-site/xdoc')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Report output directory.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("requirements", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Specify some requirements to execute this plugin. Example:<requirements> <maven>2.0</maven> <jdk>1.4</jdk> <memory>256m</memory> <diskSpace>1m</diskSpace> <others> <property> <name>SVN</name> <value>1.4.6</value> </property> </others> </requirements>", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("plugin:xdoc").append("\n");
        it = HelpMojo.toLines("Generate Xdoc files for the project mojos or goals.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("extractors", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The names of extractors to use. If not set, all extractors will be used. If set to an empty extractor name, no extractors will be used. Example:<!-- Use all extractors --> <extractors/> <!-- Use no extractors --> <extractors> <extractor/> </extractors> <!-- Use only bsh extractor --> <extractors> <extractor>bsh</extractor> </extractors>", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("goalPrefix", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The goal prefix that will appear before the ':'.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("outputDirectory (Default: '${project.build.directory}/generated-site/xdoc')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The directory where the generated Xdoc files will be put.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("plugin:updateRegistry").append("\n");
        it = HelpMojo.toLines("Update the user plugin registry (if it's in use) to reflect the version we're installing.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("plugin:helpmojo").append("\n");
        it = HelpMojo.toLines("Generates a HelpMojo class.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("extractors", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The names of extractors to use. If not set, all extractors will be used. If set to an empty extractor name, no extractors will be used. Example:<!-- Use all extractors --> <extractors/> <!-- Use no extractors --> <extractors> <extractor/> </extractors> <!-- Use only bsh extractor --> <extractors> <extractor>bsh</extractor> </extractors>", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("goalPrefix", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The goal prefix that will appear before the ':'.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("outputDirectory (Default: '${project.build.directory}/generated-sources/plugin')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The directory where the generated HelpMojo file will be put.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("plugin:help").append("\n");
        it = HelpMojo.toLines("Display help information on 'org.apache.maven.plugins:maven-plugin-plugin' plugin. Call 'mvn plugin:help -Ddetail=true' to display all details.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private static List toLines(String str) {
        return HelpMojo.toLines(str, DEFAULT_INDENT, 80);
    }

    private static List toLines(String str, String indent, int size) {
        ArrayList<String> sentences = new ArrayList<String>();
        if (indent == null) {
            indent = "";
        }
        if (size < 0) {
            throw new IllegalArgumentException("size should be positive");
        }
        StringBuffer tmp = new StringBuffer(indent);
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (tmp.length() + word.length() + 1 < size) {
                tmp.append(word).append(" ");
                continue;
            }
            sentences.add(tmp.toString());
            tmp = new StringBuffer(indent);
            tmp.append(word).append(" ");
        }
        if (tmp.toString().length() > 0) {
            sentences.add(tmp.toString());
        }
        return sentences;
    }
}

