/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.Requirements;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.PluginXdocGenerator;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class PluginReport
extends AbstractMavenReport {
    private File outputDirectory;
    private Renderer siteRenderer;
    private MavenProject project;
    protected MojoScanner mojoScanner;
    private String encoding;
    private Requirements requirements;
    protected String goalPrefix;

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getPath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public boolean canGenerateReport() {
        return "maven-plugin".equals(this.project.getPackaging());
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            return;
        }
        String defaultGoalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        if (this.goalPrefix == null) {
            this.goalPrefix = defaultGoalPrefix;
        } else {
            this.getLog().warn((CharSequence)("\n\nGoal prefix is specified as: '" + this.goalPrefix + "'. Maven currently expects it to be '" + defaultGoalPrefix + "'.\n"));
        }
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(this.goalPrefix);
        try {
            pluginDescriptor.setDependencies(PluginUtils.toComponentDependencies((List)this.project.getRuntimeDependencies()));
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            request.setEncoding(this.encoding);
            this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
            this.generatePluginDocumentation(pluginDescriptor, locale);
            PluginOverviewRenderer r = new PluginOverviewRenderer(this.project, this.requirements, this.getSink(), pluginDescriptor, locale);
            r.render();
        }
        catch (InvalidPluginDescriptorException e) {
            throw new MavenReportException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
        catch (ExtractionException e) {
            throw new MavenReportException("Error extracting plugin descriptor: '" + e.getLocalizedMessage() + "'", (Exception)((Object)e));
        }
    }

    public String getDescription(Locale locale) {
        return PluginReport.getBundle(locale).getString("report.plugin.description");
    }

    public String getName(Locale locale) {
        return PluginReport.getBundle(locale).getString("report.plugin.name");
    }

    public String getOutputName() {
        return "plugin-info";
    }

    private void generatePluginDocumentation(PluginDescriptor pluginDescriptor, Locale locale) throws MavenReportException {
        try {
            File outputDir = new File(this.getOutputDirectory());
            outputDir.mkdirs();
            PluginXdocGenerator generator = new PluginXdocGenerator(this.project, locale);
            generator.execute(outputDir, pluginDescriptor);
        }
        catch (IOException e) {
            throw new MavenReportException("Error writing plugin documentation", (Exception)e);
        }
    }

    protected static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("plugin-report", locale, PluginReport.class.getClassLoader());
    }

    static class PluginOverviewRenderer
    extends AbstractMavenReportRenderer {
        private final MavenProject project;
        private final Requirements requirements;
        private final PluginDescriptor pluginDescriptor;
        private final Locale locale;

        public PluginOverviewRenderer(MavenProject project, Requirements requirements, Sink sink, PluginDescriptor pluginDescriptor, Locale locale) {
            super(sink);
            this.project = project;
            this.requirements = requirements == null ? new Requirements() : requirements;
            this.pluginDescriptor = pluginDescriptor;
            this.locale = locale;
        }

        public String getTitle() {
            return PluginReport.getBundle(this.locale).getString("report.plugin.title");
        }

        public void renderBody() {
            this.startSection(this.getTitle());
            if (this.pluginDescriptor.getMojos() == null || this.pluginDescriptor.getMojos().size() <= 0) {
                this.paragraph(PluginReport.getBundle(this.locale).getString("report.plugin.goals.nogoal"));
                this.endSection();
                return;
            }
            this.paragraph(PluginReport.getBundle(this.locale).getString("report.plugin.goals.intro"));
            boolean hasMavenReport = false;
            Iterator i = this.pluginDescriptor.getMojos().iterator();
            while (i.hasNext()) {
                MojoDescriptor mojo = (MojoDescriptor)i.next();
                if (!PluginUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) continue;
                hasMavenReport = true;
            }
            this.startTable();
            String goalColumnName = PluginReport.getBundle(this.locale).getString("report.plugin.goals.column.goal");
            String isMavenReport = PluginReport.getBundle(this.locale).getString("report.plugin.goals.column.isMavenReport");
            String descriptionColumnName = PluginReport.getBundle(this.locale).getString("report.plugin.goals.column.description");
            if (hasMavenReport) {
                this.tableHeader(new String[]{goalColumnName, isMavenReport, descriptionColumnName});
            } else {
                this.tableHeader(new String[]{goalColumnName, descriptionColumnName});
            }
            ArrayList mojos = new ArrayList();
            mojos.addAll(this.pluginDescriptor.getMojos());
            PluginUtils.sortMojos(mojos);
            Iterator i2 = mojos.iterator();
            while (i2.hasNext()) {
                MojoDescriptor mojo = (MojoDescriptor)i2.next();
                String goalName = mojo.getFullGoalName();
                String goalDocumentationLink = "./" + mojo.getGoal() + "-mojo.html";
                String description = StringUtils.isNotEmpty((String)mojo.getDeprecated()) ? "<strong>" + PluginReport.getBundle(this.locale).getString("report.plugin.goal.deprecated") + "</strong> " + PluginUtils.makeHtmlValid((String)mojo.getDeprecated()) : (StringUtils.isNotEmpty((String)mojo.getDescription()) ? PluginUtils.makeHtmlValid((String)mojo.getDescription()) : PluginReport.getBundle(this.locale).getString("report.plugin.goal.nodescription"));
                this.sink.tableRow();
                this.tableCell(PluginOverviewRenderer.createLinkPatternedText((String)goalName, (String)goalDocumentationLink));
                if (hasMavenReport) {
                    if (PluginUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) {
                        this.sink.tableCell();
                        this.sink.text(PluginReport.getBundle(this.locale).getString("report.plugin.isReport"));
                        this.sink.tableCell_();
                    } else {
                        this.sink.tableCell();
                        this.sink.text(PluginReport.getBundle(this.locale).getString("report.plugin.isNotReport"));
                        this.sink.tableCell_();
                    }
                }
                this.tableCell(description, true);
                this.sink.tableRow_();
            }
            this.endTable();
            this.startSection(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements"));
            this.paragraph(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.intro"));
            this.startTable();
            String maven = PluginOverviewRenderer.discoverMavenRequirement(this.project, this.requirements);
            this.sink.tableRow();
            this.tableCell(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.maven"));
            this.tableCell(maven != null ? maven : PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.nominimum"));
            this.sink.tableRow_();
            String jdk = PluginOverviewRenderer.discoverJdkRequirement(this.project, this.requirements);
            this.sink.tableRow();
            this.tableCell(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.jdk"));
            this.tableCell(jdk != null ? jdk : PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.nominimum"));
            this.sink.tableRow_();
            this.sink.tableRow();
            this.tableCell(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.memory"));
            this.tableCell(StringUtils.isNotEmpty((String)this.requirements.getMemory()) ? this.requirements.getMemory() : PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.nominimum"));
            this.sink.tableRow_();
            this.sink.tableRow();
            this.tableCell(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.diskspace"));
            this.tableCell(StringUtils.isNotEmpty((String)this.requirements.getDiskSpace()) ? this.requirements.getDiskSpace() : PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.nominimum"));
            this.sink.tableRow_();
            if (this.requirements.getOthers() != null && this.requirements.getOthers().size() > 0) {
                Iterator<Object> it = this.requirements.getOthers().keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    this.sink.tableRow();
                    this.tableCell(key);
                    this.tableCell(StringUtils.isNotEmpty((String)this.requirements.getOthers().getProperty(key)) ? this.requirements.getOthers().getProperty(key) : PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.nominimum"));
                    this.sink.tableRow_();
                }
            }
            this.endTable();
            this.endSection();
            this.renderUsageSection(hasMavenReport);
            this.endSection();
        }

        private void renderUsageSection(boolean hasMavenReport) {
            this.startSection(PluginReport.getBundle(this.locale).getString("report.plugin.usage"));
            this.sink.paragraph();
            this.text(PluginReport.getBundle(this.locale).getString("report.plugin.usage.intro"));
            this.sink.paragraph_();
            StringBuffer sb = new StringBuffer();
            sb.append("<project>").append('\n');
            sb.append("  ...").append('\n');
            sb.append("  <build>").append('\n');
            sb.append("    <!-- " + PluginReport.getBundle(this.locale).getString("report.plugin.usage.pluginManagement") + " -->").append('\n');
            sb.append("    <pluginManagement>").append('\n');
            sb.append("      <plugins>").append('\n');
            sb.append("        <plugin>").append('\n');
            sb.append("          <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append('\n');
            sb.append("          <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append('\n');
            sb.append("          <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append('\n');
            sb.append("        </plugin>").append('\n');
            sb.append("        ...").append('\n');
            sb.append("      </plugins>").append('\n');
            sb.append("    </pluginManagement>").append('\n');
            sb.append("    <!-- " + PluginReport.getBundle(this.locale).getString("report.plugin.usage.plugins") + " -->").append('\n');
            sb.append("    <plugins>").append('\n');
            sb.append("      <plugin>").append('\n');
            sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append('\n');
            sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append('\n');
            sb.append("        <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append('\n');
            sb.append("      </plugin>").append('\n');
            sb.append("      ...").append('\n');
            sb.append("    </plugins>").append('\n');
            sb.append("  </build>").append('\n');
            if (hasMavenReport) {
                sb.append("  ...").append('\n');
                sb.append("  <!-- " + PluginReport.getBundle(this.locale).getString("report.plugin.usage.reporting") + " -->").append('\n');
                sb.append("  <reporting>").append('\n');
                sb.append("    <plugins>").append('\n');
                sb.append("      <plugin>").append('\n');
                sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append('\n');
                sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append('\n');
                sb.append("        <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append('\n');
                sb.append("      </plugin>").append('\n');
                sb.append("      ...").append('\n');
                sb.append("    </plugins>").append('\n');
                sb.append("  </reporting>").append('\n');
            }
            sb.append("  ...").append('\n');
            sb.append("</project>").append('\n');
            this.verbatimText(sb.toString());
            this.sink.paragraph();
            this.linkPatternedText(PluginReport.getBundle(this.locale).getString("report.plugin.configuration.end"));
            this.sink.paragraph_();
            this.endSection();
        }

        private static String discoverMavenRequirement(MavenProject project, Requirements requirements) {
            String maven = requirements.getMaven();
            if (maven == null) {
                String string = maven = project.getPrerequisites() != null ? project.getPrerequisites().getMaven() : null;
            }
            if (maven == null) {
                maven = "2.0";
            }
            return maven;
        }

        private static String discoverJdkRequirement(MavenProject project, Requirements requirements) {
            String jdk = requirements.getJdk();
            if (jdk == null) {
                jdk = PluginOverviewRenderer.discoverJdkRequirementFromPlugins(project.getBuild().getPluginsAsMap());
            }
            if (jdk == null && project.getPluginManagement() != null) {
                jdk = PluginOverviewRenderer.discoverJdkRequirementFromPlugins(project.getPluginManagement().getPluginsAsMap());
            }
            if (jdk == null) {
                jdk = "1.1";
            }
            return jdk;
        }

        private static String discoverJdkRequirementFromPlugins(Map pluginsAsMap) {
            if (pluginsAsMap == null) {
                return null;
            }
            String jdk = null;
            Iterator it = pluginsAsMap.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                if (!key.equals("org.apache.maven.plugins:maven-compiler-plugin")) continue;
                Object value = pluginsAsMap.get(key);
                Xpp3Dom pluginConf = null;
                if (value instanceof Plugin) {
                    Plugin plugin = (Plugin)value;
                    pluginConf = (Xpp3Dom)plugin.getConfiguration();
                }
                if (value instanceof ReportPlugin) {
                    ReportPlugin reportPlugin = (ReportPlugin)value;
                    pluginConf = (Xpp3Dom)reportPlugin.getConfiguration();
                }
                if (pluginConf == null || pluginConf.getChild("target") == null) continue;
                jdk = pluginConf.getChild("target").getValue();
            }
            return jdk;
        }
    }
}

