/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.plugin.report_old;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.plugin.report_old.Requirements;
import org.apache.maven.plugin.plugin.report_old.RequirementsHistory;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.plugin.descriptor_old.EnhancedPluginDescriptorBuilder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.generator.PluginXdocGenerator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Deprecated
@Mojo(name="report", threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class PluginReport
extends AbstractMavenReport {
    @Parameter(defaultValue="${project.build.directory}/generated-site/xdoc")
    private File outputDirectory;
    @Deprecated
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Deprecated
    @Parameter
    private Requirements requirements;
    @Deprecated
    @Parameter(property="goalPrefix")
    protected String goalPrefix;
    @Deprecated
    @Parameter(defaultValue="false", property="maven.plugin.skip")
    private boolean skipReport;
    @Parameter(defaultValue="false", property="maven.plugin.report.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="maven.plugin.report.hasExtensionsToLoad")
    private boolean hasExtensionsToLoad;
    @Parameter
    private List<RequirementsHistory> requirementsHistories = new ArrayList<RequirementsHistory>();
    @Component
    private RuntimeInformation rtInfo;
    @Deprecated
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/maven/plugin.xml", required=true, readonly=true)
    private File pluginXmlFile;
    @Parameter(defaultValue="${project.build.directory}/plugin-enhanced.xml", required=true, readonly=true)
    private File enhancedPluginXmlFile;
    @Parameter(property="maven.plugin.report.disableInternalJavadocLinkValidation")
    private boolean disableInternalJavadocLinkValidation;

    protected String getOutputDirectory() {
        return this.project.getReporting().getOutputDirectory();
    }

    public boolean canGenerateReport() {
        return this.enhancedPluginXmlFile != null && this.enhancedPluginXmlFile.isFile() && this.enhancedPluginXmlFile.canRead();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.getLog().warn((CharSequence)"The 'report' goal of the maven-plugin-plugin is deprecated, please use the 'report' goal from the maven-plugin-report-plugin instead. This goal will be removed in version 4.0.0.");
        if (this.skip || this.skipReport) {
            this.getLog().info((CharSequence)"Maven Plugin Plugin Report generation skipped.");
            return;
        }
        PluginDescriptor pluginDescriptor = this.extractPluginDescriptor();
        this.generateMojosDocumentation(pluginDescriptor, locale);
        PluginOverviewRenderer r = new PluginOverviewRenderer(this.getProject(), this.requirements, this.requirementsHistories, this.getSink(), pluginDescriptor, locale, this.hasExtensionsToLoad);
        r.render();
    }

    private PluginDescriptor extractPluginDescriptor() throws MavenReportException {
        PluginDescriptor pluginDescriptor;
        EnhancedPluginDescriptorBuilder builder = new EnhancedPluginDescriptorBuilder(this.rtInfo);
        XmlStreamReader input = new XmlStreamReader(Files.newInputStream(this.enhancedPluginXmlFile.toPath(), new OpenOption[0]));
        try {
            pluginDescriptor = builder.build((Reader)input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | PlexusConfigurationException e) {
                throw new MavenReportException("Error extracting plugin descriptor from " + this.enhancedPluginXmlFile, (Exception)e);
            }
        }
        input.close();
        return pluginDescriptor;
    }

    public String getDescription(Locale locale) {
        return PluginReport.getBundle(locale).getString("report.plugin.description");
    }

    public String getName(Locale locale) {
        return PluginReport.getBundle(locale).getString("report.plugin.name");
    }

    public String getOutputName() {
        return "plugin-info";
    }

    private void generateMojosDocumentation(PluginDescriptor pluginDescriptor, Locale locale) throws MavenReportException {
        try {
            File outputDir = this.outputDirectory;
            outputDir.mkdirs();
            PluginXdocGenerator generator = new PluginXdocGenerator(this.getProject(), locale, this.getReportOutputDirectory(), this.disableInternalJavadocLinkValidation);
            DefaultPluginToolsRequest pluginToolsRequest = new DefaultPluginToolsRequest(this.getProject(), pluginDescriptor);
            generator.execute(outputDir, (PluginToolsRequest)pluginToolsRequest);
        }
        catch (GeneratorException e) {
            throw new MavenReportException("Error writing plugin documentation", (Exception)((Object)e));
        }
    }

    protected static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("plugin-report", locale, PluginReport.class.getClassLoader());
    }

    static class PluginOverviewRenderer
    extends AbstractMavenReportRenderer {
        private final MavenProject project;
        private final Requirements requirements;
        private final List<RequirementsHistory> requirementsHistories;
        private final PluginDescriptor pluginDescriptor;
        private final Locale locale;
        private final boolean hasExtensionsToLoad;

        PluginOverviewRenderer(MavenProject project, Requirements requirements, List<RequirementsHistory> requirementsHistories, Sink sink, PluginDescriptor pluginDescriptor, Locale locale, boolean hasExtensionsToLoad) {
            super(sink);
            this.project = project;
            this.requirements = requirements == null ? new Requirements() : requirements;
            this.requirementsHistories = requirementsHistories;
            this.pluginDescriptor = pluginDescriptor;
            this.locale = locale;
            this.hasExtensionsToLoad = hasExtensionsToLoad;
        }

        public String getTitle() {
            return PluginReport.getBundle(this.locale).getString("report.plugin.title");
        }

        public void renderBody() {
            String diskSpace;
            this.startSection(this.getTitle());
            if (this.pluginDescriptor.getMojos() == null || this.pluginDescriptor.getMojos().size() <= 0) {
                this.paragraph(PluginReport.getBundle(this.locale).getString("report.plugin.goals.nogoal"));
                this.endSection();
                return;
            }
            this.paragraph(PluginReport.getBundle(this.locale).getString("report.plugin.goals.intro"));
            boolean hasMavenReport = false;
            for (MojoDescriptor mojo : this.pluginDescriptor.getMojos()) {
                if (!GeneratorUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) continue;
                hasMavenReport = true;
            }
            this.startTable();
            String goalColumnName = PluginReport.getBundle(this.locale).getString("report.plugin.goals.column.goal");
            String isMavenReport = PluginReport.getBundle(this.locale).getString("report.plugin.goals.column.isMavenReport");
            String descriptionColumnName = PluginReport.getBundle(this.locale).getString("report.plugin.goals.column.description");
            if (hasMavenReport) {
                this.tableHeader(new String[]{goalColumnName, isMavenReport, descriptionColumnName});
            } else {
                this.tableHeader(new String[]{goalColumnName, descriptionColumnName});
            }
            ArrayList mojos = new ArrayList();
            mojos.addAll(this.pluginDescriptor.getMojos());
            PluginUtils.sortMojos(mojos);
            for (MojoDescriptor mojo : mojos) {
                String goalName = mojo.getFullGoalName();
                String goalDocumentationLink = "./" + mojo.getGoal() + "-mojo.html";
                String description = StringUtils.isNotEmpty((String)mojo.getDeprecated()) ? "<strong>" + PluginReport.getBundle(this.locale).getString("report.plugin.goal.deprecated") + "</strong> " + mojo.getDeprecated() : (StringUtils.isNotEmpty((String)mojo.getDescription()) ? mojo.getDescription() : PluginReport.getBundle(this.locale).getString("report.plugin.goal.nodescription"));
                this.sink.tableRow();
                this.tableCell(PluginOverviewRenderer.createLinkPatternedText((String)goalName, (String)goalDocumentationLink));
                if (hasMavenReport) {
                    if (GeneratorUtils.isMavenReport((String)mojo.getImplementation(), (MavenProject)this.project)) {
                        this.sink.tableCell();
                        this.sink.text(PluginReport.getBundle(this.locale).getString("report.plugin.isReport"));
                        this.sink.tableCell_();
                    } else {
                        this.sink.tableCell();
                        this.sink.text(PluginReport.getBundle(this.locale).getString("report.plugin.isNotReport"));
                        this.sink.tableCell_();
                    }
                }
                this.tableCell(description, true);
                this.sink.tableRow_();
            }
            this.endTable();
            this.startSection(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements"));
            this.paragraph(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.intro"));
            this.startTable();
            String maven = PluginOverviewRenderer.discoverMavenRequirement(this.project, this.requirements);
            this.sink.tableRow();
            this.tableCell(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.maven"));
            this.tableCell(maven != null ? maven : PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.nominimum"));
            this.sink.tableRow_();
            String jdk = PluginOverviewRenderer.discoverJdkRequirement(this.project, this.requirements);
            this.sink.tableRow();
            this.tableCell(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.jdk"));
            this.tableCell(jdk != null ? jdk : PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.nominimum"));
            this.sink.tableRow_();
            String memory = this.requirements.getMemory();
            if (StringUtils.isNotEmpty((String)memory)) {
                this.sink.tableRow();
                this.tableCell(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.memory"));
                this.tableCell(memory);
                this.sink.tableRow_();
            }
            if (StringUtils.isNotEmpty((String)(diskSpace = this.requirements.getDiskSpace()))) {
                this.sink.tableRow();
                this.tableCell(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.diskspace"));
                this.tableCell(diskSpace);
                this.sink.tableRow_();
            }
            if (this.requirements.getOthers() != null && this.requirements.getOthers().size() > 0) {
                Iterator<Object> it = this.requirements.getOthers().keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    this.sink.tableRow();
                    this.tableCell(key);
                    this.tableCell(StringUtils.isNotEmpty((String)this.requirements.getOthers().getProperty(key)) ? this.requirements.getOthers().getProperty(key) : PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.nominimum"));
                    this.sink.tableRow_();
                }
            }
            this.endTable();
            this.endSection();
            this.renderRequirementsHistories();
            this.renderUsageSection(hasMavenReport);
            this.endSection();
        }

        private void renderRequirementsHistories() {
            if (this.requirementsHistories.isEmpty()) {
                return;
            }
            this.startSection(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.history"));
            this.paragraph(PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.history.intro"));
            this.startTable();
            this.tableHeader(new String[]{PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.history.version"), PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.history.maven"), PluginReport.getBundle(this.locale).getString("report.plugin.systemrequirements.history.jdk")});
            this.requirementsHistories.forEach(requirementsHistory -> {
                this.sink.tableRow();
                this.tableCell(requirementsHistory.getVersion());
                this.tableCell(requirementsHistory.getMaven());
                this.tableCell(requirementsHistory.getJdk());
                this.sink.tableRow_();
            });
            this.endTable();
            this.endSection();
        }

        private void renderUsageSection(boolean hasMavenReport) {
            this.startSection(PluginReport.getBundle(this.locale).getString("report.plugin.usage"));
            this.sink.paragraph();
            this.text(PluginReport.getBundle(this.locale).getString("report.plugin.usage.intro"));
            this.sink.paragraph_();
            StringBuilder sb = new StringBuilder();
            sb.append("<project>").append('\n');
            sb.append("  ...").append('\n');
            sb.append("  <build>").append('\n');
            sb.append("    <!-- " + PluginReport.getBundle(this.locale).getString("report.plugin.usage.pluginManagement") + " -->").append('\n');
            sb.append("    <pluginManagement>").append('\n');
            sb.append("      <plugins>").append('\n');
            sb.append("        <plugin>").append('\n');
            sb.append("          <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append('\n');
            sb.append("          <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append('\n');
            sb.append("          <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append('\n');
            if (this.hasExtensionsToLoad) {
                sb.append("          <extensions>true</extensions>").append('\n');
            }
            sb.append("        </plugin>").append('\n');
            sb.append("        ...").append('\n');
            sb.append("      </plugins>").append('\n');
            sb.append("    </pluginManagement>").append('\n');
            sb.append("    <!-- " + PluginReport.getBundle(this.locale).getString("report.plugin.usage.plugins") + " -->").append('\n');
            sb.append("    <plugins>").append('\n');
            sb.append("      <plugin>").append('\n');
            sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append('\n');
            sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append('\n');
            sb.append("      </plugin>").append('\n');
            sb.append("      ...").append('\n');
            sb.append("    </plugins>").append('\n');
            sb.append("  </build>").append('\n');
            if (hasMavenReport) {
                sb.append("  ...").append('\n');
                sb.append("  <!-- " + PluginReport.getBundle(this.locale).getString("report.plugin.usage.reporting") + " -->").append('\n');
                sb.append("  <reporting>").append('\n');
                sb.append("    <plugins>").append('\n');
                sb.append("      <plugin>").append('\n');
                sb.append("        <groupId>").append(this.pluginDescriptor.getGroupId()).append("</groupId>").append('\n');
                sb.append("        <artifactId>").append(this.pluginDescriptor.getArtifactId()).append("</artifactId>").append('\n');
                sb.append("        <version>").append(this.pluginDescriptor.getVersion()).append("</version>").append('\n');
                sb.append("      </plugin>").append('\n');
                sb.append("      ...").append('\n');
                sb.append("    </plugins>").append('\n');
                sb.append("  </reporting>").append('\n');
            }
            sb.append("  ...").append('\n');
            sb.append("</project>").append('\n');
            this.verbatimText(sb.toString());
            this.sink.paragraph();
            this.linkPatternedText(PluginReport.getBundle(this.locale).getString("report.plugin.configuration.end"));
            this.sink.paragraph_();
            this.endSection();
        }

        private static String discoverMavenRequirement(MavenProject project, Requirements requirements) {
            String maven = requirements.getMaven();
            if (maven == null) {
                String string = maven = project.getPrerequisites() != null ? project.getPrerequisites().getMaven() : null;
            }
            if (maven == null) {
                maven = "2.0";
            }
            return maven;
        }

        private static String discoverJdkRequirement(MavenProject project, Requirements requirements) {
            String version;
            String jdk = requirements.getJdk();
            if (jdk != null) {
                return jdk;
            }
            Plugin compiler = PluginOverviewRenderer.getCompilerPlugin(project.getBuild().getPluginsAsMap());
            if (compiler == null) {
                compiler = PluginOverviewRenderer.getCompilerPlugin(project.getPluginManagement().getPluginsAsMap());
            }
            if ((jdk = PluginOverviewRenderer.getPluginParameter(compiler, "release")) != null) {
                return jdk;
            }
            jdk = project.getProperties().getProperty("maven.compiler.release");
            if (jdk != null) {
                return jdk;
            }
            jdk = PluginOverviewRenderer.getPluginParameter(compiler, "target");
            if (jdk != null) {
                return jdk;
            }
            jdk = project.getProperties().getProperty("maven.compiler.target");
            if (jdk != null) {
                return jdk;
            }
            String string = version = compiler == null ? null : compiler.getVersion();
            if (version != null) {
                return "Default target for maven-compiler-plugin version " + version;
            }
            return "Unknown";
        }

        private static Plugin getCompilerPlugin(Map<String, Plugin> pluginsAsMap) {
            return pluginsAsMap.get("org.apache.maven.plugins:maven-compiler-plugin");
        }

        private static String getPluginParameter(Plugin plugin, String parameter) {
            Xpp3Dom target;
            Xpp3Dom pluginConf;
            if (plugin != null && (pluginConf = (Xpp3Dom)plugin.getConfiguration()) != null && (target = pluginConf.getChild(parameter)) != null) {
                return target.getValue();
            }
            return null;
        }
    }
}

