/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.pmd.AbstractPmdViolationCheckMojo;
import org.apache.maven.plugin.pmd.ViolationDetails;
import org.apache.maven.plugin.pmd.model.PmdErrorDetail;
import org.apache.maven.plugin.pmd.model.PmdFile;
import org.apache.maven.plugin.pmd.model.Violation;
import org.apache.maven.plugin.pmd.model.io.xpp3.PmdXpp3Reader;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
@Execute(goal="pmd")
public class PmdViolationCheckMojo
extends AbstractPmdViolationCheckMojo<Violation> {
    @Parameter(property="pmd.failurePriority", defaultValue="5", required=true)
    private int failurePriority;
    @Parameter(property="pmd.skip", defaultValue="false")
    private boolean skip;
    private final Map<String, Set<String>> excludeFromFailureClasses = new HashMap<String, Set<String>>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.executeCheck("pmd.xml", "violation", "PMD violation", this.failurePriority);
        }
    }

    @Override
    protected void loadExcludeFromFailuresData(String excludeFromFailureFile) throws MojoExecutionException {
        File file = new File(excludeFromFailureFile);
        if (!file.exists()) {
            return;
        }
        Properties props = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(excludeFromFailureFile));
            props.load(fileInputStream);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Cannot load properties file " + excludeFromFailureFile, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileInputStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)fileInputStream);
        for (Map.Entry<Object, Object> propEntry : props.entrySet()) {
            String[] excludedRules;
            HashSet<String> excludedRuleSet = new HashSet<String>();
            String className = propEntry.getKey().toString();
            for (String excludedRule : excludedRules = propEntry.getValue().toString().split(",")) {
                excludedRuleSet.add(excludedRule.trim());
            }
            this.excludeFromFailureClasses.put(className, excludedRuleSet);
        }
    }

    @Override
    protected boolean isExcludedFromFailure(Violation errorDetail) {
        String className = this.extractClassName(errorDetail);
        Set<String> excludedRuleSet = this.excludeFromFailureClasses.get(className);
        return excludedRuleSet != null && excludedRuleSet.contains(errorDetail.getRule());
    }

    private String extractClassName(Violation errorDetail) {
        String fileName;
        if (errorDetail.getViolationPackage() != null && errorDetail.getViolationClass() != null) {
            return errorDetail.getViolationPackage() + "." + errorDetail.getViolationClass();
        }
        int javaIdx = (fileName = errorDetail.getFileName()).indexOf("\\java\\");
        return fileName.substring(javaIdx >= 0 ? javaIdx + 6 : 0, fileName.length() - 5).replace('\\', '.');
    }

    @Override
    protected void printError(Violation item, String severity) {
        StringBuilder buff = new StringBuilder(100);
        buff.append("PMD ").append(severity).append(": ");
        if (item.getViolationClass() != null) {
            if (item.getViolationPackage() != null) {
                buff.append(item.getViolationPackage());
                buff.append(".");
            }
            buff.append(item.getViolationClass());
        } else {
            buff.append(item.getFileName());
        }
        buff.append(":");
        buff.append(item.getBeginline());
        buff.append(" Rule:").append(item.getRule());
        buff.append(" Priority:").append(item.getPriority());
        buff.append(" ").append(item.getText()).append(".");
        this.getLog().info((CharSequence)buff.toString());
    }

    @Override
    protected List<Violation> getErrorDetails(File pmdFile) throws XmlPullParserException, IOException {
        PmdXpp3Reader reader = new PmdXpp3Reader();
        PmdErrorDetail details = reader.read(new FileReader(pmdFile), false);
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (PmdFile file : details.getFiles()) {
            String fullPath = file.getName();
            for (Violation violation : file.getViolations()) {
                violation.setFileName(this.getFilename(fullPath, violation.getViolationPackage()));
                violations.add(violation);
            }
        }
        return violations;
    }

    @Override
    protected int getPriority(Violation errorDetail) {
        return errorDetail.getPriority();
    }

    @Override
    protected ViolationDetails<Violation> newViolationDetailsInstance() {
        return new ViolationDetails<Violation>();
    }

    private String getFilename(String fullpath, String pkg) {
        int index = fullpath.lastIndexOf(File.separatorChar);
        while (StringUtils.isNotEmpty((String)pkg)) {
            index = fullpath.substring(0, index).lastIndexOf(File.separatorChar);
            int dot = pkg.indexOf(46);
            if (dot < 0) break;
            pkg = pkg.substring(dot + 1);
        }
        return fullpath.substring(index + 1);
    }
}

