/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Model;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class TeamListReport
extends AbstractProjectInfoReport {
    static /* synthetic */ Class class$org$apache$maven$model$Contributor;

    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.team-list.name");
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.team-list.description");
    }

    public void executeReport(Locale locale) {
        TeamListRenderer r = new TeamListRenderer(this.getSink(), this.project.getModel(), this.i18n, locale);
        r.render();
    }

    public String getOutputName() {
        return "team-list";
    }

    private static class TeamListRenderer
    extends AbstractMavenReportRenderer {
        private static final String PROPERTIES = "properties";
        private static final String TIME_ZONE = "timeZone";
        private static final String ROLES = "roles";
        private static final String ORGANIZATION_URL = "organizationUrl";
        private static final String ORGANIZATION = "organization";
        private static final String URL = "url";
        private static final String EMAIL = "email";
        private static final String NAME = "name";
        private static final String ID = "id";
        private Model model;
        private I18N i18n;
        private Locale locale;
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        TeamListRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink);
            this.model = model;
            this.i18n = i18n;
            this.locale = locale;
        }

        public String getTitle() {
            return this.i18n.getString("project-info-report", this.locale, "report.team-list.title");
        }

        public void renderBody() {
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.team-list.intro.title"));
            StringBuffer javascript = new StringBuffer("function offsetDate(id, offset) {\n");
            javascript.append("    var now = new Date();\n");
            javascript.append("    var nowTime = now.getTime();\n");
            javascript.append("    var localOffset = now.getTimezoneOffset();\n");
            javascript.append("    var developerTime = nowTime + ( offset * 60 * 60 * 1000 )+ ( localOffset * 60 * 1000 );\n");
            javascript.append("    var developerDate = new Date(developerTime);\n");
            javascript.append("\n");
            javascript.append("    document.getElementById(id).innerHTML = developerDate;\n");
            javascript.append("}\n");
            javascript.append("\n");
            javascript.append("function init(){\n");
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.intro.description1"));
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.intro.description2"));
            List developers = this.model.getDevelopers();
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.title"));
            if (developers == null || developers.isEmpty()) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.nodeveloper"));
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.intro"));
                this.startTable();
                HashMap headersMap = new HashMap();
                this.checkRequiredHeaders(headersMap, developers);
                String[] requiredHeaders = this.getRequiredDevHeaderArray(headersMap);
                this.tableHeader(requiredHeaders);
                int developersRows = 0;
                Iterator i = developers.iterator();
                while (i.hasNext()) {
                    Developer developer = (Developer)i.next();
                    this.renderDeveloper(developer, developersRows, headersMap, javascript);
                    ++developersRows;
                }
                this.endTable();
            }
            this.endSection();
            List contributors = this.model.getContributors();
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.title"));
            if (contributors == null || contributors.isEmpty()) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.nocontributor"));
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.intro"));
                this.startTable();
                HashMap headersMap = new HashMap();
                this.checkRequiredHeaders(headersMap, contributors);
                String[] requiredHeaders = this.getRequiredContrHeaderArray(headersMap);
                this.tableHeader(requiredHeaders);
                int contributorsRows = 0;
                Iterator i = contributors.iterator();
                while (i.hasNext()) {
                    Contributor contributor = (Contributor)i.next();
                    this.renderContributor(contributor, contributorsRows, headersMap, javascript);
                    ++contributorsRows;
                }
                this.endTable();
            }
            this.endSection();
            this.endSection();
            javascript.append("}\n").append("\n").append("window.onLoad = init();\n");
            this.javaScript(javascript.toString());
        }

        private void renderDeveloper(Developer developer, int developerRow, Map headersMap, StringBuffer javascript) {
            this.sink.tableRow();
            if (headersMap.get(ID) == Boolean.TRUE) {
                this.tableCell("<a name=\"" + developer.getId() + "\"></a>" + developer.getId(), true);
            }
            if (headersMap.get(NAME) == Boolean.TRUE) {
                this.tableCell(developer.getName());
            }
            if (headersMap.get(EMAIL) == Boolean.TRUE) {
                this.tableCell(TeamListRenderer.createLinkPatternedText((String)developer.getEmail(), (String)developer.getEmail()));
            }
            if (headersMap.get(URL) == Boolean.TRUE) {
                this.tableCellForUrl(developer.getUrl());
            }
            if (headersMap.get(ORGANIZATION) == Boolean.TRUE) {
                this.tableCell(developer.getOrganization());
            }
            if (headersMap.get(ORGANIZATION_URL) == Boolean.TRUE) {
                this.tableCellForUrl(developer.getOrganizationUrl());
            }
            if (headersMap.get(ROLES) == Boolean.TRUE) {
                if (developer.getRoles() != null) {
                    this.tableCell(StringUtils.join((Object[])developer.getRoles().toArray(EMPTY_STRING_ARRAY), (String)", "));
                } else {
                    this.tableCell(null);
                }
            }
            if (headersMap.get(TIME_ZONE) == Boolean.TRUE) {
                this.tableCell(developer.getTimezone());
                this.sink.tableCell();
                this.sink.rawText("<span id=\"developer-" + developerRow + "\">");
                this.text(developer.getTimezone());
                if (!StringUtils.isEmpty((String)developer.getTimezone())) {
                    javascript.append("    offsetDate('developer-").append(developerRow).append("', '");
                    javascript.append(developer.getTimezone());
                    javascript.append("');\n");
                }
                this.sink.rawText("</span>");
                this.sink.tableCell_();
            }
            if (headersMap.get(PROPERTIES) == Boolean.TRUE) {
                Properties props = developer.getProperties();
                if (props != null) {
                    this.tableCell(TeamListRenderer.propertiesToString((Properties)props));
                } else {
                    this.tableCell(null);
                }
            }
            this.sink.tableRow_();
        }

        private void renderContributor(Contributor contributor, int contributorRow, Map headersMap, StringBuffer javascript) {
            this.sink.tableRow();
            if (headersMap.get(NAME) == Boolean.TRUE) {
                this.tableCell(contributor.getName());
            }
            if (headersMap.get(EMAIL) == Boolean.TRUE) {
                this.tableCell(TeamListRenderer.createLinkPatternedText((String)contributor.getEmail(), (String)contributor.getEmail()));
            }
            if (headersMap.get(URL) == Boolean.TRUE) {
                this.tableCellForUrl(contributor.getUrl());
            }
            if (headersMap.get(ORGANIZATION) == Boolean.TRUE) {
                this.tableCell(contributor.getOrganization());
            }
            if (headersMap.get(ORGANIZATION_URL) == Boolean.TRUE) {
                this.tableCellForUrl(contributor.getOrganizationUrl());
            }
            if (headersMap.get(ROLES) == Boolean.TRUE) {
                if (contributor.getRoles() != null) {
                    this.tableCell(StringUtils.join((Object[])contributor.getRoles().toArray(EMPTY_STRING_ARRAY), (String)", "));
                } else {
                    this.tableCell(null);
                }
            }
            if (headersMap.get(TIME_ZONE) == Boolean.TRUE) {
                this.tableCell(contributor.getTimezone());
                this.sink.tableCell();
                this.sink.rawText("<span id=\"contributor-" + contributorRow + "\">");
                this.text(contributor.getTimezone());
                if (!StringUtils.isEmpty((String)contributor.getTimezone())) {
                    javascript.append("    offsetDate('contributor-").append(contributorRow).append("', '");
                    javascript.append(contributor.getTimezone());
                    javascript.append("');\n");
                }
                this.sink.rawText("</span>");
                this.sink.tableCell_();
            }
            if (headersMap.get(PROPERTIES) == Boolean.TRUE) {
                Properties props = contributor.getProperties();
                if (props != null) {
                    this.tableCell(TeamListRenderer.propertiesToString((Properties)props));
                } else {
                    this.tableCell(null);
                }
            }
            this.sink.tableRow_();
        }

        private String[] getRequiredContrHeaderArray(Map requiredHeaders) {
            ArrayList requiredArray = new ArrayList();
            String name = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.name");
            String email = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.email");
            String url = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.url");
            String organization = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.organization");
            String organizationUrl = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.organizationurl");
            String roles = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.roles");
            String timeZone = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.timezone");
            String actualTime = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.actualtime");
            String properties = this.i18n.getString("project-info-report", this.locale, "report.team-list.contributors.properties");
            this.setRequiredArray(requiredHeaders, requiredArray, name, email, url, organization, organizationUrl, roles, timeZone, actualTime, properties);
            String[] array = new String[requiredArray.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (String)requiredArray.get(i);
            }
            return array;
        }

        private String[] getRequiredDevHeaderArray(Map requiredHeaders) {
            ArrayList<String> requiredArray = new ArrayList<String>();
            String id = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.id");
            String name = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.name");
            String email = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.email");
            String url = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.url");
            String organization = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.organization");
            String organizationUrl = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.organizationurl");
            String roles = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.roles");
            String timeZone = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.timezone");
            String actualTime = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.actualtime");
            String properties = this.i18n.getString("project-info-report", this.locale, "report.team-list.developers.properties");
            if (requiredHeaders.get(ID) == Boolean.TRUE) {
                requiredArray.add(id);
            }
            this.setRequiredArray(requiredHeaders, requiredArray, name, email, url, organization, organizationUrl, roles, timeZone, actualTime, properties);
            String[] array = new String[requiredArray.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (String)requiredArray.get(i);
            }
            return array;
        }

        private void setRequiredArray(Map requiredHeaders, List requiredArray, String name, String email, String url, String organization, String organizationUrl, String roles, String timeZone, String actualTime, String properties) {
            if (requiredHeaders.get(NAME) == Boolean.TRUE) {
                requiredArray.add(name);
            }
            if (requiredHeaders.get(EMAIL) == Boolean.TRUE) {
                requiredArray.add(email);
            }
            if (requiredHeaders.get(URL) == Boolean.TRUE) {
                requiredArray.add(url);
            }
            if (requiredHeaders.get(ORGANIZATION) == Boolean.TRUE) {
                requiredArray.add(organization);
            }
            if (requiredHeaders.get(ORGANIZATION_URL) == Boolean.TRUE) {
                requiredArray.add(organizationUrl);
            }
            if (requiredHeaders.get(ROLES) == Boolean.TRUE) {
                requiredArray.add(roles);
            }
            if (requiredHeaders.get(TIME_ZONE) == Boolean.TRUE) {
                requiredArray.add(timeZone);
                requiredArray.add(actualTime);
            }
            if (requiredHeaders.get(PROPERTIES) == Boolean.TRUE) {
                requiredArray.add(properties);
            }
        }

        private void checkRequiredHeaders(Map requiredHeaders, List units) {
            requiredHeaders.put(ID, Boolean.FALSE);
            requiredHeaders.put(NAME, Boolean.FALSE);
            requiredHeaders.put(EMAIL, Boolean.FALSE);
            requiredHeaders.put(URL, Boolean.FALSE);
            requiredHeaders.put(ORGANIZATION, Boolean.FALSE);
            requiredHeaders.put(ORGANIZATION_URL, Boolean.FALSE);
            requiredHeaders.put(ROLES, Boolean.FALSE);
            requiredHeaders.put(TIME_ZONE, Boolean.FALSE);
            requiredHeaders.put(PROPERTIES, Boolean.FALSE);
            Iterator i = units.iterator();
            while (i.hasNext()) {
                Object unit = i.next();
                String name = null;
                String email = null;
                String url = null;
                String organization = null;
                String organizationUrl = null;
                List roles = null;
                String timeZone = null;
                Properties properties = null;
                if (unit.getClass().getName().equals((class$org$apache$maven$model$Contributor == null ? TeamListReport.class$("org.apache.maven.model.Contributor") : class$org$apache$maven$model$Contributor).getName())) {
                    Contributor contributor = (Contributor)unit;
                    name = contributor.getName();
                    email = contributor.getEmail();
                    url = contributor.getUrl();
                    organization = contributor.getOrganization();
                    organizationUrl = contributor.getOrganizationUrl();
                    roles = contributor.getRoles();
                    timeZone = contributor.getTimezone();
                    properties = contributor.getProperties();
                } else {
                    Developer developer = (Developer)unit;
                    name = developer.getName();
                    email = developer.getEmail();
                    url = developer.getUrl();
                    organization = developer.getOrganization();
                    organizationUrl = developer.getOrganizationUrl();
                    roles = developer.getRoles();
                    timeZone = developer.getTimezone();
                    properties = developer.getProperties();
                    if (StringUtils.isNotEmpty((String)developer.getId())) {
                        requiredHeaders.put(ID, Boolean.TRUE);
                    }
                }
                if (StringUtils.isNotEmpty((String)name)) {
                    requiredHeaders.put(NAME, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)email)) {
                    requiredHeaders.put(EMAIL, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)url)) {
                    requiredHeaders.put(URL, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)organization)) {
                    requiredHeaders.put(ORGANIZATION, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)organizationUrl)) {
                    requiredHeaders.put(ORGANIZATION_URL, Boolean.TRUE);
                }
                if (null != roles && !roles.isEmpty()) {
                    requiredHeaders.put(ROLES, Boolean.TRUE);
                }
                if (StringUtils.isNotEmpty((String)timeZone)) {
                    requiredHeaders.put(TIME_ZONE, Boolean.TRUE);
                }
                if (null == properties || properties.isEmpty()) continue;
                requiredHeaders.put(PROPERTIES, Boolean.TRUE);
            }
        }

        private void tableCellForUrl(String url) {
            this.sink.tableCell();
            if (StringUtils.isEmpty((String)url)) {
                this.text(url);
            } else {
                this.link(url, url);
            }
            this.sink.tableCell_();
        }
    }
}

