/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class PluginsReport
extends AbstractProjectInfoReport {
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;

    public void executeReport(Locale locale) {
        PluginsRenderer r = new PluginsRenderer(this.getLog(), this.getSink(), locale, this.i18n, this.project.getPluginArtifacts(), this.project.getReportArtifacts(), this.project, this.mavenProjectBuilder, this.artifactFactory, this.localRepository);
        r.render();
    }

    public String getOutputName() {
        return "plugins";
    }

    protected String getI18Nsection() {
        return "plugins";
    }

    public boolean canGenerateReport() {
        return this.project.getPluginArtifacts() != null && !this.project.getPluginArtifacts().isEmpty() || this.project.getReportArtifacts() != null && !this.project.getReportArtifacts().isEmpty();
    }

    protected static class PluginsRenderer
    extends AbstractProjectInfoRenderer {
        private final Log log;
        private final List plugins;
        private final List reports;
        private final MavenProject project;
        private final MavenProjectBuilder mavenProjectBuilder;
        private final ArtifactFactory artifactFactory;
        private final ArtifactRepository localRepository;

        public PluginsRenderer(Log log, Sink sink, Locale locale, I18N i18n, Set plugins, Set reports, MavenProject project, MavenProjectBuilder mavenProjectBuilder, ArtifactFactory artifactFactory, ArtifactRepository localRepository) {
            super(sink, i18n, locale);
            this.log = log;
            this.plugins = new ArrayList(plugins);
            this.reports = new ArrayList(reports);
            this.project = project;
            this.mavenProjectBuilder = mavenProjectBuilder;
            this.artifactFactory = artifactFactory;
            this.localRepository = localRepository;
        }

        protected String getI18Nsection() {
            return "plugins";
        }

        public void renderBody() {
            this.renderSectionPlugins(true);
            this.renderSectionPlugins(false);
        }

        private void renderSectionPlugins(boolean isPlugins) {
            List list = isPlugins ? this.plugins : this.reports;
            String[] tableHeader = this.getPluginTableHeader();
            this.startSection(isPlugins ? this.getI18nString("title") : this.getI18nString("report.title"));
            if (list == null || list.isEmpty()) {
                this.paragraph(isPlugins ? this.getI18nString("nolist") : this.getI18nString("report.nolist"));
                this.endSection();
                return;
            }
            Collections.sort(list, this.getArtifactComparator());
            this.startTable();
            this.tableHeader(tableHeader);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                VersionRange versionRange = StringUtils.isEmpty((String)artifact.getVersion()) ? VersionRange.createFromVersion((String)"RELEASE") : VersionRange.createFromVersion((String)artifact.getVersion());
                Artifact pluginArtifact = this.artifactFactory.createParentArtifact(artifact.getGroupId(), artifact.getArtifactId(), versionRange.toString());
                ArrayList artifactRepositories = this.project.getPluginArtifactRepositories();
                if (artifactRepositories == null) {
                    artifactRepositories = new ArrayList();
                }
                try {
                    MavenProject pluginProject = this.mavenProjectBuilder.buildFromRepository(pluginArtifact, artifactRepositories, this.localRepository);
                    this.tableRow(this.getPluginRow(pluginProject.getGroupId(), pluginProject.getArtifactId(), pluginProject.getVersion(), pluginProject.getUrl()));
                }
                catch (ProjectBuildingException e) {
                    this.log.info((CharSequence)("Could not build project for: " + artifact.getArtifactId() + ":" + e.getMessage()), (Throwable)e);
                    this.tableRow(this.getPluginRow(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null));
                }
            }
            this.endTable();
            this.endSection();
        }

        private String[] getPluginTableHeader() {
            String groupId = this.getI18nString("dependencyManagement", "column.groupId");
            String artifactId = this.getI18nString("dependencyManagement", "column.artifactId");
            String version = this.getI18nString("dependencyManagement", "column.version");
            return new String[]{groupId, artifactId, version};
        }

        private String[] getPluginRow(String groupId, String artifactId, String version, String link) {
            artifactId = ProjectInfoReportUtils.getArtifactIdCell(artifactId, link);
            return new String[]{groupId, artifactId, version};
        }

        private Comparator getArtifactComparator() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    Artifact a1 = (Artifact)o1;
                    Artifact a2 = (Artifact)o2;
                    int result = a1.getGroupId().compareTo(a2.getGroupId());
                    if (result == 0) {
                        result = a1.getArtifactId().compareTo(a2.getArtifactId());
                    }
                    return result;
                }
            };
        }
    }
}

