/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ModulesReport
extends AbstractProjectInfoReport {
    public void executeReport(Locale locale) {
        new ModulesRenderer(this.getSink(), this.getProject().getModel(), this.getI18N(locale), locale).render();
    }

    public String getOutputName() {
        return "modules";
    }

    protected String getI18Nsection() {
        return "modules";
    }

    public boolean canGenerateReport() {
        return this.getProject().getModel().getModules() != null && !this.getProject().getModel().getModules().isEmpty();
    }

    private String getRelativeLink(String baseUrl, String href, String defaultHref) {
        String selectedHref = href;
        if (selectedHref == null) {
            selectedHref = defaultHref;
        }
        if (baseUrl != null) {
            selectedHref = this.siteTool.getRelativePath(selectedHref, baseUrl);
        }
        selectedHref = selectedHref.endsWith("/") ? selectedHref.concat("index.html") : selectedHref.concat("/index.html");
        return selectedHref;
    }

    private String linkedName(String name, String link) {
        return "{" + name + ", ./" + link + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model readModel(File pom) {
        MavenXpp3Reader xpp3 = new MavenXpp3Reader();
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pom);
            Model model = xpp3.read((Reader)reader);
            return model;
        }
        catch (IOException io) {
            this.getLog().debug((Throwable)io);
            Model model = null;
            return model;
        }
        catch (XmlPullParserException xe) {
            this.getLog().debug((Throwable)xe);
            Model model = null;
            return model;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private class ModulesRenderer
    extends AbstractProjectInfoRenderer {
        private Model model;

        ModulesRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink, i18n, locale);
            this.model = model;
        }

        protected String getI18Nsection() {
            return "modules";
        }

        public void renderBody() {
            List modules = this.model.getModules();
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("intro"));
            this.startTable();
            String name = this.getI18nString("header.name");
            String description = this.getI18nString("header.description");
            this.tableHeader(new String[]{name, description});
            for (String module : modules) {
                Model moduleModel;
                File f = new File(ModulesReport.this.project.getBasedir(), module + "/pom.xml");
                if (f.exists()) {
                    moduleModel = ModulesReport.this.readModel(f);
                    if (moduleModel == null) {
                        ModulesReport.this.getLog().warn((CharSequence)("Unable to read filesystem POM for module " + module));
                        moduleModel = new Model();
                        moduleModel.setName(module);
                        moduleModel.setArtifactId(module);
                    }
                } else {
                    ModulesReport.this.getLog().warn((CharSequence)("No filesystem POM found for module " + module));
                    moduleModel = new Model();
                    moduleModel.setName(module);
                    moduleModel.setArtifactId(module);
                }
                String moduleName = moduleModel.getName();
                String baseURL = this.model.getUrl();
                Model parentModel = ModulesReport.this.readModel(new File(ModulesReport.this.project.getBasedir(), "pom.xml"));
                if (parentModel != null) {
                    baseURL = parentModel.getUrl();
                }
                String moduleHref = ModulesReport.this.getRelativeLink(baseURL, moduleModel.getUrl(), moduleModel.getArtifactId());
                this.tableRow(new String[]{ModulesReport.this.linkedName(moduleName, moduleHref), moduleModel.getDescription()});
            }
            this.endTable();
            this.endSection();
        }
    }
}

