/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.UrlValidator;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.HtmlTools;
import org.apache.maven.model.License;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="license")
public class LicenseReport
extends AbstractProjectInfoReport {
    @Component
    private Settings settings;
    @Parameter(property="settings.offline")
    private boolean offline;
    @Parameter(defaultValue="false")
    private boolean linkOnly;

    public void executeReport(Locale locale) {
        LicenseRenderer r = new LicenseRenderer(this.getSink(), this.getProject(), this.getI18N(locale), locale, this.settings, this.linkOnly);
        r.render();
    }

    public boolean canGenerateReport() {
        if (!this.offline) {
            return true;
        }
        for (License license : this.project.getModel().getLicenses()) {
            String url = license.getUrl();
            URL licenseUrl = null;
            try {
                licenseUrl = LicenseReport.getLicenseURL(this.project, url);
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)e.getMessage());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)e.getMessage());
            }
            if (licenseUrl != null && licenseUrl.getProtocol().equals("file")) {
                return true;
            }
            if (licenseUrl == null || !licenseUrl.getProtocol().equals("http") && !licenseUrl.getProtocol().equals("https")) continue;
            this.linkOnly = true;
            return true;
        }
        return false;
    }

    public String getOutputName() {
        return "license";
    }

    protected String getI18Nsection() {
        return "license";
    }

    protected static URL getLicenseURL(MavenProject project, String url) throws IOException {
        URL licenseUrl = null;
        UrlValidator urlValidator = new UrlValidator(1);
        if (urlValidator.isValid(url) || StringUtils.defaultString((Object)url).startsWith("file://")) {
            try {
                licenseUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new MalformedURLException("The license url '" + url + "' seems to be invalid: " + e.getMessage());
            }
        }
        File licenseFile = new File(project.getBasedir(), url);
        if (!licenseFile.exists()) {
            licenseFile = new File(url);
        }
        if (!licenseFile.exists()) {
            throw new IOException("Maven can't find the file '" + licenseFile + "' on the system.");
        }
        try {
            licenseUrl = licenseFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException("The license url '" + url + "' seems to be invalid: " + e.getMessage());
        }
        return licenseUrl;
    }

    private static class LicenseRenderer
    extends AbstractProjectInfoRenderer {
        private final MavenProject project;
        private final Settings settings;
        private final boolean linkOnly;

        LicenseRenderer(Sink sink, MavenProject project, I18N i18n, Locale locale, Settings settings, boolean linkOnly) {
            super(sink, i18n, locale);
            this.project = project;
            this.settings = settings;
            this.linkOnly = linkOnly;
        }

        protected String getI18Nsection() {
            return "license";
        }

        public void renderBody() {
            String name;
            List licenses = this.project.getModel().getLicenses();
            if (licenses.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nolicense"));
                this.endSection();
                return;
            }
            this.startSection(this.getI18nString("overview.title"));
            this.paragraph(this.getI18nString("overview.intro"));
            this.endSection();
            this.startSection(this.getI18nString("title"));
            if (licenses.size() > 1) {
                this.paragraph(this.getI18nString("multiple"));
                if (!this.linkOnly) {
                    this.sink.list();
                    for (License license : licenses) {
                        name = license.getName();
                        this.sink.listItem();
                        this.link("#" + HtmlTools.encodeId((String)name), name);
                        this.sink.listItem_();
                    }
                    this.sink.list_();
                }
            }
            for (License license : licenses) {
                name = license.getName();
                String url = license.getUrl();
                String comments = license.getComments();
                this.startSection(name);
                if (!StringUtils.isEmpty((String)comments)) {
                    this.paragraph(comments);
                }
                if (url != null) {
                    try {
                        URL licenseUrl = LicenseReport.getLicenseURL(this.project, url);
                        if (this.linkOnly) {
                            this.link(licenseUrl.toExternalForm(), licenseUrl.toExternalForm());
                        } else {
                            this.renderLicenseContent(licenseUrl);
                        }
                    }
                    catch (MalformedURLException e) {
                        this.paragraph(e.getMessage());
                    }
                    catch (IOException e) {
                        this.paragraph(e.getMessage());
                    }
                }
                this.endSection();
            }
            this.endSection();
        }

        private void renderLicenseContent(URL licenseUrl) {
            try {
                String licenseContent = ProjectInfoReportUtils.getContent(licenseUrl, this.settings);
                String licenseContentLC = licenseContent.toLowerCase(Locale.ENGLISH);
                int bodyStart = licenseContentLC.indexOf("<body");
                int bodyEnd = licenseContentLC.indexOf("</body>");
                if ((licenseContentLC.contains("<!doctype html") || licenseContentLC.contains("<html>")) && bodyStart >= 0 && bodyEnd > bodyStart) {
                    bodyStart = licenseContentLC.indexOf(">", bodyStart) + 1;
                    String body = licenseContent.substring(bodyStart, bodyEnd);
                    this.link(licenseUrl.toExternalForm(), "[Original text]");
                    this.paragraph("Copy of the license follows.");
                    body = LicenseRenderer.replaceRelativeLinks(body, LicenseRenderer.baseURL(licenseUrl).toExternalForm());
                    this.sink.rawText(body);
                } else {
                    this.verbatimText(licenseContent);
                }
            }
            catch (IOException e) {
                this.paragraph("Can't read the url [" + licenseUrl + "] : " + e.getMessage());
            }
        }

        private static URL baseURL(URL aUrl) {
            String urlTxt = aUrl.toExternalForm();
            int lastSlash = urlTxt.lastIndexOf(47);
            if (lastSlash > -1) {
                try {
                    return new URL(urlTxt.substring(0, lastSlash + 1));
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return aUrl;
        }

        private static String replaceRelativeLinks(String html, String baseURL) {
            String url = baseURL;
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            String serverURL = url.substring(0, url.indexOf(47, url.indexOf("//") + 2));
            String content = LicenseRenderer.replaceParts(html, url, serverURL, "[aA]", "[hH][rR][eE][fF]");
            content = LicenseRenderer.replaceParts(content, url, serverURL, "[iI][mM][gG]", "[sS][rR][cC]");
            return content;
        }

        private static String replaceParts(String html, String baseURL, String serverURL, String tagPattern, String attributePattern) {
            Pattern anchor = Pattern.compile("(<\\s*" + tagPattern + "\\s+[^>]*" + attributePattern + "\\s*=\\s*\")([^\"]*)\"([^>]*>)");
            StringBuffer sb = new StringBuffer(html);
            int indx = 0;
            boolean done = false;
            while (!done) {
                Matcher mAnchor = anchor.matcher(sb);
                if (mAnchor.find(indx)) {
                    indx = mAnchor.end(3);
                    if (mAnchor.group(2).startsWith("#")) {
                        // empty if block
                    }
                    if (mAnchor.group(2).startsWith("/")) {
                        sb.insert(mAnchor.start(2), serverURL);
                        indx += serverURL.length();
                        continue;
                    }
                    if (mAnchor.group(2).indexOf(58) >= 0) continue;
                    sb.insert(mAnchor.start(2), baseURL);
                    indx += baseURL.length();
                    continue;
                }
                done = true;
            }
            return sb.toString();
        }
    }
}

