/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.reactor;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;

class RelativePather {
    RelativePather() {
    }

    public static String getRelativePath(File context, File dest) {
        boolean pathsDiffer;
        String destChunk;
        Iterator destChunker;
        int count;
        LinkedList contextChunks;
        block8: {
            contextChunks = RelativePather.getPathChunks(context);
            LinkedList destChunks = RelativePather.getPathChunks(dest);
            if (!contextChunks.getFirst().equals(destChunks.getFirst())) {
                throw new DifferentRootsException("Roots differ");
            }
            count = 0;
            Iterator contextChunker = contextChunks.iterator();
            destChunker = destChunks.iterator();
            String contextChunk = (String)contextChunker.next();
            destChunk = (String)destChunker.next();
            pathsDiffer = false;
            do {
                ++count;
                if (!contextChunker.hasNext() || !destChunker.hasNext()) break block8;
            } while ((contextChunk = (String)contextChunker.next()).equals(destChunk = (String)destChunker.next()));
            pathsDiffer = true;
        }
        StringBuffer relativePath = new StringBuffer();
        if (count < contextChunks.size()) {
            int dotDotCount = contextChunks.size() - count;
            for (int i = 0; i < dotDotCount; ++i) {
                relativePath.append("..");
                if (i >= dotDotCount - 1) continue;
                relativePath.append(File.separatorChar);
            }
        }
        if (pathsDiffer) {
            if (relativePath.length() > 0) {
                relativePath.append(File.separatorChar);
            }
            relativePath.append(destChunk);
        }
        while (destChunker.hasNext()) {
            if (relativePath.length() > 0) {
                relativePath.append(File.separatorChar);
            }
            relativePath.append(destChunker.next());
        }
        return relativePath.toString();
    }

    private static LinkedList getPathChunks(File f) {
        LinkedList<String> l = new LinkedList<String>();
        while (f.getParentFile() != null) {
            l.addFirst(f.getName());
            f = f.getParentFile();
        }
        l.addFirst(f.getAbsolutePath());
        return l;
    }

    static class DifferentRootsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DifferentRootsException() {
        }

        public DifferentRootsException(String message, Throwable cause) {
            super(message, cause);
        }

        public DifferentRootsException(String message) {
            super(message);
        }

        public DifferentRootsException(Throwable cause) {
            super(cause);
        }
    }
}

