/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseUtils;

public class PrepareReleaseMojo
extends AbstractReleaseMojo {
    private boolean resume;
    private boolean generateReleasePoms;
    private boolean useEditMode;
    private boolean updateDependencies;
    private boolean autoVersionSubmodules;
    private boolean dryRun;
    private boolean addSchema;
    private String preparationGoals;
    private String completionGoals;
    private boolean commitByProject;
    private boolean allowTimestampedSnapshots;
    private boolean allowReleasePluginSnapshot;
    private String[] checkModificationExcludes;
    private String checkModificationExcludeList;
    private String releaseVersion;
    private String developmentVersion;
    private boolean remoteTagging;
    private boolean updateWorkingCopyVersions;
    private boolean suppressCommitBeforeTag;
    private int waitBeforeTagging;
    protected MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.generateReleasePoms) {
            throw new MojoFailureException("Generating release POMs is no longer supported in release:prepare. Please run release:prepare-with-pom instead.");
        }
        this.prepareRelease(this.generateReleasePoms);
    }

    protected void prepareRelease(boolean generateReleasePoms) throws MojoExecutionException, MojoFailureException {
        super.execute();
        ReleaseDescriptor config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setGenerateReleasePoms(generateReleasePoms);
        config.setScmUseEditMode(this.useEditMode);
        config.setPreparationGoals(this.preparationGoals);
        config.setCompletionGoals(this.completionGoals);
        config.setCommitByProject(this.commitByProject);
        config.setUpdateDependencies(this.updateDependencies);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setAllowTimestampedSnapshots(this.allowTimestampedSnapshots);
        config.setSnapshotReleasePluginAllowed(this.allowReleasePluginSnapshot);
        config.setDefaultReleaseVersion(this.releaseVersion);
        config.setDefaultDevelopmentVersion(this.developmentVersion);
        config.setRemoteTagging(this.remoteTagging);
        config.setUpdateWorkingCopyVersions(this.updateWorkingCopyVersions);
        config.setSuppressCommitBeforeTagOrBranch(this.suppressCommitBeforeTag);
        config.setWaitBeforeTagging(this.waitBeforeTagging);
        if (this.checkModificationExcludeList != null) {
            this.checkModificationExcludes = this.checkModificationExcludeList.replaceAll("\\s", "").split(",");
        }
        if (this.checkModificationExcludes != null) {
            config.setCheckModificationExcludes(Arrays.asList(this.checkModificationExcludes));
        }
        ReleaseDescriptor sysPropertiesConfig = ReleaseUtils.copyPropertiesToReleaseDescriptor((Properties)this.session.getExecutionProperties());
        this.mergeCommandLineConfig(config, sysPropertiesConfig);
        try {
            this.releaseManager.prepare(config, this.getReleaseEnvironment(), this.reactorProjects, this.resume, this.dryRun);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

