/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseUtils;

public class BranchReleaseMojo
extends AbstractReleaseMojo {
    private String branchName;
    private String branchBase;
    private boolean updateBranchVersions;
    private boolean updateWorkingCopyVersions;
    private boolean suppressCommitBeforeBranch;
    private boolean updateVersionsToSnapshot;
    private boolean useEditMode;
    private boolean updateDependencies;
    private boolean autoVersionSubmodules;
    private boolean dryRun;
    private boolean addSchema;
    private boolean remoteTagging;
    private String[] checkModificationExcludes;
    private String checkModificationExcludeList;
    private String releaseVersion;
    private String developmentVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ReleaseDescriptor config = this.createReleaseDescriptor();
        config.setAddSchema(this.addSchema);
        config.setScmUseEditMode(this.useEditMode);
        config.setUpdateDependencies(this.updateDependencies);
        config.setAutoVersionSubmodules(this.autoVersionSubmodules);
        config.setScmReleaseLabel(this.branchName);
        config.setScmBranchBase(this.branchBase);
        config.setBranchCreation(true);
        config.setUpdateBranchVersions(this.updateBranchVersions);
        config.setUpdateWorkingCopyVersions(this.updateWorkingCopyVersions);
        config.setUpdateVersionsToSnapshot(this.updateVersionsToSnapshot);
        config.setRemoteTagging(this.remoteTagging);
        config.setDefaultReleaseVersion(this.releaseVersion);
        config.setDefaultDevelopmentVersion(this.developmentVersion);
        config.setSuppressCommitBeforeTagOrBranch(this.suppressCommitBeforeBranch);
        ReleaseDescriptor sysPropertiesConfig = ReleaseUtils.copyPropertiesToReleaseDescriptor((Properties)this.session.getExecutionProperties());
        this.mergeCommandLineConfig(config, sysPropertiesConfig);
        if (this.checkModificationExcludeList != null) {
            this.checkModificationExcludes = this.checkModificationExcludeList.replaceAll("\\s", "").split(",");
        }
        if (this.checkModificationExcludes != null) {
            config.setCheckModificationExcludes(Arrays.asList(this.checkModificationExcludes));
        }
        try {
            this.releaseManager.branch(config, this.getReleaseEnvironment(), this.getReactorProjects(), this.dryRun);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

