/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources.remote;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.resources.remote.RemoteResourcesBundle;
import org.apache.maven.plugin.resources.remote.RemoteResourcesClassLoader;
import org.apache.maven.plugin.resources.remote.Supplement;
import org.apache.maven.plugin.resources.remote.SupplementalDataModel;
import org.apache.maven.plugin.resources.remote.io.xpp3.RemoteResourcesBundleXpp3Reader;
import org.apache.maven.plugin.resources.remote.io.xpp3.SupplementalDataModelXpp3Reader;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.downloader.DownloadException;
import org.apache.maven.shared.downloader.DownloadNotFoundException;
import org.apache.maven.shared.downloader.Downloader;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;

public class ProcessRemoteResourcesMojo
extends AbstractMojo {
    private ArtifactRepository localRepository;
    private List repositories;
    private List remoteArtifactRepositories;
    private MavenProject project;
    private File outputDirectory;
    private File appendedResourcesDirectory;
    private String[] supplementalModels;
    private Map supplementModels;
    private ModelInheritanceAssembler inheritanceAssembler;
    private List resourceBundles;
    private boolean skip;
    private Map properties = new HashMap();
    private List resources;
    private Downloader downloader;
    private VelocityComponent velocity;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactFactory artifactFactory;
    private MavenSession mavenSession;
    private MavenProjectBuilder mavenProjectBuilder;
    private ResourceManager locator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        File sups;
        if (this.skip) {
            return;
        }
        if (this.supplementalModels == null && (sups = new File(this.appendedResourcesDirectory, "supplemental-models.xml")).exists()) {
            try {
                this.supplementalModels = new String[]{sups.toURL().toString()};
            }
            catch (MalformedURLException e) {
                this.getLog().debug((CharSequence)("URL issue with supplemental-models.xml: " + e.toString()));
            }
        }
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        if (this.appendedResourcesDirectory != null) {
            this.locator.addSearchPath("file", this.appendedResourcesDirectory.getAbsolutePath());
        }
        this.locator.addSearchPath("url", "");
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.validate();
            List resourceBundleArtifacts = this.downloadResourceBundles(this.resourceBundles);
            this.supplementModels = this.loadSupplements(this.supplementalModels);
            VelocityContext context = new VelocityContext(this.properties);
            this.configureVelocityContext(context);
            RemoteResourcesClassLoader classLoader = new RemoteResourcesClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.initalizeClassloader(classLoader, resourceBundleArtifacts);
            Thread.currentThread().setContextClassLoader(classLoader);
            this.processResourceBundles(classLoader, context);
            try {
                if (this.outputDirectory.exists()) {
                    Resource resource = new Resource();
                    resource.setDirectory(this.outputDirectory.getAbsolutePath());
                    this.project.getResources().add(resource);
                    this.project.getTestResources().add(resource);
                    File dotFile = new File(this.project.getBuild().getDirectory(), ".plxarc");
                    FileUtils.mkdir((String)dotFile.getParentFile().getAbsolutePath());
                    FileUtils.fileWrite((String)dotFile.getAbsolutePath(), (String)this.outputDirectory.getName());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating dot file for archiving instructions.", (Exception)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    protected List getProjects() throws MojoExecutionException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        Iterator it = this.project.getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            try {
                List remoteRepo = this.repositories;
                if (artifact.isSnapshot()) {
                    VersionRange rng = VersionRange.createFromVersion((String)artifact.getBaseVersion());
                    artifact = this.artifactFactory.createDependencyArtifact(artifact.getGroupId(), artifact.getArtifactId(), rng, artifact.getType(), artifact.getClassifier(), artifact.getScope(), null, artifact.isOptional());
                    remoteRepo = this.remoteArtifactRepositories;
                }
                this.getLog().debug((CharSequence)("Building project for " + artifact));
                MavenProject p = null;
                try {
                    p = this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepo, this.localRepository, true);
                }
                catch (InvalidProjectModelException e) {
                    this.getLog().warn((CharSequence)("Invalid project model for artifact [" + artifact.getArtifactId() + ":" + artifact.getGroupId() + ":" + artifact.getVersion() + "]. " + "It will be ignored by the remote resources Mojo."));
                    continue;
                }
                String supplementKey = ProcessRemoteResourcesMojo.generateSupplementMapKey(p.getModel().getGroupId(), p.getModel().getArtifactId());
                if (this.supplementModels.containsKey(supplementKey)) {
                    Model mergedModel = this.mergeModels(p.getModel(), (Model)this.supplementModels.get(supplementKey));
                    MavenProject mergedProject = new MavenProject(mergedModel);
                    projects.add(mergedProject);
                    mergedProject.setArtifact(artifact);
                    mergedProject.setVersion(artifact.getVersion());
                    this.getLog().debug((CharSequence)("Adding project with groupId [" + mergedProject.getGroupId() + "] (supplemented)"));
                    continue;
                }
                projects.add(p);
                this.getLog().debug((CharSequence)("Adding project with groupId [" + p.getGroupId() + "]"));
            }
            catch (ProjectBuildingException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(projects, new ProjectComparator());
        return projects;
    }

    protected Map getProjectsSortedByOrganization(List projects) throws MojoExecutionException {
        TreeMap organizations = new TreeMap(new OrganizationComparator());
        ArrayList<MavenProject> unknownOrganization = new ArrayList<MavenProject>();
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            MavenProject p = (MavenProject)i.next();
            if (p.getOrganization() != null && StringUtils.isNotEmpty((String)p.getOrganization().getName())) {
                ArrayList<MavenProject> sortedProjects = (ArrayList<MavenProject>)organizations.get(p.getOrganization());
                if (sortedProjects == null) {
                    sortedProjects = new ArrayList<MavenProject>();
                }
                sortedProjects.add(p);
                organizations.put(p.getOrganization(), sortedProjects);
                continue;
            }
            unknownOrganization.add(p);
        }
        if (!unknownOrganization.isEmpty()) {
            Organization unknownOrg = new Organization();
            unknownOrg.setName("an unknown organization");
            organizations.put(unknownOrg, unknownOrganization);
        }
        return organizations;
    }

    protected boolean copyResourceIfExists(File file, String relFileName) throws IOException {
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            File source;
            Resource resource = (Resource)i.next();
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.exists() || !(source = new File(resourceDirectory, relFileName)).exists() || source.equals(file)) continue;
            FileUtils.copyFile((File)source, (File)file);
            resource.addExclude(relFileName);
            return true;
        }
        return false;
    }

    protected void validate() throws MojoExecutionException {
        int bundleCount = 1;
        Iterator i = this.resourceBundles.iterator();
        while (i.hasNext()) {
            String artifactDescriptor = (String)i.next();
            String[] s = StringUtils.split((String)artifactDescriptor, (String)":");
            if (s.length != 3) {
                String position = bundleCount == 1 ? "1st" : (bundleCount == 2 ? "2nd" : (bundleCount == 3 ? "3rd" : bundleCount + "th"));
                throw new MojoExecutionException("The " + position + " resource bundle configured must specify a groupId, artifactId, and" + " version for a remote resource bundle. " + "Must be of the form <resourceBundle>groupId:artifactId:version</resourceBundle>");
            }
            ++bundleCount;
        }
    }

    protected void configureVelocityContext(VelocityContext context) throws MojoExecutionException {
        String inceptionYear = this.project.getInceptionYear();
        String year = new SimpleDateFormat("yyyy").format(new Date());
        if (StringUtils.isEmpty((String)inceptionYear)) {
            this.getLog().info((CharSequence)("inceptionYear not specified, defaulting to " + year));
            inceptionYear = year;
        }
        context.put("project", (Object)this.project);
        List projects = this.getProjects();
        context.put("projects", (Object)projects);
        context.put("projectsSortedByOrganization", (Object)this.getProjectsSortedByOrganization(projects));
        context.put("presentYear", (Object)year);
        if (inceptionYear.equals(year)) {
            context.put("projectTimespan", (Object)year);
        } else {
            context.put("projectTimespan", (Object)(inceptionYear + "-" + year));
        }
    }

    private List downloadResourceBundles(List resourceBundles) throws MojoExecutionException {
        ArrayList<File> resourceBundleArtifacts = new ArrayList<File>();
        try {
            Iterator i = resourceBundles.iterator();
            while (i.hasNext()) {
                String artifactDescriptor = (String)i.next();
                String[] s = artifactDescriptor.split(":");
                File artifact = this.downloader.download(s[0], s[1], s[2], this.localRepository, ProjectUtils.buildArtifactRepositories((List)this.repositories, (ArtifactRepositoryFactory)this.artifactRepositoryFactory, (PlexusContainer)this.mavenSession.getContainer()));
                resourceBundleArtifacts.add(artifact);
            }
        }
        catch (DownloadException e) {
            throw new MojoExecutionException("Error downloading resources JAR.", (Exception)((Object)e));
        }
        catch (DownloadNotFoundException e) {
            throw new MojoExecutionException("Resources JAR cannot be found.", (Exception)((Object)e));
        }
        catch (InvalidRepositoryException e) {
            throw new MojoExecutionException("Resources JAR cannot be found.", (Exception)((Object)e));
        }
        return resourceBundleArtifacts;
    }

    private void initalizeClassloader(RemoteResourcesClassLoader cl, List artifacts) throws MojoExecutionException {
        try {
            Iterator i = artifacts.iterator();
            while (i.hasNext()) {
                File artifact = (File)i.next();
                cl.addURL(artifact.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to configure resources classloader: " + e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResourceBundles(RemoteResourcesClassLoader classLoader, VelocityContext context) throws MojoExecutionException {
        InputStreamReader reader = null;
        try {
            Enumeration<URL> e = classLoader.getResources("META-INF/maven/remote-resources.xml");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                URLConnection conn = url.openConnection();
                conn.connect();
                reader = new InputStreamReader(conn.getInputStream());
                try {
                    RemoteResourcesBundleXpp3Reader bundleReader = new RemoteResourcesBundleXpp3Reader();
                    RemoteResourcesBundle bundle = bundleReader.read(reader);
                    Iterator i = bundle.getRemoteResources().iterator();
                    while (i.hasNext()) {
                        String bundleResource;
                        String projectResource = bundleResource = (String)i.next();
                        boolean doVelocity = false;
                        if (projectResource.endsWith(".vm")) {
                            projectResource = projectResource.substring(0, projectResource.length() - 3);
                            doVelocity = true;
                        }
                        File f = new File(this.outputDirectory, projectResource);
                        FileUtils.mkdir((String)f.getParentFile().getAbsolutePath());
                        if (this.copyResourceIfExists(f, projectResource)) continue;
                        if (doVelocity) {
                            PrintWriter writer = new PrintWriter(new FileWriter(f));
                            try {
                                this.velocity.getEngine().mergeTemplate(bundleResource, (Context)context, (Writer)writer);
                                File appendedResourceFile = new File(this.appendedResourcesDirectory, projectResource);
                                if (!appendedResourceFile.exists()) continue;
                                FileReader freader = new FileReader(appendedResourceFile);
                                BufferedReader breader = new BufferedReader(freader);
                                String line = breader.readLine();
                                while (line != null) {
                                    writer.println(line);
                                    line = breader.readLine();
                                }
                                continue;
                            }
                            finally {
                                writer.close();
                                continue;
                            }
                        }
                        URL resUrl = classLoader.getResource(bundleResource);
                        if (resUrl == null) continue;
                        FileUtils.copyURLToFile((URL)resUrl, (File)f);
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error finding remote resources manifests", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing remote resource bundle descriptor.", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error rendering velocity resource.", e);
        }
    }

    protected Model getSupplement(Xpp3Dom supplementModelXml) throws MojoExecutionException {
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = modelReader.read((Reader)new StringReader(supplementModelXml.toString()));
            String groupId = model.getGroupId();
            String artifactId = model.getArtifactId();
            if (groupId == null || groupId.trim().equals("")) {
                throw new MojoExecutionException("Supplemental project XML requires that a <groupId> element be present.");
            }
            if (artifactId == null || artifactId.trim().equals("")) {
                throw new MojoExecutionException("Supplemental project XML requires that a <artifactId> element be present.");
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to read supplemental XML: " + e.getMessage()), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            this.getLog().warn((CharSequence)("Unable to parse supplemental XML: " + e.getMessage()), (Throwable)e);
        }
        return model;
    }

    protected Model mergeModels(Model parent, Model child) {
        this.inheritanceAssembler.assembleModelInheritance(child, parent);
        return child;
    }

    private static String generateSupplementMapKey(String groupId, String artifactId) {
        return groupId.trim() + ":" + artifactId.trim();
    }

    private Map loadSupplements(String[] models) throws MojoExecutionException {
        if (models == null) {
            this.getLog().debug((CharSequence)"Supplemental data models won't be loaded.  No models specified.");
            return Collections.EMPTY_MAP;
        }
        ArrayList supplements = new ArrayList();
        for (int idx = 0; idx < models.length; ++idx) {
            String set = models[idx];
            this.getLog().debug((CharSequence)("Preparing ruleset: " + set));
            try {
                File f = this.locator.getResourceAsFile(set, this.getLocationTemp(set));
                if (null == f || !f.exists()) {
                    throw new MavenReportException("Cold not resolve " + set);
                }
                if (!f.canRead()) {
                    throw new MavenReportException("Supplemental data models won't be loaded. File " + f.getAbsolutePath() + " cannot be read, check permissions on the file.");
                }
                this.getLog().debug((CharSequence)("Loading supplemental models from " + f.getAbsolutePath()));
                SupplementalDataModelXpp3Reader reader = new SupplementalDataModelXpp3Reader();
                SupplementalDataModel supplementalModel = reader.read(new FileReader(f));
                supplements.addAll(supplementalModel.getSupplement());
                continue;
            }
            catch (Exception e) {
                String msg = "Error loading supplemental data models: " + e.getMessage();
                this.getLog().error((CharSequence)msg, (Throwable)e);
                throw new MojoExecutionException(msg, e);
            }
        }
        this.getLog().debug((CharSequence)"Loading supplements complete.");
        HashMap<String, Model> supplementMap = new HashMap<String, Model>();
        Iterator i = supplements.iterator();
        while (i.hasNext()) {
            Supplement sd = (Supplement)i.next();
            Xpp3Dom dom = (Xpp3Dom)sd.getProject();
            Model m = this.getSupplement(dom);
            supplementMap.put(ProcessRemoteResourcesMojo.generateSupplementMapKey(m.getGroupId(), m.getArtifactId()), m);
        }
        return supplementMap;
    }

    private String getLocationTemp(String name) {
        String loc = name;
        if (loc.indexOf(47) != -1) {
            loc = loc.substring(loc.lastIndexOf(47) + 1);
        }
        if (loc.indexOf(92) != -1) {
            loc = loc.substring(loc.lastIndexOf(92) + 1);
        }
        this.getLog().debug((CharSequence)("Before: " + name + " After: " + loc));
        return loc;
    }

    class ProjectComparator
    implements Comparator {
        ProjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            MavenProject p1 = (MavenProject)o1;
            MavenProject p2 = (MavenProject)o2;
            return p1.getArtifact().compareTo(p2.getArtifact());
        }

        public boolean equals(Object o1, Object o2) {
            MavenProject p1 = (MavenProject)o1;
            MavenProject p2 = (MavenProject)o2;
            return p1.getArtifact().equals(p2.getArtifact());
        }
    }

    class OrganizationComparator
    implements Comparator {
        OrganizationComparator() {
        }

        public int compare(Object o1, Object o2) {
            Organization org1 = (Organization)o1;
            Organization org2 = (Organization)o2;
            int i = this.compareStrings(org1.getName(), org2.getName());
            if (i == 0) {
                i = this.compareStrings(org1.getUrl(), org2.getUrl());
            }
            return i;
        }

        public boolean equals(Object o1, Object o2) {
            return this.compare(o1, o2) == 0;
        }

        private int compareStrings(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return 1;
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

