/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.repository;

import java.io.File;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.StringUtils;

public class BundleCreateMojo
extends AbstractMojo {
    public static final String POM = "pom.xml";
    private String basedir;
    private MavenProject project;
    private JarArchiver jarArchiver;
    private ArtifactHandlerManager artifactHandlerManager;

    public void execute() throws MojoExecutionException {
        if (this.project.getPackaging().equals("pom")) {
            throw new MojoExecutionException("Packaging cannot be 'pom' when creating an upload bundle.");
        }
        this.validate(this.project.getName(), "project.name");
        this.validate(this.project.getDescription(), "project.description");
        this.validate(this.project.getUrl(), "project.url");
        if (this.project.getLicenses().isEmpty()) {
            throw new MojoExecutionException("At least one license must be defined.");
        }
        File pom = new File(this.basedir, POM);
        String finalName = this.project.getBuild().getFinalName();
        String outputDirectory = this.project.getBuild().getDirectory();
        String extension = this.artifactHandlerManager.getArtifactHandler(this.project.getPackaging()).getExtension();
        File artifact = new File(outputDirectory, finalName + "." + extension);
        File sourceArtifact = new File(outputDirectory, finalName + "-sources." + extension);
        File javadocArtifact = new File(outputDirectory, finalName + "-javadoc." + extension);
        File bundle = new File(outputDirectory, finalName + "-bundle.jar");
        try {
            this.jarArchiver.addFile(pom, POM);
            this.jarArchiver.addFile(artifact, artifact.getName());
            if (sourceArtifact.exists()) {
                this.jarArchiver.addFile(sourceArtifact, sourceArtifact.getName());
            } else {
                this.getLog().warn((CharSequence)"Sources not included in upload bundle. In order to add sources please run \"mvn source:jar javadoc:jar repository:bundle-create\"");
            }
            if (javadocArtifact.exists()) {
                this.jarArchiver.addFile(javadocArtifact, javadocArtifact.getName());
            } else {
                this.getLog().warn((CharSequence)"Javadoc not included in upload bundle. In order to add javadocs please run \"mvn source:jar javadoc:jar repository:bundle-create\"");
            }
            this.jarArchiver.setDestFile(bundle);
            this.jarArchiver.createArchive();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error creating upload bundle archive.");
        }
    }

    private void validate(String data, String expression) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)data)) {
            throw new MojoExecutionException(expression + " must be present.");
        }
    }
}

