/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.repository;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.repository.BundleUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.util.StringUtils;

public class BundleCreateMojo
extends AbstractMojo {
    public static final String POM = "pom.xml";
    private String basedir;
    private MavenProject project;
    private boolean disableMaterialization;
    private JarArchiver jarArchiver;
    private ArtifactHandlerManager artifactHandlerManager;
    protected InputHandler inputHandler;
    protected Settings settings;

    public void execute() throws MojoExecutionException {
        this.validate(this.project.getName(), "project.name");
        this.validate(this.project.getDescription(), "project.description");
        this.validate(this.project.getUrl(), "project.url");
        if (this.project.getLicenses().isEmpty()) {
            throw new MojoExecutionException("At least one license must be defined.");
        }
        if (this.disableMaterialization) {
            this.getLog().warn((CharSequence)"Validations to confirm support for project materialization have been DISABLED.\n\nYour project may not provide the POM elements necessary to allow users to retrieve sources on-demand,\nor to easily checkout your project in an IDE. THIS CAN SERIOUSLY INCONVENIENCE YOUR USERS.\n\nContinue? [y/N]");
            try {
                if ('y' != this.inputHandler.readLine().toLowerCase().charAt(0)) {
                    this.disableMaterialization = false;
                }
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Error reading confirmation: " + e.getMessage()), (Throwable)e);
            }
        }
        if (!this.disableMaterialization) {
            if (this.project.getScm() == null) {
                throw new MojoExecutionException("You must supply a valid <scm>> section, with at least <url> (viewing URL) and <connection> (read-only tooling connection) specified.");
            }
            this.validate(this.project.getScm().getUrl(), "project.scm.url");
            this.validate(this.project.getScm().getConnection(), "project.scm.url");
        }
        File pom = new File(this.basedir, POM);
        String finalName = this.project.getBuild().getFinalName();
        String outputDirectory = this.project.getBuild().getDirectory();
        boolean batchMode = this.settings == null ? false : !this.settings.isInteractiveMode();
        List<File> files = BundleUtils.selectProjectFiles(new File(outputDirectory), this.inputHandler, finalName, pom, this.getLog(), batchMode);
        String extension = this.artifactHandlerManager.getArtifactHandler(this.project.getPackaging()).getExtension();
        File bundle = new File(outputDirectory, finalName + "-bundle.jar");
        try {
            this.jarArchiver.addFile(pom, POM);
            boolean artifactChecks = !"pom".equals(this.project.getPackaging());
            boolean sourcesFound = false;
            boolean javadocsFound = false;
            for (File f : files) {
                if (artifactChecks && f.getName().endsWith(finalName + "-sources." + extension)) {
                    sourcesFound = true;
                } else if (artifactChecks && f.getName().equals(finalName + "-javadoc." + extension)) {
                    javadocsFound = true;
                }
                this.jarArchiver.addFile(f, f.getName());
            }
            if (artifactChecks && !sourcesFound) {
                this.getLog().warn((CharSequence)"Sources not included in upload bundle. In order to add sources please run \"mvn source:jar javadoc:jar repository:bundle-create\"");
            }
            if (artifactChecks && !javadocsFound) {
                this.getLog().warn((CharSequence)"Javadoc not included in upload bundle. In order to add javadocs please run \"mvn source:jar javadoc:jar repository:bundle-create\"");
            }
            this.jarArchiver.setDestFile(bundle);
            this.jarArchiver.createArchive();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Error creating upload bundle archive.");
        }
    }

    private void validate(String data, String expression) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)data)) {
            throw new MojoExecutionException(expression + " must be present.");
        }
    }
}

