/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.resources.PropertyUtils;
import org.apache.maven.plugin.resources.ReflectionProperties;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class ResourcesMojo
extends AbstractMojo {
    private String outputDirectory;
    private List resources;
    private boolean filtering = false;
    private File filterPropertiesFile;
    private MavenProject project;
    private Properties filterProperties;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};

    public void execute() throws MojoExecutionException {
        this.copyResources(this.resources, this.outputDirectory);
    }

    protected void copyResources(List resources, String outputDirectory) throws MojoExecutionException {
        this.initializeFiltering();
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            String targetPath = resource.getTargetPath();
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resource.getDirectory());
            if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                scanner.setIncludes(resource.getIncludes().toArray(EMPTY_STRING_ARRAY));
            } else {
                scanner.setIncludes(DEFAULT_INCLUDES);
            }
            if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                scanner.setExcludes(resource.getExcludes().toArray(EMPTY_STRING_ARRAY));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String name;
                String destination = name = j.next();
                if (targetPath != null) {
                    destination = targetPath + "/" + name;
                }
                File source = new File(resource.getDirectory(), name);
                File destinationFile = new File(outputDirectory, destination);
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                try {
                    this.copyFile(source, destinationFile, resource.isFiltering() && this.filtering);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error copying resources", (Exception)e);
                }
            }
        }
    }

    private void initializeFiltering() throws MojoExecutionException {
        if (this.filtering) {
            try {
                this.filterProperties = PropertyUtils.loadPropertyFile(this.filterPropertiesFile, true, true);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error loading property file '" + this.filterPropertiesFile + "'", (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(File from, File to, boolean filtering) throws IOException {
        if (!filtering) {
            FileUtils.copyFile((File)from, (File)to);
            return;
        }
        BufferedReader fileReader = new BufferedReader(new FileReader(from));
        FileWriter fileWriter = null;
        try {
            InterpolationFilterReader reader = new InterpolationFilterReader((Reader)fileReader, (Map)this.filterProperties, "${", "}");
            reader = new InterpolationFilterReader((Reader)reader, (Map)this.filterProperties, "@", "@");
            reader = new InterpolationFilterReader((Reader)reader, (Map)new ReflectionProperties(this.project), "${", "}");
            fileWriter = new FileWriter(to);
            IOUtil.copy((Reader)reader, (Writer)fileWriter);
        }
        catch (Throwable throwable) {
            IOUtil.close((Reader)fileReader);
            IOUtil.close(fileWriter);
            throw throwable;
        }
        IOUtil.close((Reader)fileReader);
        IOUtil.close((Writer)fileWriter);
    }
}

