/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractScmMojo
extends AbstractMojo {
    private String connectionUrl;
    private String developerConnectionUrl;
    private String connectionType;
    private File workingDirectory;
    private String username;
    private String password;
    private String privateKey;
    private String passphrase;
    private String tagBase;
    private String includes;
    private String excludes;
    private ScmManager manager;
    private File basedir;
    private Settings settings;

    protected void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionUrl() {
        if (StringUtils.isNotEmpty((String)this.connectionUrl) && "connection".equals(this.connectionType.toLowerCase())) {
            return this.connectionUrl;
        }
        if (StringUtils.isNotEmpty((String)this.developerConnectionUrl) && "developerconnection".equals(this.connectionType.toLowerCase())) {
            return this.developerConnectionUrl;
        }
        throw new NullPointerException("You need to define a connectionUrl parameter");
    }

    public File getWorkingDirectory() {
        if (this.workingDirectory == null) {
            return this.basedir;
        }
        return this.workingDirectory;
    }

    public ScmManager getScmManager() {
        return this.manager;
    }

    public ScmFileSet getFileSet() throws IOException {
        if (this.includes != null || this.excludes != null) {
            return new ScmFileSet(this.getWorkingDirectory(), this.includes, this.excludes);
        }
        return new ScmFileSet(this.getWorkingDirectory());
    }

    public ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository;
        try {
            repository = this.getScmManager().makeScmRepository(this.getConnectionUrl());
            ScmProviderRepository providerRepo = repository.getProviderRepository();
            if (!StringUtils.isEmpty((String)this.username)) {
                providerRepo.setUser(this.username);
            }
            if (!StringUtils.isEmpty((String)this.password)) {
                providerRepo.setPassword(this.password);
            }
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repo = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                this.loadInfosFromSettings(repo);
                if (!StringUtils.isEmpty((String)this.username)) {
                    repo.setUser(this.username);
                }
                if (!StringUtils.isEmpty((String)this.password)) {
                    repo.setPassword(this.password);
                }
                if (!StringUtils.isEmpty((String)this.privateKey)) {
                    repo.setPrivateKey(this.privateKey);
                }
                if (!StringUtils.isEmpty((String)this.passphrase)) {
                    repo.setPassphrase(this.passphrase);
                }
            }
            if (!StringUtils.isEmpty((String)this.tagBase) && repository.getProvider().equals("svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
                svnRepo.setTagBase(this.tagBase);
            }
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    private void loadInfosFromSettings(ScmProviderRepositoryWithHost repo) {
        if (this.username == null || this.password == null) {
            Server server;
            String host = repo.getHost();
            int port = repo.getPort();
            if (port > 0) {
                host = host + ":" + port;
            }
            if ((server = this.settings.getServer(host)) != null) {
                if (this.username == null) {
                    this.username = this.settings.getServer(host).getUsername();
                }
                if (this.password == null) {
                    this.password = this.settings.getServer(host).getPassword();
                }
                if (this.privateKey == null) {
                    this.privateKey = this.settings.getServer(host).getPrivateKey();
                }
                if (this.passphrase == null) {
                    this.passphrase = this.settings.getServer(host).getPassphrase();
                }
            }
        }
    }

    public void checkResult(ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            this.getLog().error((CharSequence)"Provider message:");
            this.getLog().error((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.getLog().error((CharSequence)"Command output:");
            this.getLog().error((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            throw new MojoExecutionException("Command failed." + StringUtils.defaultString((Object)result.getProviderMessage()));
        }
    }
}

