/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.plugin.CheckoutMojo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class BootstrapMojo
extends CheckoutMojo {
    private String goals;

    public void execute() throws MojoExecutionException {
        this.checkout();
        this.runGoals();
    }

    private void runGoals() throws MojoExecutionException {
        Commandline cl = new Commandline();
        try {
            this.addSystemEnvironment(cl);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't add system environment variables to mvn command line.", e);
        }
        cl.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        cl.setExecutable("mvn");
        cl.setWorkingDirectory(this.getCheckoutDirectory().getPath());
        if (this.goals != null) {
            String[] tokens = StringUtils.split((String)this.goals, (String)", ");
            for (int i = 0; i < tokens.length; ++i) {
                cl.createArgument().setValue(tokens[i]);
            }
        }
        DefaultConsumer consumer = new DefaultConsumer();
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)consumer);
            if (result != 0) {
                throw new MojoExecutionException("Result of mvn execution is: '" + result + "'. Release failed.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Can't run goal " + this.goals, (Exception)((Object)e));
        }
    }

    private void addSystemEnvironment(Commandline cl) throws Exception {
        Properties envVars = this.getSystemEnvVars();
        Iterator<Object> i = envVars.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            cl.addEnvironment(key, envVars.getProperty(key));
        }
    }

    private Properties getSystemEnvVars() throws Exception {
        String line;
        Process p = null;
        Properties envVars = new Properties();
        Runtime r = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase();
        p = os.indexOf("windows") != -1 ? (os.indexOf("95") != -1 || os.indexOf("98") != -1 || os.indexOf("Me") != -1 ? r.exec("command.com /c set") : r.exec("cmd.exe /c set")) : r.exec("env");
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = br.readLine()) != null) {
            int idx = line.indexOf(61);
            String key = line.substring(0, idx);
            String value = line.substring(idx + 1);
            envVars.setProperty(key, value);
        }
        return envVars;
    }
}

