/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

public class ChangeLogMojo
extends AbstractScmMojo {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private String startDate;
    private String endDate;
    private String dateFormat;
    private String userDateFormat = "yyyy-MM-dd";

    public void execute() throws MojoExecutionException {
        SimpleDateFormat localFormat = new SimpleDateFormat(this.userDateFormat);
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.getScmManager().getProviderByRepository(repository);
            ChangeLogScmResult result = provider.changeLog(repository, this.getFileSet(), this.parseDate(localFormat, this.startDate), this.parseDate(localFormat, this.endDate), 0, null, this.dateFormat);
            this.checkResult((ScmResult)result);
            ChangeLogSet changeLogSet = result.getChangeLog();
            Iterator i = changeLogSet.getChangeSets().iterator();
            while (i.hasNext()) {
                ChangeSet changeSet = (ChangeSet)i.next();
                System.out.println(changeSet.toString());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)((Object)e));
        }
    }

    private Date parseDate(SimpleDateFormat format, String date) throws MojoExecutionException {
        if (date == null || date.trim().length() == 0) {
            return null;
        }
        try {
            return format.parse(date.toString());
        }
        catch (ParseException e) {
            throw new MojoExecutionException("Please use this date pattern: " + format.toLocalizedPattern().toString(), (Exception)e);
        }
    }
}

