/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;

public class CheckoutMojo
extends AbstractScmMojo {
    private String branch;
    private String tag;
    private File checkoutDirectory;

    public void execute() throws MojoExecutionException {
        this.checkout();
    }

    protected File getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    protected void checkout() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            String currentTag = null;
            if (this.branch != null) {
                currentTag = this.branch;
            }
            if (this.tag != null) {
                currentTag = this.tag;
            }
            try {
                this.getLog().info((CharSequence)("Removing " + this.checkoutDirectory));
                FileUtils.deleteDirectory((File)this.checkoutDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot remove " + this.checkoutDirectory);
            }
            if (!this.checkoutDirectory.mkdirs()) {
                throw new MojoExecutionException("Cannot create " + this.checkoutDirectory);
            }
            CheckOutScmResult result = this.getScmManager().getProviderByRepository(repository).checkOut(repository, new ScmFileSet(this.checkoutDirectory.getAbsoluteFile()), currentTag);
            this.checkResult((ScmResult)result);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)((Object)e));
        }
    }
}

