/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;

public class DiffMojo
extends AbstractScmMojo {
    private String startRevision;
    private String endRevision;
    private File outputFile;

    public void execute() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            DiffScmResult result = this.getScmManager().getProviderByRepository(repository).diff(repository, this.getFileSet(), this.startRevision, this.endRevision);
            this.checkResult((ScmResult)result);
            this.getLog().info((CharSequence)result.getPatch());
            try {
                if (this.outputFile != null) {
                    FileUtils.fileWrite((String)this.outputFile.getAbsolutePath(), (String)result.getPatch());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't write patch file.", (Exception)e);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run diff command : ", (Exception)((Object)e));
        }
    }
}

