/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

public class StatusMojo
extends AbstractScmMojo {
    public void execute() throws MojoExecutionException {
        try {
            ScmFile file;
            ScmRepository repository = this.getScmRepository();
            StatusScmResult result = this.getScmManager().getProviderByRepository(repository).status(repository, this.getFileSet());
            this.checkResult((ScmResult)result);
            File baseDir = this.getFileSet().getBasedir();
            int maxLen = 0;
            Iterator iter = result.getChangedFiles().iterator();
            while (iter.hasNext()) {
                file = (ScmFile)iter.next();
                maxLen = Math.max(maxLen, file.getStatus().toString().length());
            }
            iter = result.getChangedFiles().iterator();
            while (iter.hasNext()) {
                file = (ScmFile)iter.next();
                this.getLog().info((CharSequence)(StringUtils.leftPad((String)file.getStatus().toString(), (int)maxLen) + " " + this.getRelativePath(baseDir, file.getPath())));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)((Object)e));
        }
    }

    protected String getRelativePath(File baseDir, String path) {
        if (path.equals(baseDir.getAbsolutePath())) {
            return ".";
        }
        if (path.indexOf(baseDir.getAbsolutePath()) == 0) {
            return path.substring(baseDir.getAbsolutePath().length() + 1);
        }
        return path;
    }
}

