/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;

public class UpdateMojo
extends AbstractScmMojo {
    private String branch;
    private String tag;
    private String revisionKey;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            String currentTag = null;
            if (this.branch != null) {
                currentTag = this.branch;
            }
            if (this.tag != null) {
                currentTag = this.tag;
            }
            UpdateScmResult result = this.getScmManager().getProviderByRepository(repository).update(repository, this.getFileSet(), currentTag);
            this.checkResult((ScmResult)result);
            if (result instanceof UpdateScmResultWithRevision) {
                this.getLog().info((CharSequence)("Storing revision in '" + this.revisionKey + "' project property."));
                this.project.getProperties().put(this.revisionKey, ((UpdateScmResultWithRevision)result).getRevision());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)((Object)e));
        }
    }
}

