/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.scm.plugin.AbstractScmMojo;

public class ValidateMojo
extends AbstractScmMojo {
    private String scmConnection;
    private String scmDeveloperConnection;

    public void execute() throws MojoExecutionException {
        try {
            this.validateConnection(this.getConnectionUrl(), "connectionUrl");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.scmConnection != null) {
            this.validateConnection(this.scmConnection, "project.scm.connection");
        }
        if (this.scmDeveloperConnection != null) {
            this.validateConnection(this.scmDeveloperConnection, "project.scm.developerConnection");
        }
    }

    private void validateConnection(String connectionString, String type) throws MojoExecutionException {
        List messages = this.getScmManager().validateScmRepository(connectionString);
        if (!messages.isEmpty()) {
            this.getLog().error((CharSequence)("Validation of scm url connection (" + type + ") failed :"));
            Iterator iter = messages.iterator();
            while (iter.hasNext()) {
                this.getLog().error((CharSequence)iter.next().toString());
            }
            this.getLog().error((CharSequence)("The invalid scm url connection: '" + connectionString + "'."));
            throw new MojoExecutionException("Command failed. Bad Scm URL.");
        }
        this.getLog().info((CharSequence)(type + " scm connection string is valid."));
    }
}

