/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;

@Mojo(name="update", aggregator=true)
public class UpdateMojo
extends AbstractScmMojo {
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(property="scmVersion")
    private String scmVersion;
    @Parameter(property="revisionKey", defaultValue="scm.revision")
    private String revisionKey;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="runChangelog", defaultValue="false")
    private boolean runChangelog = false;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            UpdateScmResult result = this.getScmManager().update(repository, this.getFileSet(), this.getScmVersion(this.scmVersionType, this.scmVersion), this.runChangelog);
            this.checkResult((ScmResult)result);
            if (result instanceof UpdateScmResultWithRevision) {
                String revision = ((UpdateScmResultWithRevision)result).getRevision();
                this.getLog().info((CharSequence)("Storing revision in '" + this.revisionKey + "' project property."));
                if (this.project.getProperties() != null) {
                    this.project.getProperties().put(this.revisionKey, revision);
                }
                this.getLog().info((CharSequence)("Project at revision " + revision));
            }
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException("Cannot run update command : ", (Exception)e);
        }
    }
}

