/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.site.AbstractDeployMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="stage-deploy", requiresDependencyResolution=ResolutionScope.TEST)
public class SiteStageDeployMojo
extends AbstractDeployMojo {
    @Parameter(property="stagingSiteURL")
    private String stagingSiteURL;
    @Parameter(property="stagingRepositoryId")
    private String stagingRepositoryId;

    protected String getDeployModuleDirectory() throws MojoExecutionException {
        if (StringUtils.isNotEmpty((String)this.stagingSiteURL)) {
            String relative = this.siteTool.getRelativePath(SiteStageDeployMojo.getSite(this.project).getUrl(), this.getSiteForTopMostParentWithSameStagingSiteURL(this.project).getUrl());
            relative = relative.replace('\\', '/');
            this.getLog().debug((CharSequence)"The stagingSiteURL is configured, using special way to calculate relative path.");
            return "".equals(relative) ? "./" : relative;
        }
        this.getLog().debug((CharSequence)"No stagingSiteURL is configured, using standard way to calculate relative path.");
        return super.getDeployModuleDirectory();
    }

    protected String getDeployRepositoryID() throws MojoExecutionException {
        this.stagingRepositoryId = this.stagingRepoId(this.stagingRepositoryId);
        this.getLog().info((CharSequence)("Using this server ID for stage deploy: " + this.stagingRepositoryId));
        return this.stagingRepositoryId;
    }

    protected String getDeployRepositoryURL() throws MojoExecutionException {
        String stagingURL = this.determineStagingSiteURL(this.stagingSiteURL);
        this.getLog().info((CharSequence)("Using this base URL for stage deploy: " + stagingURL));
        return stagingURL;
    }

    private Site getSiteForTopMostParentWithSameStagingSiteURL(MavenProject project) {
        String actualStagingSiteURL = this.getStagingSiteURL(project);
        MavenProject parent = project;
        Site site = null;
        while (parent != null && actualStagingSiteURL.equals(this.getStagingSiteURL(parent))) {
            site = parent.getDistributionManagement().getSite();
            parent = this.siteTool.getParentProject(parent, this.reactorProjects, this.localRepository);
        }
        return site;
    }

    private String getStagingSiteURL(MavenProject project) {
        String sitePluginKey = "org.apache.maven.plugins:maven-site-plugin";
        if (project == null) {
            return null;
        }
        Build build = project.getBuild();
        if (build == null) {
            return null;
        }
        Map plugins = build.getPluginsAsMap();
        Plugin sitePlugin = (Plugin)plugins.get("org.apache.maven.plugins:maven-site-plugin");
        if (sitePlugin == null) {
            PluginManagement buildPluginManagement = build.getPluginManagement();
            if (buildPluginManagement == null) {
                return null;
            }
            plugins = buildPluginManagement.getPluginsAsMap();
            sitePlugin = (Plugin)plugins.get("org.apache.maven.plugins:maven-site-plugin");
        }
        if (sitePlugin == null) {
            return null;
        }
        Xpp3Dom sitePluginConfiguration = (Xpp3Dom)sitePlugin.getConfiguration();
        if (sitePluginConfiguration == null) {
            return null;
        }
        Xpp3Dom child = sitePluginConfiguration.getChild("stagingSiteURL");
        if (child == null) {
            return null;
        }
        return child.getValue();
    }

    private String determineStagingSiteURL(String usersStagingSiteURL) throws MojoExecutionException {
        String topLevelURL = null;
        if (usersStagingSiteURL != null) {
            this.getLog().debug((CharSequence)("stagingSiteURL specified by the user: " + usersStagingSiteURL));
            topLevelURL = usersStagingSiteURL;
        } else {
            topLevelURL = SiteStageDeployMojo.appendSlash(this.getRootSite(this.project).getUrl()) + "staging/";
            this.getLog().debug((CharSequence)("stagingSiteURL NOT specified, using the top level project: " + topLevelURL));
        }
        return topLevelURL;
    }

    private String stagingRepoId(String stagingRepoId) {
        if (stagingRepoId != null) {
            return stagingRepoId;
        }
        try {
            return SiteStageDeployMojo.getSite(this.project).getId();
        }
        catch (MojoExecutionException ex) {
            return "stagingSite";
        }
    }
}

