/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.deploy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.doxia.site.decoration.inheritance.URIPathDescriptor;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractDeployMojo
extends AbstractSiteMojo
implements Contextualizable {
    @Parameter(alias="outputDirectory", defaultValue="${project.reporting.outputDirectory}", required=true)
    private File inputDirectory;
    @Parameter(property="maven.site.chmod", defaultValue="true")
    private boolean chmod;
    @Parameter(property="maven.site.chmod.mode", defaultValue="g+w,a+rX")
    private String chmodMode;
    @Parameter(property="maven.site.chmod.options", defaultValue="-Rf")
    private String chmodOptions;
    @Parameter(property="maven.site.deploy.skip", defaultValue="false")
    private boolean skipDeploy;
    @Component
    private WagonManager wagonManager;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    private String topDistributionManagementSiteUrl;
    private Site deploySite;
    private PlexusContainer container;

    public void execute() throws MojoExecutionException {
        if (this.skip && this.isDeploy()) {
            this.getLog().info((CharSequence)"maven.site.skip = true: Skipping site deployment");
            return;
        }
        if (this.skipDeploy && this.isDeploy()) {
            this.getLog().info((CharSequence)"maven.site.deploy.skip = true: Skipping site deployment");
            return;
        }
        this.deployTo(new Repository(this.getDeploySite().getId(), this.getDeploySite().getUrl()));
    }

    protected static String appendSlash(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }

    protected abstract boolean isDeploy();

    protected String getTopDistributionManagementSiteUrl() throws MojoExecutionException {
        if (this.topDistributionManagementSiteUrl == null) {
            this.topDistributionManagementSiteUrl = this.determineTopDistributionManagementSiteUrl();
            if (!this.isDeploy()) {
                this.getLog().debug((CharSequence)("distributionManagement.site.url relative path: " + this.getDeployModuleDirectory()));
            }
        }
        return this.topDistributionManagementSiteUrl;
    }

    protected abstract String determineTopDistributionManagementSiteUrl() throws MojoExecutionException;

    protected Site getDeploySite() throws MojoExecutionException {
        if (this.deploySite == null) {
            this.deploySite = this.determineDeploySite();
        }
        return this.deploySite;
    }

    protected abstract Site determineDeploySite() throws MojoExecutionException;

    protected String getDeployModuleDirectory() throws MojoExecutionException {
        String to = AbstractDeployMojo.getSite(this.project).getUrl();
        this.getLog().debug((CharSequence)"Mapping url source calculation: ");
        String from = this.getTopDistributionManagementSiteUrl();
        String relative = this.siteTool.getRelativePath(to, from);
        relative = relative.replace('\\', '/');
        return "".equals(relative) ? "./" : relative;
    }

    private void deployTo(Repository repository) throws MojoExecutionException {
        if (!this.inputDirectory.exists()) {
            throw new MojoExecutionException("The site does not exist, please run site:site first");
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Deploying to '" + repository.getUrl() + "',\n    Using credentials from server id '" + repository.getId() + "'"));
        }
        this.deploy(this.inputDirectory, repository);
    }

    private void deploy(File directory, Repository repository) throws MojoExecutionException {
        Wagon wagon = this.getWagon(repository, this.wagonManager);
        try {
            SettingsDecrypter settingsDecrypter = (SettingsDecrypter)this.container.lookup(SettingsDecrypter.class);
            ProxyInfo proxyInfo = this.getProxy(repository, settingsDecrypter);
            this.push(directory, repository, wagon, proxyInfo, this.getLocales(), this.getDeployModuleDirectory());
            if (this.chmod) {
                AbstractDeployMojo.chmod(wagon, repository, this.chmodOptions, this.chmodMode);
            }
        }
        catch (ComponentLookupException cle) {
            throw new MojoExecutionException("Unable to lookup SettingsDecrypter: " + cle.getMessage(), (Exception)((Object)cle));
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }

    private Wagon getWagon(Repository repository, WagonManager manager) throws MojoExecutionException {
        Wagon wagon;
        try {
            wagon = manager.getWagon(repository);
        }
        catch (UnsupportedProtocolException e) {
            String shortMessage = "Unsupported protocol: '" + repository.getProtocol() + "' for site deployment to distributionManagement.site.url=" + repository.getUrl() + ".";
            String longMessage = "\n" + shortMessage + "\nCurrently supported protocols are: " + this.getSupportedProtocols() + ".\n    Protocols may be added through wagon providers.\n    For more information, see https://maven.apache.org/plugins/maven-site-plugin/examples/adding-deploy-protocol.html";
            this.getLog().error((CharSequence)longMessage);
            throw new MojoExecutionException(shortMessage);
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        if (!wagon.supportsDirectoryCopy()) {
            throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
        }
        return wagon;
    }

    private String getSupportedProtocols() {
        try {
            Set protocols = this.container.lookupMap(Wagon.class).keySet();
            return StringUtils.join(protocols.iterator(), (String)", ");
        }
        catch (ComponentLookupException e) {
            this.getLog().error((Throwable)e);
            return "";
        }
    }

    private void push(File inputDirectory, Repository repository, Wagon wagon, ProxyInfo proxyInfo, List<Locale> localesList, String relativeDir) throws MojoExecutionException {
        AuthenticationInfo authenticationInfo = this.wagonManager.getAuthenticationInfo(repository.getId());
        this.getLog().debug((CharSequence)("authenticationInfo with id '" + repository.getId() + "': " + (authenticationInfo == null ? "-" : authenticationInfo.getUserName())));
        try {
            if (this.getLog().isDebugEnabled()) {
                Debug debug = new Debug();
                wagon.addSessionListener((SessionListener)debug);
                wagon.addTransferListener((TransferListener)debug);
            }
            if (proxyInfo != null) {
                this.getLog().debug((CharSequence)"connect with proxyInfo");
                wagon.connect(repository, authenticationInfo, proxyInfo);
            } else if (proxyInfo == null && authenticationInfo != null) {
                this.getLog().debug((CharSequence)"connect with authenticationInfo and without proxyInfo");
                wagon.connect(repository, authenticationInfo);
            } else {
                this.getLog().debug((CharSequence)"connect without authenticationInfo and without proxyInfo");
                wagon.connect(repository);
            }
            this.getLog().info((CharSequence)("Pushing " + inputDirectory));
            Locale defaultLocale = localesList.get(0);
            for (Locale locale : localesList) {
                if (locale.equals(defaultLocale)) {
                    this.getLog().info((CharSequence)("   >>> to " + AbstractDeployMojo.appendSlash(repository.getUrl()) + relativeDir));
                    wagon.putDirectory(inputDirectory, relativeDir);
                    continue;
                }
                this.getLog().info((CharSequence)("   >>> to " + AbstractDeployMojo.appendSlash(repository.getUrl()) + locale + "/" + relativeDir));
                wagon.putDirectory(new File(inputDirectory, locale.toString()), locale + "/" + relativeDir);
            }
        }
        catch (ConnectionException | ResourceDoesNotExistException | TransferFailedException | AuthenticationException | AuthorizationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)e);
        }
    }

    private static void chmod(Wagon wagon, Repository repository, String chmodOptions, String chmodMode) throws MojoExecutionException {
        try {
            if (wagon instanceof CommandExecutor) {
                CommandExecutor exec = (CommandExecutor)wagon;
                exec.executeCommand("chmod " + chmodOptions + " " + chmodMode + " " + repository.getBasedir());
            }
        }
        catch (CommandExecutionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
    }

    public static ProxyInfo getProxyInfo(Repository repository, WagonManager wagonManager) {
        ProxyInfo proxyInfo = wagonManager.getProxy(repository.getProtocol());
        if (proxyInfo == null) {
            return null;
        }
        String host = repository.getHost();
        String nonProxyHostsAsString = proxyInfo.getNonProxyHosts();
        for (String nonProxyHost : StringUtils.split((String)nonProxyHostsAsString, (String)",;|")) {
            if (StringUtils.contains((String)nonProxyHost, (String)"*")) {
                int pos = nonProxyHost.indexOf(42);
                String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                if (StringUtils.isNotEmpty((String)nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty((String)nonProxyHostSuffix)) {
                    return null;
                }
                if (StringUtils.isEmpty((String)nonProxyHostPrefix) && StringUtils.isNotEmpty((String)nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                    return null;
                }
                if (!StringUtils.isNotEmpty((String)nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || !StringUtils.isNotEmpty((String)nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                return null;
            }
            if (!host.equals(nonProxyHost)) continue;
            return null;
        }
        return proxyInfo;
    }

    private ProxyInfo getProxy(Repository repository, SettingsDecrypter settingsDecrypter) {
        List proxies;
        MavenExecutionRequest request;
        String protocol = repository.getProtocol();
        String url = repository.getUrl();
        this.getLog().debug((CharSequence)("repository protocol " + protocol));
        String originalProtocol = protocol;
        if (StringUtils.equalsIgnoreCase((String)"dav", (String)protocol) && url.startsWith("dav:")) {
            if ((url = url.substring(4)).startsWith("http")) {
                try {
                    URL urlSite = new URL(url);
                    protocol = urlSite.getProtocol();
                    this.getLog().debug((CharSequence)("found dav protocol so transform to real transport protocol " + protocol));
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("fail to build URL with " + url));
                }
            }
        } else {
            this.getLog().debug((CharSequence)("getProxy 'protocol': " + protocol));
        }
        if (this.mavenSession != null && protocol != null && (request = this.mavenSession.getRequest()) != null && (proxies = request.getProxies()) != null) {
            for (Proxy proxy : proxies) {
                if (!proxy.isActive() || !protocol.equalsIgnoreCase(proxy.getProtocol()) && !originalProtocol.equalsIgnoreCase(proxy.getProtocol())) continue;
                SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(proxy));
                proxy = result.getProxy();
                ProxyInfo proxyInfo = new ProxyInfo();
                proxyInfo.setHost(proxy.getHost());
                proxyInfo.setType(protocol);
                proxyInfo.setPort(proxy.getPort());
                proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
                proxyInfo.setUserName(proxy.getUsername());
                proxyInfo.setPassword(proxy.getPassword());
                this.getLog().debug((CharSequence)("found proxyInfo " + "host:port " + proxyInfo.getHost() + ":" + proxyInfo.getPort() + ", " + proxyInfo.getUserName()));
                return proxyInfo;
            }
        }
        this.getLog().debug((CharSequence)("getProxy 'protocol': " + protocol + " no ProxyInfo found"));
        return null;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected static Site getSite(MavenProject project) throws MojoExecutionException {
        DistributionManagement distributionManagement = project.getDistributionManagement();
        if (distributionManagement == null) {
            throw new MojoExecutionException("Missing distribution management in project " + AbstractDeployMojo.getFullName(project));
        }
        Site site = distributionManagement.getSite();
        if (site == null) {
            throw new MojoExecutionException("Missing site information in the distribution management of the project " + AbstractDeployMojo.getFullName(project));
        }
        if (site.getUrl() == null || site.getId() == null) {
            throw new MojoExecutionException("Missing site data: specify url and id for project " + AbstractDeployMojo.getFullName(project));
        }
        return site;
    }

    private static String getFullName(MavenProject project) {
        return project.getName() + " (" + project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion() + ')';
    }

    protected MavenProject getTopLevelProject(MavenProject project) throws MojoExecutionException {
        Site site = AbstractDeployMojo.getSite(project);
        MavenProject parent = project;
        while (parent.getParent() != null) {
            URIPathDescriptor oldSiteURI;
            MavenProject oldProject = parent;
            parent = parent.getParent();
            Site oldSite = site;
            try {
                site = AbstractDeployMojo.getSite(parent);
            }
            catch (MojoExecutionException e) {
                return oldProject;
            }
            URIPathDescriptor siteURI = new URIPathDescriptor(URIEncoder.encodeURI(site.getUrl()), "");
            if (siteURI.sameSite((oldSiteURI = new URIPathDescriptor(URIEncoder.encodeURI(oldSite.getUrl()), "")).getBaseURI())) continue;
            return oldProject;
        }
        return parent;
    }

    private static class URIEncoder {
        private static final String MARK = "-_.!~*'()";
        private static final String RESERVED = ";/?:@&=+$,";

        private URIEncoder() {
        }

        private static String encodeURI(String uriString) {
            char[] chars = uriString.toCharArray();
            StringBuilder uri = new StringBuilder(chars.length);
            if (uriString.startsWith("dav:http")) {
                chars[3] = 45;
            }
            for (char c : chars) {
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || MARK.indexOf(c) != -1 || RESERVED.indexOf(c) != -1) {
                    uri.append(c);
                    continue;
                }
                uri.append('%');
                uri.append(Integer.toHexString(c));
            }
            return uri.toString();
        }
    }
}

