/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.render;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.Menu;
import org.apache.maven.doxia.site.MenuItem;
import org.apache.maven.doxia.site.SiteModel;
import org.apache.maven.doxia.siterenderer.DocumentContent;
import org.apache.maven.doxia.siterenderer.DocumentRenderingContext;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.site.render.SitePluginReportDocumentRenderer;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.i18n.I18N;

public class SitemapDocumentRenderer
implements SitePluginReportDocumentRenderer {
    private DocumentRenderingContext docRenderingContext;
    private final String reportMojoInfo;
    String title;
    private SiteModel siteModel;
    private I18N i18n;
    private final Log log;

    public SitemapDocumentRenderer(MojoExecution mojoExecution, DocumentRenderingContext docRenderingContext, String title, SiteModel siteModel, I18N i18n, Log log) {
        this.docRenderingContext = docRenderingContext;
        this.reportMojoInfo = mojoExecution.getPlugin().getArtifactId() + ':' + mojoExecution.getPlugin().getVersion() + ':' + mojoExecution.getGoal();
        this.title = title;
        this.siteModel = siteModel;
        this.i18n = i18n;
        this.log = log;
    }

    public void renderDocument(Writer writer, SiteRenderer siteRenderer, SiteRenderingContext siteRenderingContext) throws RendererException, IOException {
        Locale locale = siteRenderingContext.getLocale();
        String msg = "Generating \"" + MessageUtils.buffer().strong((Object)this.title) + "\" report";
        this.log.info((CharSequence)(StringUtils.rightPad((String)msg, (int)40) + MessageUtils.buffer().strong((Object)" --- ").mojo((Object)this.reportMojoInfo)));
        SiteRendererSink sink = new SiteRendererSink(this.docRenderingContext);
        sink.head();
        sink.title();
        sink.text(this.title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.section.title"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.i18n.getString("site-plugin", locale, "site.sitemap.description"));
        sink.paragraph_();
        for (Menu menu : this.siteModel.getMenus()) {
            sink.section2();
            sink.sectionTitle2();
            sink.text(menu.getName());
            sink.sectionTitle2_();
            sink.horizontalRule();
            SitemapDocumentRenderer.extractItems(menu.getItems(), (Sink)sink);
            sink.section2_();
        }
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
        siteRenderer.mergeDocumentIntoSite(writer, (DocumentContent)sink, siteRenderingContext);
    }

    private static void extractItems(List<MenuItem> items, Sink sink) {
        if (items == null || items.isEmpty()) {
            return;
        }
        sink.list();
        for (MenuItem item : items) {
            sink.listItem();
            if (item.getHref() != null) {
                sink.link(SitemapDocumentRenderer.relativePath(item.getHref()));
            }
            sink.text(item.getName());
            if (item.getHref() != null) {
                sink.link_();
            }
            SitemapDocumentRenderer.extractItems(item.getItems(), sink);
            sink.listItem_();
        }
        sink.list_();
    }

    private static String relativePath(String href) {
        return href.startsWith("/") ? "." + href : href;
    }

    public String getOutputName() {
        return this.docRenderingContext.getOutputName();
    }

    public DocumentRenderingContext getRenderingContext() {
        return this.docRenderingContext;
    }

    public boolean isOverwrite() {
        return true;
    }

    public boolean isExternalReport() {
        return false;
    }

    @Override
    public String getReportMojoInfo() {
        return this.reportMojoInfo;
    }
}

