package org.apache.maven.plugin.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-source-plugin.<br/> Call <pre>  mvn source:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Mon Oct 12 01:43:52 CEST 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-source-plugin:2.1.1", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Source Plugin", 0 );
        append( sb, "The Maven 2 Source Plugin creates a JAR archive of the source files of the current project.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 6 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "aggregate".equals( goal ) )
        {
            append( sb, "source:aggregate", 0 );
            append( sb, "Aggregate sources for all modules in an aggregator project.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether or not to attach the artifact to the project", 3 );
                append( sb, "", 0 );

                append( sb, "excludeResources (Default: false)", 2 );
                append( sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don\'t want to include them in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename to be used for the generated archive file. For the source:jar goal, \'-sources\' is appended to this filename. For the source:test-jar goal, \'-test-sources\' is appended.", 3 );
                append( sb, "", 0 );

                append( sb, "forceCreation (Default: false)", 2 );
                append( sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includePom (Default: false)", 2 );
                append( sb, "Specifies whether or not to include the POM file in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The directory where the generated archive file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultExcludes (Default: true)", 2 );
                append( sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultManifestFile (Default: false)", 2 );
                append( sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "source:help", 0 );
            append( sb, "Display help information on maven-source-plugin.\nCall\n\u00a0\u00a0mvn\u00a0source:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jar".equals( goal ) )
        {
            append( sb, "source:jar", 0 );
            append( sb, "This plugin bundles all the sources into a jar archive.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether or not to attach the artifact to the project", 3 );
                append( sb, "", 0 );

                append( sb, "excludeResources (Default: false)", 2 );
                append( sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don\'t want to include them in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename to be used for the generated archive file. For the source:jar goal, \'-sources\' is appended to this filename. For the source:test-jar goal, \'-test-sources\' is appended.", 3 );
                append( sb, "", 0 );

                append( sb, "forceCreation (Default: false)", 2 );
                append( sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includePom (Default: false)", 2 );
                append( sb, "Specifies whether or not to include the POM file in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The directory where the generated archive file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultExcludes (Default: true)", 2 );
                append( sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultManifestFile (Default: false)", 2 );
                append( sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jar-no-fork".equals( goal ) )
        {
            append( sb, "source:jar-no-fork", 0 );
            append( sb, "This goal bundles all the sources into a jar archive. This goal functions the same as the jar goal but does not fork the build and is suitable for attaching to the build lifecycle.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether or not to attach the artifact to the project", 3 );
                append( sb, "", 0 );

                append( sb, "excludeResources (Default: false)", 2 );
                append( sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don\'t want to include them in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename to be used for the generated archive file. For the source:jar goal, \'-sources\' is appended to this filename. For the source:test-jar goal, \'-test-sources\' is appended.", 3 );
                append( sb, "", 0 );

                append( sb, "forceCreation (Default: false)", 2 );
                append( sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includePom (Default: false)", 2 );
                append( sb, "Specifies whether or not to include the POM file in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The directory where the generated archive file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultExcludes (Default: true)", 2 );
                append( sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultManifestFile (Default: false)", 2 );
                append( sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-jar".equals( goal ) )
        {
            append( sb, "source:test-jar", 0 );
            append( sb, "This plugin bundles all the test sources into a jar archive.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether or not to attach the artifact to the project", 3 );
                append( sb, "", 0 );

                append( sb, "excludeResources (Default: false)", 2 );
                append( sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don\'t want to include them in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename to be used for the generated archive file. For the source:jar goal, \'-sources\' is appended to this filename. For the source:test-jar goal, \'-test-sources\' is appended.", 3 );
                append( sb, "", 0 );

                append( sb, "forceCreation (Default: false)", 2 );
                append( sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includePom (Default: false)", 2 );
                append( sb, "Specifies whether or not to include the POM file in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The directory where the generated archive file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultExcludes (Default: true)", 2 );
                append( sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultManifestFile (Default: false)", 2 );
                append( sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test-jar-no-fork".equals( goal ) )
        {
            append( sb, "source:test-jar-no-fork", 0 );
            append( sb, "This goal bundles all the test sources into a jar archive. This goal functions the same as the test-jar goal but does not fork the build, and is suitable for attaching to the build lifecycle.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "archive", 2 );
                append( sb, "The archive configuration to use. See Maven Archiver Reference.", 3 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether or not to attach the artifact to the project", 3 );
                append( sb, "", 0 );

                append( sb, "excludeResources (Default: false)", 2 );
                append( sb, "Specifies whether or not to exclude resources from the sources-jar. This can be convenient if your project includes large resources, such as images, and you don\'t want to include them in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "List of files to exclude. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName (Default: ${project.build.finalName})", 2 );
                append( sb, "The filename to be used for the generated archive file. For the source:jar goal, \'-sources\' is appended to this filename. For the source:test-jar goal, \'-test-sources\' is appended.", 3 );
                append( sb, "", 0 );

                append( sb, "forceCreation (Default: false)", 2 );
                append( sb, "Whether creating the archive should be forced. If set to true, the jar will always be created. If set to false, the jar will only be created when the sources are newer than the jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includePom (Default: false)", 2 );
                append( sb, "Specifies whether or not to include the POM file in the sources-jar.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "List of files to include. Specified as fileset patterns which are relative to the input directory whose contents is being packaged into the JAR.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "The directory where the generated archive file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultExcludes (Default: true)", 2 );
                append( sb, "Exclude commonly excluded files such as SCM configuration. These are defined in the plexus FileUtils.getDefaultExcludes()", 3 );
                append( sb, "", 0 );

                append( sb, "useDefaultManifestFile (Default: false)", 2 );
                append( sb, "Set this to true to enable the use of the defaultManifestFile.\n", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
