/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.markup.Markup;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public class SurefireReportRenderer
extends AbstractMavenReportRenderer {
    private static final Object[] TAG_TYPE_START = new Object[]{2};
    private static final Object[] TAG_TYPE_END = new Object[]{3};
    private final I18N i18n;
    private final String i18nSection;
    private final Locale locale;
    private final SurefireReportParser parser;
    private final List<ReportTestSuite> testSuites;
    private final String xrefTestLocation;
    private final boolean showSuccess;

    public SurefireReportRenderer(Sink sink, I18N i18n, String i18nSection, Locale locale, ConsoleLogger consoleLogger, List<File> reportsDirectories, String xrefTestLocation, boolean showSuccess) {
        super(sink);
        this.i18n = i18n;
        this.i18nSection = i18nSection;
        this.locale = locale;
        this.parser = new SurefireReportParser(reportsDirectories, consoleLogger);
        this.testSuites = this.parser.parseXMLReportFiles();
        this.showSuccess = showSuccess;
        this.xrefTestLocation = xrefTestLocation;
    }

    public String getTitle() {
        return this.getI18nString("title");
    }

    private String getI18nString(String key) {
        return this.getI18nString(this.getI18nSection(), key);
    }

    private String getI18nSection() {
        return this.i18nSection;
    }

    private String getI18nString(String section, String key) {
        return this.i18n.getString("surefire-report", this.locale, "report." + section + '.' + key);
    }

    private String formatI18nString(String section, String key, Object ... args) {
        return this.i18n.format("surefire-report", this.locale, "report." + section + '.' + key, args);
    }

    public void renderBody() {
        this.javaScript(this.javascriptToggleDisplayCode());
        this.startSection(this.getTitle());
        this.renderSectionSummary();
        this.renderSectionPackages();
        this.renderSectionTestCases();
        this.renderSectionFailureDetails();
        this.endSection();
    }

    private void renderSectionSummary() {
        Map summary = this.parser.getSummary(this.testSuites);
        this.startSection(this.getI18nString("surefire", "label.summary"), "Summary");
        this.constructHotLinks();
        this.sink.lineBreak();
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("surefire", "label.tests"), this.getI18nString("surefire", "label.errors"), this.getI18nString("surefire", "label.failures"), this.getI18nString("surefire", "label.skipped"), this.getI18nString("surefire", "label.successrate"), this.getI18nString("surefire", "label.time")});
        this.tableRow(new String[]{String.valueOf(summary.get("totalTests")), String.valueOf(summary.get("totalErrors")), String.valueOf(summary.get("totalFailures")), String.valueOf(summary.get("totalSkipped")), this.formatI18nString("surefire", "value.successrate", summary.get("totalPercentage")), this.formatI18nString("surefire", "value.time", summary.get("totalElapsedTime"))});
        this.endTable();
        this.sink.lineBreak();
        this.paragraph(this.getI18nString("surefire", "text.note1"));
        this.sink.lineBreak();
        this.endSection();
    }

    private void renderSectionPackages() {
        List testSuiteList;
        String packageName;
        Map suitePackages = this.parser.getSuitesGroupByPackage(this.testSuites);
        if (suitePackages.isEmpty()) {
            return;
        }
        this.startSection(this.getI18nString("surefire", "label.packagelist"), "Package_List");
        this.constructHotLinks();
        this.sink.lineBreak();
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("surefire", "label.package"), this.getI18nString("surefire", "label.tests"), this.getI18nString("surefire", "label.errors"), this.getI18nString("surefire", "label.failures"), this.getI18nString("surefire", "label.skipped"), this.getI18nString("surefire", "label.successrate"), this.getI18nString("surefire", "label.time")});
        for (Map.Entry entry : suitePackages.entrySet()) {
            packageName = (String)entry.getKey();
            testSuiteList = (List)entry.getValue();
            Map packageSummary = this.parser.getSummary(testSuiteList);
            this.tableRow(new String[]{SurefireReportRenderer.createLinkPatternedText((String)packageName, (String)('#' + packageName)), String.valueOf(packageSummary.get("totalTests")), String.valueOf(packageSummary.get("totalErrors")), String.valueOf(packageSummary.get("totalFailures")), String.valueOf(packageSummary.get("totalSkipped")), this.formatI18nString("surefire", "value.successrate", packageSummary.get("totalPercentage")), this.formatI18nString("surefire", "value.time", packageSummary.get("totalElapsedTime"))});
        }
        this.endTable();
        this.sink.lineBreak();
        this.paragraph(this.getI18nString("surefire", "text.note2"));
        for (Map.Entry entry : suitePackages.entrySet()) {
            packageName = (String)entry.getKey();
            testSuiteList = (List)entry.getValue();
            this.startSection(packageName);
            boolean showTable = false;
            for (ReportTestSuite suite : testSuiteList) {
                if (!this.showSuccess && suite.getNumberOfErrors() == 0 && suite.getNumberOfFailures() == 0) continue;
                showTable = true;
                break;
            }
            if (showTable) {
                this.startTable();
                this.tableHeader(new String[]{"", this.getI18nString("surefire", "label.class"), this.getI18nString("surefire", "label.tests"), this.getI18nString("surefire", "label.errors"), this.getI18nString("surefire", "label.failures"), this.getI18nString("surefire", "label.skipped"), this.getI18nString("surefire", "label.successrate"), this.getI18nString("surefire", "label.time")});
                for (ReportTestSuite suite : testSuiteList) {
                    if (!this.showSuccess && suite.getNumberOfErrors() == 0 && suite.getNumberOfFailures() == 0) continue;
                    this.renderSectionTestSuite(suite);
                }
                this.endTable();
            }
            this.endSection();
        }
        this.sink.lineBreak();
        this.endSection();
    }

    private void renderSectionTestSuite(ReportTestSuite suite) {
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.link("#" + suite.getPackageName() + '.' + suite.getName());
        if (suite.getNumberOfErrors() > 0) {
            this.sinkIcon("error");
        } else if (suite.getNumberOfFailures() > 0) {
            this.sinkIcon("junit.framework");
        } else if (suite.getNumberOfSkipped() > 0) {
            this.sinkIcon("skipped");
        } else {
            this.sinkIcon("success");
        }
        this.sink.link_();
        this.sink.tableCell_();
        this.tableCell(SurefireReportRenderer.createLinkPatternedText((String)suite.getName(), (String)('#' + suite.getPackageName() + '.' + suite.getName())));
        this.tableCell(Integer.toString(suite.getNumberOfTests()));
        this.tableCell(Integer.toString(suite.getNumberOfErrors()));
        this.tableCell(Integer.toString(suite.getNumberOfFailures()));
        this.tableCell(Integer.toString(suite.getNumberOfSkipped()));
        float percentage = this.parser.computePercentage(suite.getNumberOfTests(), suite.getNumberOfErrors(), suite.getNumberOfFailures(), suite.getNumberOfSkipped());
        this.tableCell(this.formatI18nString("surefire", "value.successrate", Float.valueOf(percentage)));
        this.tableCell(this.formatI18nString("surefire", "value.time", Float.valueOf(suite.getTimeElapsed())));
        this.sink.tableRow_();
    }

    private void renderSectionTestCases() {
        if (this.testSuites.isEmpty()) {
            return;
        }
        this.startSection(this.getI18nString("surefire", "label.testcases"), "Test_Cases");
        this.constructHotLinks();
        for (ReportTestSuite suite : this.testSuites) {
            List testCases = suite.getTestCases();
            if (testCases.isEmpty()) continue;
            this.startSection(suite.getName(), suite.getPackageName() + '.' + suite.getName());
            boolean showTable = false;
            for (ReportTestCase testCase : testCases) {
                if (testCase.isSuccessful() && !this.showSuccess) continue;
                showTable = true;
                break;
            }
            if (showTable) {
                this.startTable();
                for (ReportTestCase testCase : testCases) {
                    if (testCase.isSuccessful() && !this.showSuccess) continue;
                    this.constructTestCaseSection(testCase);
                }
                this.endTable();
            }
            this.endSection();
        }
        this.sink.lineBreak();
        this.endSection();
    }

    private void constructTestCaseSection(ReportTestCase testCase) {
        this.sink.tableRow();
        this.sink.tableCell();
        if (testCase.getFailureType() != null) {
            this.sink.link("#" + this.toHtmlId(testCase.getFullName()));
            this.sinkIcon(testCase.getFailureType());
            this.sink.link_();
        } else {
            this.sinkIcon("success");
        }
        this.sink.tableCell_();
        if (!testCase.isSuccessful()) {
            this.sink.tableCell();
            this.sinkAnchor("TC_" + this.toHtmlId(testCase.getFullName()));
            this.link("#" + this.toHtmlId(testCase.getFullName()), testCase.getName());
            SinkEventAttributeSet atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"class", (Object)"detailToggle");
            atts.addAttribute((Object)"style", (Object)"display:inline");
            this.sink.unknown("div", TAG_TYPE_START, (SinkEventAttributes)atts);
            this.sinkLink("javascript:toggleDisplay('" + this.toHtmlId(testCase.getFullName()) + "');");
            atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"style", (Object)"display:inline;");
            atts.addAttribute((Object)"id", (Object)(this.toHtmlId(testCase.getFullName()) + "-off"));
            this.sink.unknown("span", TAG_TYPE_START, (SinkEventAttributes)atts);
            this.sink.text(" + ");
            this.sink.unknown("span", TAG_TYPE_END, null);
            atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"style", (Object)"display:none;");
            atts.addAttribute((Object)"id", (Object)(this.toHtmlId(testCase.getFullName()) + "-on"));
            this.sink.unknown("span", TAG_TYPE_START, (SinkEventAttributes)atts);
            this.sink.text(" - ");
            this.sink.unknown("span", TAG_TYPE_END, null);
            this.sink.text("[ Detail ]");
            this.sinkLink_();
            this.sink.unknown("div", TAG_TYPE_END, null);
            this.sink.tableCell_();
        } else {
            this.sinkCellAnchor(testCase.getName(), "TC_" + this.toHtmlId(testCase.getFullName()));
        }
        this.tableCell(this.formatI18nString("surefire", "value.time", Float.valueOf(testCase.getTime())));
        this.sink.tableRow_();
        if (!testCase.isSuccessful()) {
            String detail;
            String message = testCase.getFailureMessage();
            if (message != null) {
                this.sink.tableRow();
                this.tableCell("");
                this.sink.tableCell();
                this.text(message);
                this.sink.tableCell_();
                this.tableCell("");
                this.sink.tableRow_();
            }
            if ((detail = testCase.getFailureDetail()) != null) {
                SinkEventAttributeSet atts = new SinkEventAttributeSet();
                atts.addAttribute((Object)"id", (Object)(this.toHtmlId(testCase.getFullName()) + this.toHtmlIdFailure(testCase)));
                atts.addAttribute((Object)"style", (Object)"display:none;");
                this.sink.tableRow((SinkEventAttributes)atts);
                this.tableCell("");
                this.sink.tableCell();
                this.verbatimText(detail);
                this.sink.tableCell_();
                this.tableCell("");
                this.sink.tableRow_();
            }
        }
    }

    private String toHtmlId(String id) {
        return DoxiaUtils.isValidId((String)id) ? id : DoxiaUtils.encodeId((String)id);
    }

    private void renderSectionFailureDetails() {
        List failures = this.parser.getFailureDetails(this.testSuites);
        if (failures.isEmpty()) {
            return;
        }
        this.startSection(this.getI18nString("surefire", "label.failuredetails"), "Failure_Details");
        this.constructHotLinks();
        this.sink.lineBreak();
        this.startTable();
        for (ReportTestCase testCase : failures) {
            this.sink.tableRow();
            this.sink.tableCell();
            String type = testCase.getFailureType();
            this.sinkIcon(type);
            this.sink.tableCell_();
            this.sinkCellAnchor(testCase.getName(), this.toHtmlId(testCase.getFullName()));
            this.sink.tableRow_();
            String message = testCase.getFailureMessage();
            this.sink.tableRow();
            this.tableCell("");
            this.sink.tableCell();
            this.text(message == null ? type : type + ": " + message);
            this.sink.tableCell_();
            this.sink.tableRow_();
            String detail = testCase.getFailureDetail();
            if (detail == null) continue;
            this.sink.tableRow();
            this.tableCell("");
            this.sink.tableCell();
            SinkEventAttributeSet atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"id", (Object)(testCase.getName() + this.toHtmlIdFailure(testCase)));
            this.sink.unknown("div", TAG_TYPE_START, (SinkEventAttributes)atts);
            String fullClassName = testCase.getFullClassName();
            String errorLineNumber = testCase.getFailureErrorLine();
            if (this.xrefTestLocation != null) {
                String path = fullClassName.replace('.', '/');
                this.sink.link(this.xrefTestLocation + "/" + path + ".html#L" + errorLineNumber);
            }
            this.sink.text(fullClassName + ":" + errorLineNumber);
            if (this.xrefTestLocation != null) {
                this.sink.link_();
            }
            this.sink.unknown("div", TAG_TYPE_END, null);
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.endTable();
        this.sink.lineBreak();
        this.endSection();
    }

    private void constructHotLinks() {
        if (!this.testSuites.isEmpty()) {
            this.sink.paragraph();
            this.sink.text("[");
            this.link("#Summary", this.getI18nString("surefire", "label.summary"));
            this.sink.text("]");
            this.sink.text(" [");
            this.link("#Package_List", this.getI18nString("surefire", "label.packagelist"));
            this.sink.text("]");
            this.sink.text(" [");
            this.link("#Test_Cases", this.getI18nString("surefire", "label.testcases"));
            this.sink.text("]");
            this.sink.paragraph_();
        }
    }

    private String toHtmlIdFailure(ReportTestCase testCase) {
        return testCase.hasError() ? "-error" : "-failure";
    }

    private void sinkIcon(String type) {
        if (type.startsWith("junit.framework") || "skipped".equals(type)) {
            this.sink.figureGraphics("images/icon_warning_sml.gif");
        } else if (type.startsWith("success")) {
            this.sink.figureGraphics("images/icon_success_sml.gif");
        } else {
            this.sink.figureGraphics("images/icon_error_sml.gif");
        }
    }

    private void sinkCellAnchor(String text, String anchor) {
        this.sink.tableCell();
        this.sinkAnchor(anchor);
        this.sink.text(text);
        this.sink.tableCell_();
    }

    private void sinkAnchor(String anchor) {
        this.sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_START, (SinkEventAttributes)new SinkEventAttributeSet(new String[]{"id", anchor}));
        this.sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_END, null);
    }

    private void sinkLink(String href) {
        this.sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_START, (SinkEventAttributes)new SinkEventAttributeSet(new String[]{"href", href}));
    }

    private void sinkLink_() {
        this.sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_END, null);
    }

    private String javascriptToggleDisplayCode() {
        return "function toggleDisplay(elementId) {" + Markup.EOL + " var elm = document.getElementById(elementId + '-error');" + Markup.EOL + " if (elm == null) {" + Markup.EOL + "  elm = document.getElementById(elementId + '-failure');" + Markup.EOL + " }" + Markup.EOL + " if (elm && typeof elm.style != \"undefined\") {" + Markup.EOL + "  if (elm.style.display == \"none\") {" + Markup.EOL + "   elm.style.display = \"\";" + Markup.EOL + "   document.getElementById(elementId + '-off').style.display = \"none\";" + Markup.EOL + "   document.getElementById(elementId + '-on').style.display = \"inline\";" + Markup.EOL + "  } else if (elm.style.display == \"\") {   elm.style.display = \"none\";" + Markup.EOL + "   document.getElementById(elementId + '-off').style.display = \"inline\";" + Markup.EOL + "   document.getElementById(elementId + '-on').style.display = \"none\";" + Markup.EOL + "  }" + Markup.EOL + " }" + Markup.EOL + " }";
    }
}

